/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.externalSystem;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.pom.java.LanguageLevel;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaProjectData
extends AbstractExternalEntityData {
    public static final Key<JavaProjectData> KEY = Key.create(JavaProjectData.class, (int)(ProjectKeys.PROJECT.getProcessingWeight() + 1));
    private static final Logger LOG = Logger.getInstance((String)("#" + JavaProjectData.class.getName()));
    private static final long serialVersionUID = 1L;
    private static final LanguageLevel DEFAULT_LANGUAGE_LEVEL = LanguageLevel.JDK_1_6;
    private static final JavaSdkVersion DEFAULT_JDK_VERSION = JavaSdkVersion.JDK_1_6;
    private static final Pattern JDK_VERSION_PATTERN = Pattern.compile(".*1.(\\d+).*");
    @NotNull
    private JavaSdkVersion myJdkVersion = DEFAULT_JDK_VERSION;
    @NotNull
    private LanguageLevel myLanguageLevel = DEFAULT_LANGUAGE_LEVEL;
    @NotNull
    private String myCompileOutputPath;

    public JavaProjectData(@NotNull ProjectSystemId owner, @NotNull String compileOutputPath) {
        super(owner);
        this.myCompileOutputPath = compileOutputPath;
    }

    @NotNull
    public String getCompileOutputPath() {
        return this.myCompileOutputPath;
    }

    public void setCompileOutputPath(@NotNull String compileOutputPath) {
        this.myCompileOutputPath = ExternalSystemApiUtil.toCanonicalPath((String)compileOutputPath);
    }

    @NotNull
    public JavaSdkVersion getJdkVersion() {
        return this.myJdkVersion;
    }

    public void setJdkVersion(@NotNull JavaSdkVersion jdkVersion) {
        this.myJdkVersion = jdkVersion;
    }

    public void setJdkVersion(@Nullable String jdk) {
        if (jdk == null) {
            return;
        }
        try {
            int version = Integer.parseInt(jdk.trim());
            if (this.applyJdkVersion(version)) {
                return;
            }
        }
        catch (NumberFormatException version) {
            // empty catch block
        }
        Matcher matcher = JDK_VERSION_PATTERN.matcher(jdk);
        if (!matcher.matches()) {
            return;
        }
        String versionAsString = matcher.group(1);
        try {
            this.applyJdkVersion(Integer.parseInt(versionAsString));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public boolean applyJdkVersion(int version) {
        if (version < 0 || version >= JavaSdkVersion.values().length) {
            LOG.warn(String.format("Unsupported jdk version detected (%d). Expected to get number from range [0; %d]", version, JavaSdkVersion.values().length));
            return false;
        }
        for (JavaSdkVersion sdkVersion : JavaSdkVersion.values()) {
            if (sdkVersion.ordinal() != version) continue;
            this.myJdkVersion = sdkVersion;
            return true;
        }
        assert (false) : version + ", max value: " + JavaSdkVersion.values().length;
        return false;
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        return this.myLanguageLevel;
    }

    public void setLanguageLevel(@NotNull LanguageLevel level) {
        this.myLanguageLevel = level;
    }

    public void setLanguageLevel(@Nullable String languageLevel) {
        LanguageLevel level = LanguageLevel.parse((String)languageLevel);
        if (level != null) {
            this.myLanguageLevel = level;
        }
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myJdkVersion.hashCode();
        result = 31 * result + this.myLanguageLevel.hashCode();
        result = 31 * result + this.myCompileOutputPath.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JavaProjectData project2 = (JavaProjectData)((Object)o);
        if (!this.myCompileOutputPath.equals(project2.myCompileOutputPath)) {
            return false;
        }
        if (this.myJdkVersion != project2.myJdkVersion) {
            return false;
        }
        return this.myLanguageLevel == project2.myLanguageLevel;
    }

    public String toString() {
        return "java project";
    }
}

