/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.extapi.psi;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.Navigatable;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.IncorrectOperationException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiElementBase
extends ElementBase
implements NavigatablePsiElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.extapi.psi.PsiElementBase");

    public PsiElement copy() {
        return (PsiElement)this.clone();
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName());
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName());
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName());
    }

    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName());
    }

    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName());
    }

    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName());
    }

    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName());
    }

    public void delete() throws IncorrectOperationException {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName());
    }

    public void checkDelete() throws IncorrectOperationException {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName());
    }

    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName());
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName());
    }

    public PsiReference getReference() {
        return null;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        return true;
    }

    @NotNull
    public Project getProject() {
        PsiManager manager = this.getManager();
        if (manager == null) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        return manager.getProject();
    }

    public PsiManager getManager() {
        PsiElement parent = this.getParent();
        return parent != null ? parent.getManager() : null;
    }

    public PsiFile getContainingFile() {
        PsiElement parent = this.getParent();
        if (parent == null) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        return parent.getContainingFile();
    }

    public PsiReference findReferenceAt(int offset) {
        return SharedPsiElementImplUtil.findReferenceAt((PsiElement)this, offset);
    }

    @NotNull
    public PsiElement getNavigationElement() {
        return this;
    }

    public PsiElement getOriginalElement() {
        return this;
    }

    public boolean textMatches(@NotNull CharSequence text) {
        return Comparing.equal((CharSequence)this.getText(), (CharSequence)text, (boolean)true);
    }

    public boolean textMatches(@NotNull PsiElement element) {
        return this.getText().equals(element.getText());
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        visitor.visitElement((PsiElement)this);
    }

    public void acceptChildren(@NotNull PsiElementVisitor visitor) {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            child.accept(visitor);
        }
    }

    public boolean isValid() {
        PsiElement parent = this.getParent();
        return parent != null && parent.isValid();
    }

    public boolean isWritable() {
        PsiElement parent = this.getParent();
        return parent != null && parent.isWritable();
    }

    @NotNull
    public PsiReference[] getReferences() {
        return SharedPsiElementImplUtil.getReferences((PsiElement)this);
    }

    public PsiElement getContext() {
        return this.getParent();
    }

    public boolean isPhysical() {
        PsiElement parent = this.getParent();
        return parent != null && parent.isPhysical();
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        return ResolveScopeManager.getElementResolveScope((PsiElement)this);
    }

    @NotNull
    public SearchScope getUseScope() {
        return ResolveScopeManager.getElementUseScope((PsiElement)this);
    }

    public ItemPresentation getPresentation() {
        return null;
    }

    public String getName() {
        return null;
    }

    public void navigate(boolean requestFocus) {
        Navigatable descriptor = PsiNavigationSupport.getInstance().getDescriptor((PsiElement)this);
        if (descriptor != null) {
            descriptor.navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        Navigatable descriptor = PsiNavigationSupport.getInstance().getDescriptor((PsiElement)this);
        return descriptor != null && descriptor.canNavigateToSource();
    }

    @NotNull
    protected <T> T[] findChildrenByClass(Class<T> aClass) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!aClass.isInstance(cur)) continue;
            result.add(cur);
        }
        return result.toArray((Object[])Array.newInstance(aClass, result.size()));
    }

    @Nullable
    protected <T> T findChildByClass(Class<T> aClass) {
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!aClass.isInstance(cur)) continue;
            return (T)cur;
        }
        return null;
    }

    @NotNull
    protected <T> T findNotNullChildByClass(Class<T> aClass) {
        return this.notNullChild(this.findChildByClass(aClass));
    }

    @NotNull
    protected <T> T notNullChild(T child) {
        if (child == null) {
            LOG.error(this.getText() + "\n parent=" + this.getParent().getText());
        }
        return child;
    }

    public boolean isEquivalentTo(PsiElement another) {
        return this == another;
    }
}

