/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.extapi.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ASTDelegatePsiElement
extends PsiElementBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.extapi.psi.ASTDelegatePsiElement");
    private static final List EMPTY = Collections.emptyList();

    @Override
    public PsiFile getContainingFile() {
        return SharedImplUtil.getContainingFile(this.getNode());
    }

    @Override
    public PsiManagerEx getManager() {
        ASTDelegatePsiElement parent = this;
        while (parent instanceof ASTDelegatePsiElement) {
            parent = parent.getParent();
        }
        if (parent == null) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        return (PsiManagerEx)parent.getManager();
    }

    @NotNull
    public PsiElement[] getChildren() {
        PsiElement psiChild = this.getFirstChild();
        if (psiChild == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        while (psiChild != null) {
            if (psiChild.getNode() instanceof CompositeElement) {
                result.add(psiChild);
            }
            psiChild = psiChild.getNextSibling();
        }
        return PsiUtilCore.toPsiElementArray(result);
    }

    @Override
    public PsiElement getFirstChild() {
        return SharedImplUtil.getFirstChild(this.getNode());
    }

    @Override
    public PsiElement getLastChild() {
        return SharedImplUtil.getLastChild(this.getNode());
    }

    @Override
    public PsiElement getNextSibling() {
        return SharedImplUtil.getNextSibling(this.getNode());
    }

    @Override
    public PsiElement getPrevSibling() {
        return SharedImplUtil.getPrevSibling(this.getNode());
    }

    public TextRange getTextRange() {
        return this.getNode().getTextRange();
    }

    public int getStartOffsetInParent() {
        return this.getNode().getStartOffset() - this.getNode().getTreeParent().getStartOffset();
    }

    public int getTextLength() {
        return this.getNode().getTextLength();
    }

    public PsiElement findElementAt(int offset) {
        ASTNode treeElement = this.getNode().findLeafElementAt(offset);
        return SourceTreeToPsiMap.treeElementToPsi(treeElement);
    }

    public int getTextOffset() {
        return this.getNode().getStartOffset();
    }

    public String getText() {
        return this.getNode().getText();
    }

    @NotNull
    public char[] textToCharArray() {
        return this.getNode().getText().toCharArray();
    }

    @Override
    public boolean textContains(char c) {
        return this.getNode().textContains(c);
    }

    public <T> T getCopyableUserData(@NotNull Key<T> key) {
        return (T)this.getNode().getCopyableUserData(key);
    }

    public <T> void putCopyableUserData(@NotNull Key<T> key, T value) {
        this.getNode().putCopyableUserData(key, value);
    }

    @NotNull
    public abstract ASTNode getNode();

    public void subtreeChanged() {
    }

    @NotNull
    public Language getLanguage() {
        return this.getNode().getElementType().getLanguage();
    }

    @Nullable
    protected <T extends PsiElement> T findChildByType(IElementType type) {
        ASTNode node = this.getNode().findChildByType(type);
        return (T)(node == null ? null : node.getPsi());
    }

    @Nullable
    protected <T extends PsiElement> T findLastChildByType(IElementType type) {
        for (PsiElement child = this.getLastChild(); child != null; child = child.getPrevSibling()) {
            ASTNode node = child.getNode();
            if (node == null || node.getElementType() != type) continue;
            return (T)child;
        }
        return null;
    }

    @NotNull
    protected <T extends PsiElement> T findNotNullChildByType(IElementType type) {
        return (T)((PsiElement)this.notNullChild(this.findChildByType(type)));
    }

    @Nullable
    protected <T extends PsiElement> T findChildByType(TokenSet type) {
        ASTNode node = this.getNode().findChildByType(type);
        return (T)(node == null ? null : node.getPsi());
    }

    @NotNull
    protected <T extends PsiElement> T findNotNullChildByType(TokenSet type) {
        return (T)((PsiElement)this.notNullChild(this.findChildByType(type)));
    }

    @Nullable
    protected PsiElement findChildByFilter(TokenSet tokenSet) {
        ASTNode[] nodes = this.getNode().getChildren(tokenSet);
        return nodes.length == 0 ? null : nodes[0].getPsi();
    }

    protected <T extends PsiElement> T[] findChildrenByType(IElementType elementType, Class<T> arrayClass) {
        return (PsiElement[])ContainerUtil.map2Array((Object[])SharedImplUtil.getChildrenOfType(this.getNode(), elementType), arrayClass, (Function)new Function<ASTNode, T>(){

            public T fun(ASTNode s) {
                return s.getPsi();
            }
        });
    }

    protected <T extends PsiElement> List<T> findChildrenByType(TokenSet elementType) {
        ArrayList<PsiElement> result = EMPTY;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (!elementType.contains(tt)) continue;
            if (result == EMPTY) {
                result = new ArrayList<PsiElement>();
            }
            result.add(child.getPsi());
        }
        return result;
    }

    protected <T extends PsiElement> List<T> findChildrenByType(IElementType elementType) {
        ArrayList<PsiElement> result = EMPTY;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (elementType != child.getElementType()) continue;
            if (result == EMPTY) {
                result = new ArrayList<PsiElement>();
            }
            result.add(child.getPsi());
        }
        return result;
    }

    protected <T extends PsiElement> T[] findChildrenByType(TokenSet elementType, Class<T> arrayClass) {
        return (PsiElement[])ContainerUtil.map2Array((Object[])this.getNode().getChildren(elementType), arrayClass, (Function)new Function<ASTNode, T>(){

            public T fun(ASTNode s) {
                return s.getPsi();
            }
        });
    }

    @Override
    public PsiElement copy() {
        return this.getNode().copyElement().getPsi();
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        return this.addInnerBefore(element, null);
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        return this.addInnerBefore(element, anchor);
    }

    private PsiElement addInnerBefore(PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        ASTNode treeElement = this.addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.TRUE);
        if (treeElement != null) {
            if (treeElement instanceof TreeElement) {
                return ChangeUtil.decodeInformation((TreeElement)treeElement).getPsi();
            }
            return treeElement.getPsi();
        }
        throw new IncorrectOperationException("Element cannot be added");
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        ASTNode treeElement = this.addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.FALSE);
        if (treeElement instanceof TreeElement) {
            return ChangeUtil.decodeInformation((TreeElement)treeElement).getPsi();
        }
        return treeElement.getPsi();
    }

    @Override
    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
    }

    public ASTNode addInternal(ASTNode first, ASTNode last, ASTNode anchor, Boolean before) {
        return CodeEditUtil.addChildren(this.getNode(), first, last, this.getAnchorNode(anchor, before));
    }

    @Override
    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        return SharedImplUtil.addRange((PsiElement)this, first, last, null, null);
    }

    @Override
    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        return SharedImplUtil.addRange((PsiElement)this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.TRUE);
    }

    @Override
    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        return SharedImplUtil.addRange((PsiElement)this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.FALSE);
    }

    @Override
    public void delete() throws IncorrectOperationException {
        PsiElement parent = this.getParent();
        if (parent instanceof ASTDelegatePsiElement) {
            CheckUtil.checkWritable((PsiElement)this);
            ((ASTDelegatePsiElement)parent).deleteChildInternal(this.getNode());
        } else if (parent instanceof CompositeElement) {
            CheckUtil.checkWritable((PsiElement)this);
            ((CompositeElement)parent).deleteChildInternal(this.getNode());
        } else if (parent instanceof PsiFile) {
            CheckUtil.checkWritable((PsiElement)this);
            parent.deleteChildRange((PsiElement)this, (PsiElement)this);
        } else {
            throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName() + " under " + (parent == null ? "null" : parent.getClass().getName()));
        }
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        CodeEditUtil.removeChild(this.getNode(), child);
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
    }

    @Override
    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
        ASTNode firstElement = SourceTreeToPsiMap.psiElementToTree(first);
        ASTNode lastElement = SourceTreeToPsiMap.psiElementToTree(last);
        LOG.assertTrue(firstElement.getTreeParent() == this.getNode());
        LOG.assertTrue(lastElement.getTreeParent() == this.getNode());
        CodeEditUtil.removeChildren(this.getNode(), firstElement, lastElement);
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
        TreeElement elementCopy = ChangeUtil.copyToElement(newElement);
        if (this.getParent() instanceof ASTDelegatePsiElement) {
            ASTDelegatePsiElement parentElement = (ASTDelegatePsiElement)this.getParent();
            parentElement.replaceChildInternal((PsiElement)this, elementCopy);
        } else {
            CodeEditUtil.replaceChild(this.getParent().getNode(), this.getNode(), elementCopy);
        }
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    public void replaceChildInternal(PsiElement child, TreeElement newElement) {
        CodeEditUtil.replaceChild(this.getNode(), child.getNode(), newElement);
    }

    private ASTNode getAnchorNode(ASTNode anchor, Boolean before) {
        ASTNode anchorBefore = anchor != null ? (before != false ? anchor : anchor.getTreeNext()) : (before != null && before == false ? this.getNode().getFirstChildNode() : null);
        return anchorBefore;
    }
}

