/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.configurations.SimpleProgramParameters;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgramParametersConfigurator {
    public void configureConfiguration(SimpleProgramParameters parameters, CommonProgramRunConfigurationParameters configuration) {
        Project project2 = configuration.getProject();
        Module module2 = this.getModule(configuration);
        parameters.getProgramParametersList().addParametersString(this.expandPath(configuration.getProgramParameters(), module2, project2));
        parameters.setWorkingDirectory(this.getWorkingDir(configuration, project2, module2));
        HashMap<String, String> envs = new HashMap<String, String>(configuration.getEnvs());
        EnvironmentUtil.inlineParentOccurrences(envs);
        for (Map.Entry entry : envs.entrySet()) {
            entry.setValue(this.expandPath((String)entry.getValue(), module2, project2));
        }
        parameters.setEnv(envs);
        parameters.setPassParentEnvs(configuration.isPassParentEnvs());
    }

    @Nullable
    public String getWorkingDir(CommonProgramRunConfigurationParameters configuration, Project project2, Module module2) {
        String workingDirectory = configuration.getWorkingDirectory();
        String defaultWorkingDir = this.getDefaultWorkingDir(project2);
        if (StringUtil.isEmptyOrSpaces((String)workingDirectory) && (workingDirectory = defaultWorkingDir) == null) {
            return null;
        }
        if (!FileUtil.isAbsolute((String)(workingDirectory = this.expandPath(workingDirectory, module2, project2))) && defaultWorkingDir != null) {
            if ("$MODULE_DIR$".equals(workingDirectory)) {
                return defaultWorkingDir;
            }
            workingDirectory = defaultWorkingDir + "/" + workingDirectory;
        }
        return workingDirectory;
    }

    @Nullable
    protected String getDefaultWorkingDir(@NotNull Project project2) {
        return PathUtil.getLocalPath((VirtualFile)project2.getBaseDir());
    }

    public void checkWorkingDirectoryExist(CommonProgramRunConfigurationParameters configuration, Project project2, Module module2) throws RuntimeConfigurationWarning {
        String workingDir = this.getWorkingDir(configuration, project2, module2);
        if (workingDir == null) {
            throw new RuntimeConfigurationWarning("Working directory is null for project '" + project2.getName() + "' (" + project2.getBasePath() + ")" + ", module '" + module2.getName() + "' (" + module2.getModuleFilePath() + ")");
        }
        if (!new File(workingDir).exists()) {
            throw new RuntimeConfigurationWarning("Working directory '" + workingDir + "' doesn't exist");
        }
    }

    protected String expandPath(String path, Module module2, Project project2) {
        path = PathMacroManager.getInstance((ComponentManager)project2).expandPath(path);
        if (module2 != null) {
            path = PathMacroManager.getInstance((ComponentManager)module2).expandPath(path);
        }
        return path;
    }

    @Nullable
    protected Module getModule(CommonProgramRunConfigurationParameters configuration) {
        if (configuration instanceof ModuleBasedConfiguration) {
            return ((ModuleBasedConfiguration)configuration).getConfigurationModule().getModule();
        }
        return null;
    }
}

