/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.impl;

import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.LayoutAttractionPolicy;
import com.intellij.execution.ui.layout.LayoutStateDefaults;
import com.intellij.execution.ui.layout.LayoutViewOptions;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.execution.ui.layout.impl.RunnerLayout;
import com.intellij.execution.ui.layout.impl.RunnerLayoutSettings;
import com.intellij.execution.ui.layout.impl.ViewImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithActions;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.switcher.QuickActionProvider;
import com.intellij.ui.switcher.SwitchProvider;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunnerLayoutUiImpl
implements Disposable.Parent,
RunnerLayoutUi,
LayoutStateDefaults,
LayoutViewOptions,
DataProvider {
    private final RunnerLayout myLayout;
    private final RunnerContentUi myContentUI;
    private final ContentManager myViewsContentManager;
    public static final Key<String> CONTENT_TYPE = Key.create((String)"ContentType");

    public RunnerLayoutUiImpl(@NotNull Project project2, @NotNull Disposable parent, @NotNull String runnerId, @NotNull String runnerTitle, @NotNull String sessionName) {
        this.myLayout = RunnerLayoutSettings.getInstance().getLayout(runnerId);
        Disposer.register((Disposable)parent, (Disposable)this);
        this.myContentUI = new RunnerContentUi(project2, this, ActionManager.getInstance(), IdeFocusManager.getInstance((Project)project2), this.myLayout, runnerTitle + " - " + sessionName);
        Disposer.register((Disposable)this, (Disposable)this.myContentUI);
        this.myViewsContentManager = RunnerLayoutUiImpl.getContentFactory().createContentManager(this.myContentUI.getContentUI(), true, project2);
        this.myViewsContentManager.addDataProvider((DataProvider)this);
        Disposer.register((Disposable)this, (Disposable)this.myViewsContentManager);
    }

    @NotNull
    public LayoutViewOptions setTopToolbar(@NotNull ActionGroup actions, @NotNull String place) {
        this.myContentUI.setTopActions(actions, place);
        return this;
    }

    @NotNull
    public LayoutStateDefaults initTabDefaults(int id, String text, Icon icon) {
        this.getLayout().setDefault(id, text, icon);
        return this;
    }

    @NotNull
    public LayoutStateDefaults initFocusContent(@NotNull String id, @NotNull String condition) {
        return this.initFocusContent(id, condition, (LayoutAttractionPolicy)new LayoutAttractionPolicy.FocusOnce());
    }

    @NotNull
    public LayoutStateDefaults initFocusContent(@NotNull String id, @NotNull String condition, @NotNull LayoutAttractionPolicy policy) {
        this.getLayout().setDefaultToFocus(id, condition, policy);
        return this;
    }

    @NotNull
    public Content addContent(@NotNull Content content) {
        return this.addContent(content, false, -1, PlaceInGrid.center, false);
    }

    @NotNull
    public Content addContent(@NotNull Content content, int defaultTabId, @NotNull PlaceInGrid defaultPlace, boolean defaultIsMinimized) {
        return this.addContent(content, true, defaultTabId, defaultPlace, defaultIsMinimized);
    }

    public Content addContent(@NotNull Content content, boolean applyDefaults, int defaultTabId, @NotNull PlaceInGrid defaultPlace, boolean defaultIsMinimized) {
        String id = (String)content.getUserData(CONTENT_TYPE);
        assert (id != null) : "Content id is missing, use RunnerLayoutUi to create content instances";
        if (applyDefaults) {
            this.getLayout().setDefault(id, defaultTabId, defaultPlace, defaultIsMinimized);
        }
        this.getContentManager().addContent(content);
        return content;
    }

    @NotNull
    public Content createContent(@NotNull String id, @NotNull JComponent component, @NotNull String displayName, @Nullable Icon icon, @Nullable JComponent focusable) {
        return this.createContent(id, (ComponentWithActions)new ComponentWithActions.Impl(component), displayName, icon, focusable);
    }

    @NotNull
    public Content createContent(@NotNull String contentId, @NotNull ComponentWithActions withActions, @NotNull String displayName, @Nullable Icon icon, @Nullable JComponent toFocus) {
        Content content = RunnerLayoutUiImpl.getContentFactory().createContent(withActions.getComponent(), displayName, false);
        content.putUserData(CONTENT_TYPE, (Object)contentId);
        content.putUserData(ViewImpl.ID, (Object)contentId);
        content.setIcon(icon);
        if (toFocus != null) {
            content.setPreferredFocusableComponent(toFocus);
        }
        if (!withActions.isContentBuiltIn()) {
            content.setSearchComponent(withActions.getSearchComponent());
            content.setActions(withActions.getToolbarActions(), withActions.getToolbarPlace(), withActions.getToolbarContextComponent());
        }
        return content;
    }

    @NotNull
    public JComponent getComponent() {
        return this.myViewsContentManager.getComponent();
    }

    private static ContentFactory getContentFactory() {
        return ContentFactory.SERVICE.getInstance();
    }

    public RunnerLayout getLayout() {
        return this.myLayout;
    }

    public void updateActionsNow() {
        this.myContentUI.updateActionsImmediately();
    }

    public void beforeTreeDispose() {
        this.myContentUI.saveUiState();
    }

    public void dispose() {
    }

    @NotNull
    public ContentManager getContentManager() {
        return this.myViewsContentManager;
    }

    @NotNull
    public ActionCallback selectAndFocus(@Nullable Content content, boolean requestFocus, boolean forced) {
        return this.selectAndFocus(content, requestFocus, forced, false);
    }

    @NotNull
    public ActionCallback selectAndFocus(@Nullable Content content, boolean requestFocus, boolean forced, boolean implicit) {
        if (content == null) {
            return ActionCallback.REJECTED;
        }
        return this.getContentManager(content).setSelectedContent(content, requestFocus || this.shouldRequestFocus(), forced, implicit);
    }

    private ContentManager getContentManager(@NotNull Content content) {
        return this.myContentUI.getContentManager(content);
    }

    private boolean shouldRequestFocus() {
        Component focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return focused != null && SwingUtilities.isDescendingFrom(focused, this.getContentManager().getComponent());
    }

    public boolean removeContent(@Nullable Content content, boolean dispose) {
        return content != null && this.getContentManager().removeContent(content, dispose);
    }

    public boolean isToFocus(@NotNull Content content, @NotNull String condition) {
        String id = (String)content.getUserData(ViewImpl.ID);
        return this.getLayout().isToFocus(id, condition);
    }

    @NotNull
    public LayoutViewOptions setToFocus(@Nullable Content content, @NotNull String condition) {
        this.getLayout().setToFocus(content != null ? (String)content.getUserData(ViewImpl.ID) : null, condition);
        return this;
    }

    public void attractBy(@NotNull String condition) {
        this.myContentUI.attractByCondition(condition, true);
    }

    public void clearAttractionBy(@NotNull String condition) {
        this.myContentUI.clearAttractionByCondition(condition, true);
    }

    public void removeContent(@NotNull String id, boolean dispose) {
        Content content = this.findContent(id);
        if (content != null) {
            this.getContentManager().removeContent(content, dispose);
        }
    }

    public AnAction getLayoutActions() {
        return this.myContentUI.getLayoutActions();
    }

    @NotNull
    public AnAction[] getLayoutActionsList() {
        ActionGroup group = (ActionGroup)this.getLayoutActions();
        return group.getChildren(null);
    }

    @NotNull
    public LayoutViewOptions setTabPopupActions(@NotNull ActionGroup group) {
        this.myContentUI.setTabPopupActions(group);
        return this;
    }

    @NotNull
    public LayoutViewOptions setLeftToolbar(@NotNull ActionGroup leftToolbar, @NotNull String place) {
        this.myContentUI.setLeftToolbar(leftToolbar, place);
        return this;
    }

    @Nullable
    public Content findContent(@NotNull String key) {
        return this.myContentUI.findContent(key);
    }

    @NotNull
    public RunnerLayoutUi addListener(final @NotNull ContentManagerListener listener2, @NotNull Disposable parent) {
        final ContentManager mgr = this.getContentManager();
        mgr.addContentManagerListener(listener2);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                mgr.removeContentManagerListener(listener2);
            }
        });
        return this;
    }

    public void removeListener(@NotNull ContentManagerListener listener2) {
        this.getContentManager().removeContentManagerListener(listener2);
    }

    public void setBouncing(@NotNull Content content, boolean activate) {
        this.myContentUI.processBounce(content, activate);
    }

    public boolean isDisposed() {
        return this.getContentManager().isDisposed();
    }

    @NotNull
    public LayoutViewOptions setMinimizeActionEnabled(boolean enabled) {
        this.myContentUI.setMinimizeActionEnabled(enabled);
        return this;
    }

    public LayoutViewOptions setToDisposeRemoveContent(boolean toDispose) {
        this.myContentUI.setToDisposeRemovedContent(toDispose);
        return this;
    }

    @NotNull
    public LayoutViewOptions setMoveToGridActionEnabled(boolean enabled) {
        this.myContentUI.setMovetoGridActionEnabled(enabled);
        return this;
    }

    @NotNull
    public LayoutViewOptions setAttractionPolicy(@NotNull String contentId, LayoutAttractionPolicy policy) {
        this.myContentUI.setPolicy(contentId, policy);
        return this;
    }

    @NotNull
    public LayoutViewOptions setConditionAttractionPolicy(@NotNull String condition, LayoutAttractionPolicy policy) {
        this.myContentUI.setConditionPolicy(condition, policy);
        return this;
    }

    @NotNull
    public LayoutStateDefaults getDefaults() {
        return this;
    }

    @NotNull
    public LayoutViewOptions getOptions() {
        return this;
    }

    @NotNull
    public LayoutViewOptions setAdditionalFocusActions(@NotNull ActionGroup group) {
        this.myContentUI.setAdditionalFocusActions(group);
        return this;
    }

    public AnAction getSettingsActions() {
        return this.myContentUI.getSettingsActions();
    }

    @NotNull
    public AnAction[] getSettingsActionsList() {
        ActionGroup group = (ActionGroup)this.getSettingsActions();
        return group.getChildren(null);
    }

    @NotNull
    public Content[] getContents() {
        Content[] contents = new Content[this.getContentManager().getContentCount()];
        for (int i = 0; i < contents.length; ++i) {
            contents[i] = this.getContentManager().getContent(i);
        }
        return contents;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (SwitchProvider.KEY.is(dataId) || QuickActionProvider.KEY.is(dataId) || RunnerContentUi.KEY.is(dataId)) {
            return this.myContentUI;
        }
        return null;
    }
}

