/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.ui;

import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.ui.BaseTestProxyNodeDescriptor;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.IndexComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.StatusBarProgress;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.config.AbstractProperty;
import java.util.Comparator;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTestTreeBuilder
extends AbstractTreeBuilder {
    public AbstractTestTreeBuilder(JTree tree, DefaultTreeModel defaultTreeModel, AbstractTreeStructure structure, IndexComparator instance) {
        super(tree, defaultTreeModel, structure, (Comparator)instance);
    }

    public AbstractTestTreeBuilder() {
    }

    public void repaintWithParents(AbstractTestProxy testProxy) {
        AbstractTestProxy current = testProxy;
        do {
            DefaultMutableTreeNode node;
            if ((node = this.getNodeForElement(current)) == null) continue;
            JTree tree = this.getTree();
            ((DefaultTreeModel)tree.getModel()).nodeChanged(node);
        } while ((current = current.getParent()) != null);
    }

    protected boolean isAlwaysShowPlus(NodeDescriptor descriptor) {
        return false;
    }

    @NotNull
    protected ProgressIndicator createProgressIndicator() {
        return new StatusBarProgress();
    }

    protected boolean isSmartExpand() {
        return false;
    }

    public void setTestsComparator(boolean sortAlphabetically) {
        this.setNodeDescriptorComparator((Comparator)(sortAlphabetically ? AlphaComparator.INSTANCE : null));
        this.queueUpdate();
    }

    public void setStatisticsComparator(TestConsoleProperties properties, boolean sortByStatistics) {
        if (!sortByStatistics) {
            this.setTestsComparator(TestConsoleProperties.SORT_ALPHABETICALLY.value((AbstractProperty.AbstractPropertyContainer)properties));
        } else {
            this.setNodeDescriptorComparator(new Comparator<NodeDescriptor>(){

                @Override
                public int compare(NodeDescriptor o1, NodeDescriptor o2) {
                    if (o1.getParentDescriptor() == o2.getParentDescriptor() && o1 instanceof BaseTestProxyNodeDescriptor && o2 instanceof BaseTestProxyNodeDescriptor) {
                        Long d1 = ((AbstractTestProxy)((BaseTestProxyNodeDescriptor)o1).getElement()).getDuration();
                        Long d2 = ((AbstractTestProxy)((BaseTestProxyNodeDescriptor)o2).getElement()).getDuration();
                        return Comparing.compare((Comparable)d2, (Comparable)d1);
                    }
                    return 0;
                }
            });
        }
        this.queueUpdate();
    }
}

