/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.ui;

import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.PoolOfTestIcons;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.execution.testframework.sm.SMTestsRunnerBundle;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.execution.testframework.sm.runner.ui.SMPoolOfTestIcons;
import com.intellij.execution.testframework.sm.runner.ui.TestTreeRenderer;
import com.intellij.execution.testframework.ui.TestsProgressAnimator;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestsPresentationUtil {
    @NonNls
    private static final String DOUBLE_SPACE = "  ";
    @NonNls
    private static final String DURATION_UNKNOWN = SMTestsRunnerBundle.message("sm.test.runner.ui.tabs.statistics.columns.duration.unknown", new Object[0]);
    @NonNls
    private static final String DURATION_NO_TESTS = SMTestsRunnerBundle.message("sm.test.runner.ui.tabs.statistics.columns.duration.no.tests", new Object[0]);
    @NonNls
    private static final String DURATION_NOT_RUN = SMTestsRunnerBundle.message("sm.test.runner.ui.tabs.statistics.columns.duration.not.run", new Object[0]);
    @NonNls
    private static final String DURATION_RUNNING_PREFIX = SMTestsRunnerBundle.message("sm.test.runner.ui.tabs.statistics.columns.duration.prefix.running", new Object[0]);
    @NonNls
    private static final String DURATION_TERMINATED_PREFIX = SMTestsRunnerBundle.message("sm.test.runner.ui.tabs.statistics.columns.duration.prefix.terminated", new Object[0]);
    @NonNls
    private static final String COLON = ": ";
    public static final SimpleTextAttributes PASSED_ATTRIBUTES = new SimpleTextAttributes(1, TestsUIUtil.PASSED_COLOR);
    public static final SimpleTextAttributes DEFFECT_ATTRIBUTES = new SimpleTextAttributes(1, Color.RED);
    public static final SimpleTextAttributes TERMINATED_ATTRIBUTES = new SimpleTextAttributes(1, Color.ORANGE);
    @NonNls
    private static final String RESULTS_NO_TESTS = SMTestsRunnerBundle.message("sm.test.runner.ui.tabs.statistics.columns.results.no.tests", new Object[0]);
    @NonNls
    private static final String NO_NAME_TEST = SMTestsRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.test.noname", new Object[0]);
    @NonNls
    private static final String UNKNOWN_TESTS_COUNT = "<...>";
    @NonNls
    static final String DEFAULT_TESTS_CATEGORY = "Tests";

    private TestsPresentationUtil() {
    }

    public static String getProgressStatus_Text(long startTime, long endTime, int testsTotal, int testsCount, int failuresCount, @Nullable Set<String> allCategories, boolean isFinished) {
        StringBuilder sb = new StringBuilder();
        if (endTime == 0L) {
            sb.append(SMTestsRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.running", new Object[0]));
        } else {
            sb.append(SMTestsRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.done", new Object[0]));
        }
        if (allCategories != null && TestsPresentationUtil.hasNonDefaultCategories(allCategories)) {
            sb.append(' ');
            boolean first = true;
            for (String category : allCategories) {
                if (StringUtil.isEmpty((String)category)) continue;
                if (!first) {
                    sb.append(", ");
                }
                char firstChar = category.charAt(0);
                sb.append(first ? firstChar : Character.toLowerCase(firstChar));
                sb.append(category.substring(1));
                first = false;
            }
        }
        sb.append(' ').append(testsCount).append(' ');
        sb.append(SMTestsRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.of", new Object[0]));
        sb.append(' ').append(testsTotal != 0 ? Integer.valueOf(testsTotal) : (!isFinished ? UNKNOWN_TESTS_COUNT : Integer.valueOf(0)));
        if (failuresCount > 0) {
            sb.append(DOUBLE_SPACE);
            sb.append(SMTestsRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.failed", new Object[0]));
            sb.append(' ').append(failuresCount);
        }
        if (endTime != 0L) {
            long time = endTime - startTime;
            sb.append(DOUBLE_SPACE);
            sb.append('(').append(StringUtil.formatDuration((long)time)).append(')');
        }
        sb.append(DOUBLE_SPACE);
        return sb.toString();
    }

    public static boolean hasNonDefaultCategories(@Nullable Set<String> allCategories) {
        if (allCategories == null) {
            return false;
        }
        return allCategories.size() > 1 || allCategories.size() == 1 && !DEFAULT_TESTS_CATEGORY.equals(allCategories.iterator().next());
    }

    public static void formatRootNodeWithChildren(SMTestProxy.SMRootTestProxy testProxy, TestTreeRenderer renderer) {
        renderer.setIcon(TestsPresentationUtil.getIcon(testProxy, renderer.getConsoleProperties()));
        TestStateInfo.Magnitude magnitude = testProxy.getMagnitudeInfo();
        String presentableName = testProxy.getPresentation();
        String text = presentableName != null ? presentableName : (magnitude == TestStateInfo.Magnitude.RUNNING_INDEX ? SMTestsRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.running.tests", new Object[0]) : (magnitude == TestStateInfo.Magnitude.TERMINATED_INDEX ? SMTestsRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.was.terminated", new Object[0]) : SMTestsRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.test.results", new Object[0])));
        renderer.append(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        String comment = testProxy.getComment();
        if (comment != null) {
            renderer.append(" (" + comment + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    public static void formatRootNodeWithoutChildren(SMTestProxy.SMRootTestProxy testProxy, TestTreeRenderer renderer) {
        TestStateInfo.Magnitude magnitude = testProxy.getMagnitudeInfo();
        if (magnitude == TestStateInfo.Magnitude.RUNNING_INDEX) {
            if (!testProxy.getChildren().isEmpty()) {
                TestsPresentationUtil.formatRootNodeWithChildren(testProxy, renderer);
            } else {
                renderer.setIcon(TestsPresentationUtil.getIcon(testProxy, renderer.getConsoleProperties()));
                renderer.append(SMTestsRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.instantiating.tests", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        } else if (magnitude == TestStateInfo.Magnitude.NOT_RUN_INDEX) {
            renderer.setIcon(PoolOfTestIcons.NOT_RAN);
            renderer.append(SMTestsRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.not.test.results", new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
        } else if (magnitude == TestStateInfo.Magnitude.TERMINATED_INDEX) {
            renderer.setIcon(PoolOfTestIcons.TERMINATED_ICON);
            renderer.append(SMTestsRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.was.terminated", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        } else if (magnitude == TestStateInfo.Magnitude.PASSED_INDEX) {
            renderer.setIcon(PoolOfTestIcons.PASSED_ICON);
            renderer.append(SMTestsRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.all.tests.passed", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        } else if (!testProxy.getChildren().isEmpty()) {
            TestsPresentationUtil.formatRootNodeWithChildren(testProxy, renderer);
        } else {
            renderer.setIcon(PoolOfTestIcons.NOT_RAN);
            renderer.append(testProxy.isTestsReporterAttached() ? SMTestsRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.no.tests.were.found", new Object[0]) : SMTestsRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.test.reporter.not.attached", new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
        }
    }

    public static void formatTestProxy(SMTestProxy testProxy, TestTreeRenderer renderer) {
        renderer.setIcon(TestsPresentationUtil.getIcon(testProxy, renderer.getConsoleProperties()));
        renderer.append(testProxy.getPresentableName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    @NotNull
    public static String getPresentableName(SMTestProxy testProxy) {
        String parentName;
        SMTestProxy parent = testProxy.getParent();
        String name = testProxy.getName();
        if (name == null) {
            return NO_NAME_TEST;
        }
        String presentationCandidate = name;
        if (parent != null && (parentName = parent.getName()) != null) {
            String presentation;
            boolean parentStartsWith = name.startsWith(parentName);
            if (!parentStartsWith && parent instanceof SMTestProxy.SMRootTestProxy && (presentation = ((SMTestProxy.SMRootTestProxy)parent).getPresentation()) != null) {
                parentName = presentation;
                parentStartsWith = name.startsWith(parentName);
            }
            if (parentStartsWith) {
                presentationCandidate = name.substring(parentName.length());
                presentationCandidate = StringUtil.trimStart((String)presentationCandidate, (String)".");
            }
        }
        presentationCandidate = presentationCandidate.trim();
        if (StringUtil.isEmpty((String)(presentationCandidate = presentationCandidate.replaceAll("\\s+", " ")))) {
            return NO_NAME_TEST;
        }
        return presentationCandidate;
    }

    @NotNull
    public static String getPresentableNameTrimmedOnly(@NotNull SMTestProxy testProxy) {
        String name = testProxy.getName();
        if (name != null) {
            name = name.trim();
        }
        if (name == null || name.isEmpty()) {
            name = NO_NAME_TEST;
        }
        return name;
    }

    @Nullable
    private static Icon getIcon(SMTestProxy testProxy, TestConsoleProperties consoleProperties) {
        TestStateInfo.Magnitude magnitude = testProxy.getMagnitudeInfo();
        boolean hasErrors = testProxy.hasErrors();
        switch (magnitude) {
            case ERROR_INDEX: {
                return SMPoolOfTestIcons.ERROR_ICON;
            }
            case FAILED_INDEX: {
                return hasErrors ? SMPoolOfTestIcons.FAILED_E_ICON : SMPoolOfTestIcons.FAILED_ICON;
            }
            case IGNORED_INDEX: {
                return hasErrors ? SMPoolOfTestIcons.IGNORED_E_ICON : SMPoolOfTestIcons.IGNORED_ICON;
            }
            case NOT_RUN_INDEX: {
                return SMPoolOfTestIcons.NOT_RAN;
            }
            case COMPLETE_INDEX: 
            case PASSED_INDEX: {
                return hasErrors ? SMPoolOfTestIcons.PASSED_E_ICON : SMPoolOfTestIcons.PASSED_ICON;
            }
            case RUNNING_INDEX: {
                if (consoleProperties.isPaused()) {
                    return hasErrors ? SMPoolOfTestIcons.PAUSED_E_ICON : AllIcons.RunConfigurations.TestPaused;
                }
                int frameIndex = TestsProgressAnimator.getCurrentFrameIndex();
                return hasErrors ? SMPoolOfTestIcons.FRAMES_E[frameIndex] : TestsProgressAnimator.FRAMES[frameIndex];
            }
            case SKIPPED_INDEX: {
                return hasErrors ? SMPoolOfTestIcons.SKIPPED_E_ICON : SMPoolOfTestIcons.SKIPPED_ICON;
            }
            case TERMINATED_INDEX: {
                return hasErrors ? SMPoolOfTestIcons.TERMINATED_E_ICON : SMPoolOfTestIcons.TERMINATED_ICON;
            }
        }
        return null;
    }

    @Nullable
    public static String getTestStatusPresentation(SMTestProxy proxy) {
        return proxy.getMagnitudeInfo().getTitle();
    }

    public static void appendSuiteStatusColorPresentation(SMTestProxy proxy, ColoredTableCellRenderer renderer) {
        int passedCount = 0;
        int errorsCount = 0;
        int failedCount = 0;
        int ignoredCount = 0;
        if (proxy.isLeaf()) {
            renderer.append(RESULTS_NO_TESTS, proxy.wasLaunched() ? PASSED_ATTRIBUTES : DEFFECT_ATTRIBUTES);
            return;
        }
        List<SMTestProxy> allTestCases = proxy.getAllTests();
        for (SMTestProxy testOrSuite : allTestCases) {
            if (testOrSuite.isSuite()) continue;
            switch (testOrSuite.getMagnitudeInfo()) {
                case COMPLETE_INDEX: 
                case PASSED_INDEX: {
                    ++passedCount;
                    break;
                }
                case ERROR_INDEX: {
                    ++errorsCount;
                    break;
                }
                case FAILED_INDEX: {
                    ++failedCount;
                    break;
                }
                case IGNORED_INDEX: 
                case SKIPPED_INDEX: {
                    ++ignoredCount;
                    break;
                }
            }
        }
        String separator = " ";
        if (failedCount > 0) {
            renderer.append(SMTestsRunnerBundle.message("sm.test.runner.ui.tabs.statistics.columns.results.count.msg.failed", failedCount) + " ", DEFFECT_ATTRIBUTES);
        }
        if (errorsCount > 0) {
            renderer.append(SMTestsRunnerBundle.message("sm.test.runner.ui.tabs.statistics.columns.results.count.msg.errors", errorsCount) + " ", DEFFECT_ATTRIBUTES);
        }
        if (ignoredCount > 0) {
            renderer.append(SMTestsRunnerBundle.message("sm.test.runner.ui.tabs.statistics.columns.results.count.msg.ignored", ignoredCount) + " ", SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        }
        if (passedCount > 0) {
            renderer.append(SMTestsRunnerBundle.message("sm.test.runner.ui.tabs.statistics.columns.results.count.msg.passed", passedCount), PASSED_ATTRIBUTES);
        }
    }

    @Nullable
    public static String getDurationPresentation(SMTestProxy proxy) {
        switch (proxy.getMagnitudeInfo()) {
            case ERROR_INDEX: 
            case FAILED_INDEX: 
            case IGNORED_INDEX: 
            case COMPLETE_INDEX: 
            case PASSED_INDEX: 
            case SKIPPED_INDEX: {
                return TestsPresentationUtil.getDurationTimePresentation(proxy);
            }
            case NOT_RUN_INDEX: {
                return DURATION_NOT_RUN;
            }
            case RUNNING_INDEX: {
                return TestsPresentationUtil.getDurationWithPrefixPresentation(proxy, DURATION_RUNNING_PREFIX);
            }
            case TERMINATED_INDEX: {
                return TestsPresentationUtil.getDurationWithPrefixPresentation(proxy, DURATION_TERMINATED_PREFIX);
            }
        }
        return DURATION_UNKNOWN;
    }

    private static String getDurationWithPrefixPresentation(SMTestProxy proxy, String prefix) {
        if (proxy.getDuration() != null) {
            return prefix + COLON + TestsPresentationUtil.getDurationTimePresentation(proxy);
        }
        return '<' + prefix + '>';
    }

    private static String getDurationTimePresentation(SMTestProxy proxy) {
        Long duration = proxy.getDuration();
        if (duration == null) {
            return proxy.isSuite() && proxy.isLeaf() ? DURATION_NO_TESTS : DURATION_UNKNOWN;
        }
        return StringUtil.formatDuration((long)duration);
    }

    public static void appendTestStatusColorPresentation(SMTestProxy proxy, ColoredTableCellRenderer renderer) {
        String title = TestsPresentationUtil.getTestStatusPresentation(proxy);
        TestStateInfo.Magnitude info = proxy.getMagnitudeInfo();
        switch (info) {
            case COMPLETE_INDEX: 
            case PASSED_INDEX: {
                renderer.append(title, PASSED_ATTRIBUTES);
                break;
            }
            case RUNNING_INDEX: {
                renderer.append(title, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                break;
            }
            case NOT_RUN_INDEX: {
                renderer.append(title, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
                break;
            }
            case IGNORED_INDEX: 
            case SKIPPED_INDEX: {
                renderer.append(title, SimpleTextAttributes.EXCLUDED_ATTRIBUTES);
                break;
            }
            case ERROR_INDEX: 
            case FAILED_INDEX: {
                renderer.append(title, DEFFECT_ATTRIBUTES);
                break;
            }
            case TERMINATED_INDEX: {
                renderer.append(title, TERMINATED_ATTRIBUTES);
            }
        }
    }

    public static void printWithAnsiColoring(final @NotNull Printer printer, @NotNull String text, final @NotNull Key processOutputType) {
        AnsiEscapeDecoder decoder = new AnsiEscapeDecoder();
        decoder.escapeText(text, ProcessOutputTypes.STDOUT, new AnsiEscapeDecoder.ColoredTextAcceptor(){

            public void coloredTextAvailable(String text, Key attributes) {
                ConsoleViewContentType contentType = ConsoleViewContentType.getConsoleViewType((Key)attributes);
                if (contentType == null || contentType == ConsoleViewContentType.NORMAL_OUTPUT) {
                    contentType = ConsoleViewContentType.getConsoleViewType((Key)processOutputType);
                }
                printer.print(text, contentType);
            }
        });
    }
}

