/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.events;

import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TreeNodeEvent {
    private final String myName;
    private final int myId;

    public TreeNodeEvent(@Nullable String name, int id) {
        this.myName = name;
        this.myId = id;
        this.validate();
    }

    private void validate() {
        if (this.myId < -1) {
            this.fail("id should be greater than -2");
        }
    }

    protected void fail(@NotNull String message) {
        throw new IllegalStateException(message + ", " + this.toString());
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    public int getId() {
        return this.myId;
    }

    public final String toString() {
        StringBuilder buf = new StringBuilder(this.getClass().getSimpleName() + "{");
        TreeNodeEvent.append(buf, "name", this.myName);
        TreeNodeEvent.append(buf, "id", this.myId);
        this.appendToStringInfo(buf);
        buf.setLength(buf.length() - 2);
        buf.append("}");
        return buf.toString();
    }

    protected abstract void appendToStringInfo(@NotNull StringBuilder var1);

    protected static void append(@NotNull StringBuilder buffer, @NotNull String key, @Nullable Object value) {
        if (value != null) {
            buffer.append(key).append("=");
            if (value instanceof String) {
                buffer.append("'").append(value).append("'");
            } else {
                buffer.append(String.valueOf(value));
            }
            buffer.append(", ");
        }
    }

    public static int getNodeId(@NotNull ServiceMessage message) {
        return TreeNodeEvent.getIntAttribute(message, "nodeId");
    }

    public static int getIntAttribute(@NotNull ServiceMessage message, @NotNull String key) {
        String value = (String)message.getAttributes().get(key);
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }
}

