/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.events;

import com.intellij.execution.testframework.sm.runner.events.TreeNodeEvent;
import jetbrains.buildServer.messages.serviceMessages.BaseTestMessage;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import org.jetbrains.annotations.NotNull;

public class TestOutputEvent
extends TreeNodeEvent {
    private final String myText;
    private final boolean myStdOut;

    public TestOutputEvent(@NotNull BaseTestMessage message, @NotNull String text, boolean stdOut) {
        super(message.getTestName(), TreeNodeEvent.getNodeId((ServiceMessage)message));
        this.myText = text;
        this.myStdOut = stdOut;
    }

    public TestOutputEvent(@NotNull String testName, @NotNull String text, boolean stdOut) {
        super(testName, -1);
        this.myText = text;
        this.myStdOut = stdOut;
    }

    @NotNull
    public String getText() {
        return this.myText;
    }

    public boolean isStdOut() {
        return this.myStdOut;
    }

    @Override
    protected void appendToStringInfo(@NotNull StringBuilder buf) {
        TestOutputEvent.append(buf, "text", this.myText);
        TestOutputEvent.append(buf, "stdOut", this.myStdOut);
    }
}

