/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.events;

import com.intellij.execution.testframework.sm.SMTestsRunnerBundle;
import com.intellij.execution.testframework.sm.runner.events.TreeNodeEvent;
import com.intellij.openapi.util.text.StringUtil;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import jetbrains.buildServer.messages.serviceMessages.TestIgnored;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestIgnoredEvent
extends TreeNodeEvent {
    private final String myIgnoreComment;
    private final String myStacktrace;

    public TestIgnoredEvent(@NotNull String testName, @NotNull String ignoreComment, @Nullable String stacktrace) {
        super(testName, -1);
        this.myIgnoreComment = ignoreComment;
        this.myStacktrace = stacktrace;
    }

    public TestIgnoredEvent(@NotNull TestIgnored testIgnored, @Nullable String stacktrace) {
        super(testIgnored.getTestName(), TreeNodeEvent.getNodeId((ServiceMessage)testIgnored));
        this.myIgnoreComment = testIgnored.getIgnoreComment();
        this.myStacktrace = stacktrace;
    }

    @NotNull
    public String getIgnoreComment() {
        if (StringUtil.isEmpty((String)this.myIgnoreComment)) {
            return SMTestsRunnerBundle.message("sm.test.runner.states.test.is.ignored", new Object[0]);
        }
        return this.myIgnoreComment;
    }

    @Nullable
    public String getStacktrace() {
        return this.myStacktrace;
    }

    @Override
    protected void appendToStringInfo(@NotNull StringBuilder buf) {
        TestIgnoredEvent.append(buf, "ignoreComment", this.myIgnoreComment);
        TestIgnoredEvent.append(buf, "stacktrace", this.myStacktrace);
    }
}

