/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.events;

import com.intellij.execution.testframework.sm.runner.events.TreeNodeEvent;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import jetbrains.buildServer.messages.serviceMessages.TestFinished;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestFinishedEvent
extends TreeNodeEvent {
    private final long myDuration;
    private final String myOutputFile;

    public TestFinishedEvent(@NotNull TestFinished testFinished, long duration) {
        this(testFinished, duration, null);
    }

    public TestFinishedEvent(@NotNull TestFinished testFinished, long duration, String outputFile) {
        this(testFinished.getTestName(), TreeNodeEvent.getNodeId((ServiceMessage)testFinished), duration, outputFile);
    }

    public TestFinishedEvent(@Nullable String name, int id, long duration) {
        this(name, id, duration, null);
    }

    public TestFinishedEvent(@Nullable String name, int id, long duration, String outputFile) {
        super(name, id);
        this.myDuration = duration;
        this.myOutputFile = outputFile;
    }

    public TestFinishedEvent(@NotNull String name, long duration) {
        this(name, -1, duration);
    }

    public TestFinishedEvent(@NotNull String name, int duration) {
        this(name, -1, duration);
    }

    public long getDuration() {
        return this.myDuration;
    }

    @Override
    protected void appendToStringInfo(@NotNull StringBuilder buf) {
        TestFinishedEvent.append(buf, "duration", this.myDuration);
    }

    public String getOutputFile() {
        return this.myOutputFile;
    }
}

