/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.Location;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public interface SMTestLocator {
    @NotNull
    public List<Location> getLocation(@NotNull String var1, @NotNull String var2, @NotNull Project var3, @NotNull GlobalSearchScope var4);

    public static class Composite
    implements SMTestLocator,
    DumbAware {
        private final Map<String, ? extends SMTestLocator> myLocators;

        public Composite(@NotNull Pair<String, ? extends SMTestLocator> first, Pair<String, ? extends SMTestLocator> ... rest) {
            this.myLocators = ContainerUtil.newHashMap(first, rest);
        }

        public Composite(@NotNull Map<String, ? extends SMTestLocator> locators) {
            this.myLocators = ContainerUtil.newHashMap(locators);
        }

        @Override
        @NotNull
        public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project2, @NotNull GlobalSearchScope scope) {
            SMTestLocator locator = this.myLocators.get(protocol);
            if (locator != null && (!DumbService.isDumb((Project)project2) || DumbService.isDumbAware((Object)locator))) {
                return locator.getLocation(protocol, path, project2, scope);
            }
            return Collections.emptyList();
        }
    }
}

