/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.filters.CompositeFilter;
import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.actions.AbstractRerunFailedTestsAction;
import com.intellij.execution.testframework.sm.SMStacktraceParserEx;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.TestProxyFilterProvider;
import com.intellij.execution.testframework.sm.runner.history.actions.ImportTestsGroup;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.config.Storage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SMTRunnerConsoleProperties
extends TestConsoleProperties
implements SMStacktraceParserEx {
    private final RunProfile myConfiguration;
    @NotNull
    private final String myTestFrameworkName;
    private final CompositeFilter myCustomFilter;
    private boolean myIdBasedTestTree = false;
    private boolean myPrintTestingStartedTime = true;

    public SMTRunnerConsoleProperties(@NotNull RunConfiguration config, @NotNull String testFrameworkName, @NotNull Executor executor) {
        this(config.getProject(), (RunProfile)config, testFrameworkName, executor);
    }

    public SMTRunnerConsoleProperties(@NotNull Project project2, @NotNull RunProfile config, @NotNull String testFrameworkName, @NotNull Executor executor) {
        super((Storage)SMTRunnerConsoleProperties.getStorage(testFrameworkName), project2, executor);
        this.myConfiguration = config;
        this.myTestFrameworkName = testFrameworkName;
        this.myCustomFilter = new CompositeFilter(project2);
    }

    public SMTRunnerConsoleProperties(@NotNull RunConfiguration config, @NotNull String testFrameworkName, @NotNull Executor executor, boolean printTestingStartedTime) {
        this(config, testFrameworkName, executor);
        this.setPrintTestingStartedTime(printTestingStartedTime);
    }

    @NotNull
    private static Storage.PropertiesComponentStorage getStorage(String testFrameworkName) {
        return new Storage.PropertiesComponentStorage(testFrameworkName + "Support.", PropertiesComponent.getInstance());
    }

    @Override
    public RunProfile getConfiguration() {
        return this.myConfiguration;
    }

    @Override
    @Nullable
    protected AnAction createImportAction() {
        return new ImportTestsGroup(this);
    }

    public boolean isIdBasedTestTree() {
        return this.myIdBasedTestTree;
    }

    public void setIdBasedTestTree(boolean idBasedTestTree) {
        this.myIdBasedTestTree = idBasedTestTree;
    }

    public boolean isPrintTestingStartedTime() {
        return this.myPrintTestingStartedTime;
    }

    public void setPrintTestingStartedTime(boolean printTestingStartedTime) {
        this.myPrintTestingStartedTime = printTestingStartedTime;
    }

    @Override
    @Nullable
    public Navigatable getErrorNavigatable(@NotNull Location<?> location, @NotNull String stacktrace) {
        return this.getErrorNavigatable(location.getProject(), stacktrace);
    }

    @Override
    @Nullable
    public Navigatable getErrorNavigatable(final @NotNull Project project2, @NotNull String stacktrace) {
        String[] lines;
        if (this.myCustomFilter.isEmpty()) {
            return null;
        }
        int stacktraceLength = stacktrace.length();
        for (String line : lines = StringUtil.splitByLines((String)stacktrace)) {
            HyperlinkInfo info;
            Filter.Result result;
            try {
                result = this.myCustomFilter.applyFilter(line, stacktraceLength);
            }
            catch (Throwable t) {
                throw new RuntimeException("Error while applying " + this.myCustomFilter + " to '" + line + "'", t);
            }
            HyperlinkInfo hyperlinkInfo = info = result != null ? result.getFirstHyperlinkInfo() : null;
            if (info == null) continue;
            if (info instanceof FileHyperlinkInfo) {
                return ((FileHyperlinkInfo)info).getDescriptor();
            }
            return new Navigatable(){

                public void navigate(boolean requestFocus) {
                    info.navigate(project2);
                }

                public boolean canNavigate() {
                    return true;
                }

                public boolean canNavigateToSource() {
                    return true;
                }
            };
        }
        return null;
    }

    public void addStackTraceFilter(Filter filter) {
        this.myCustomFilter.addFilter(filter);
    }

    @Nullable
    protected Navigatable findSuitableNavigatableForLine(@NotNull Project project2, @NotNull VirtualFile file2, int line) {
        PsiFile psi;
        Document doc = FileDocumentManager.getInstance().getDocument(file2);
        PsiFile psiFile = psi = doc == null ? null : PsiDocumentManager.getInstance((Project)project2).getPsiFile(doc);
        if (psi == null) {
            return null;
        }
        int offset = doc.getLineStartOffset(line);
        int endOffset = doc.getLineEndOffset(line);
        for (int i = offset + 1; i < endOffset; ++i) {
            PsiElement el = psi.findElementAt(i);
            if (el == null || el instanceof PsiWhiteSpace) continue;
            offset = el.getTextOffset();
            break;
        }
        return new OpenFileDescriptor(project2, file2, offset);
    }

    public boolean fixEmptySuite() {
        return false;
    }

    @Nullable
    public SMTestLocator getTestLocator() {
        return null;
    }

    @Nullable
    public TestProxyFilterProvider getFilterProvider() {
        return null;
    }

    @Nullable
    public AbstractRerunFailedTestsAction createRerunFailedTestsAction(ConsoleView consoleView) {
        return null;
    }

    @NotNull
    public String getTestFrameworkName() {
        return this.myTestFrameworkName;
    }
}

