/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.GeneralToSMTRunnerEventsConvertor;
import com.intellij.execution.testframework.sm.runner.OutputLineSplitter;
import com.intellij.execution.testframework.sm.runner.ProcessOutputConsumer;
import com.intellij.execution.testframework.sm.runner.events.TestFailedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestIgnoredEvent;
import com.intellij.execution.testframework.sm.runner.events.TestOutputEvent;
import com.intellij.execution.testframework.sm.runner.events.TestStartedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteStartedEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import java.text.ParseException;
import java.util.Map;
import jetbrains.buildServer.messages.serviceMessages.BaseTestMessage;
import jetbrains.buildServer.messages.serviceMessages.BuildNumber;
import jetbrains.buildServer.messages.serviceMessages.BuildStatisticValue;
import jetbrains.buildServer.messages.serviceMessages.BuildStatus;
import jetbrains.buildServer.messages.serviceMessages.DefaultServiceMessageVisitor;
import jetbrains.buildServer.messages.serviceMessages.Message;
import jetbrains.buildServer.messages.serviceMessages.ProgressFinish;
import jetbrains.buildServer.messages.serviceMessages.ProgressMessage;
import jetbrains.buildServer.messages.serviceMessages.ProgressStart;
import jetbrains.buildServer.messages.serviceMessages.PublishArtifacts;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageVisitor;
import jetbrains.buildServer.messages.serviceMessages.TestFailed;
import jetbrains.buildServer.messages.serviceMessages.TestFinished;
import jetbrains.buildServer.messages.serviceMessages.TestIgnored;
import jetbrains.buildServer.messages.serviceMessages.TestStarted;
import jetbrains.buildServer.messages.serviceMessages.TestStdErr;
import jetbrains.buildServer.messages.serviceMessages.TestStdOut;
import jetbrains.buildServer.messages.serviceMessages.TestSuiteFinished;
import jetbrains.buildServer.messages.serviceMessages.TestSuiteStarted;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OutputToGeneralTestEventsConverter
implements ProcessOutputConsumer {
    private static final Logger LOG = Logger.getInstance((String)OutputToGeneralTestEventsConverter.class.getName());
    private final MyServiceMessageVisitor myServiceMessageVisitor;
    private final String myTestFrameworkName;
    private final OutputLineSplitter mySplitter;
    private GeneralTestEventsProcessor myProcessor;
    private boolean myPendingLineBreakFlag;

    public OutputToGeneralTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties) {
        this.myTestFrameworkName = testFrameworkName;
        this.myServiceMessageVisitor = new MyServiceMessageVisitor();
        this.mySplitter = new OutputLineSplitter(consoleProperties.isEditable()){

            @Override
            protected void onLineAvailable(@NotNull String text, @NotNull Key outputType, boolean tcLikeFakeOutput) {
                OutputToGeneralTestEventsConverter.this.processConsistentText(text, outputType, tcLikeFakeOutput);
            }
        };
    }

    @Override
    public void setProcessor(@Nullable GeneralTestEventsProcessor processor2) {
        this.myProcessor = processor2;
    }

    protected GeneralTestEventsProcessor getProcessor() {
        return this.myProcessor;
    }

    public void dispose() {
        this.setProcessor(null);
    }

    @Override
    public void process(String text, Key outputType) {
        this.mySplitter.process(text, outputType);
    }

    @Override
    public void flushBufferBeforeTerminating() {
        this.mySplitter.flush();
        if (this.myPendingLineBreakFlag) {
            this.fireOnUncapturedLineBreak();
        }
    }

    private void fireOnUncapturedLineBreak() {
        this.fireOnUncapturedOutput("\n", ProcessOutputTypes.STDOUT);
    }

    private void processConsistentText(String text, Key outputType, boolean tcLikeFakeOutput) {
        try {
            if (!this.processServiceMessages(text, outputType, (ServiceMessageVisitor)this.myServiceMessageVisitor)) {
                if (this.myPendingLineBreakFlag) {
                    this.fireOnUncapturedLineBreak();
                    this.myPendingLineBreakFlag = false;
                }
                String outputToProcess = text;
                if (tcLikeFakeOutput && text.endsWith("\n")) {
                    this.myPendingLineBreakFlag = true;
                    outputToProcess = outputToProcess.substring(0, outputToProcess.length() - 1);
                }
                this.fireOnUncapturedOutput(outputToProcess, outputType);
            } else {
                this.myPendingLineBreakFlag = false;
            }
        }
        catch (ParseException e) {
            LOG.error(GeneralToSMTRunnerEventsConvertor.getTFrameworkPrefix(this.myTestFrameworkName) + "Error parsing text: [" + text + "]", (Throwable)e);
        }
    }

    protected boolean processServiceMessages(String text, Key outputType, ServiceMessageVisitor visitor) throws ParseException {
        ServiceMessage message = ServiceMessage.parse((String)text.trim());
        if (message != null) {
            message.visit(visitor);
        }
        return message != null;
    }

    private void fireOnTestStarted(@NotNull TestStartedEvent testStartedEvent) {
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            processor2.onTestStarted(testStartedEvent);
        }
    }

    private void fireOnTestFailure(@NotNull TestFailedEvent testFailedEvent) {
        this.assertNotNull(testFailedEvent.getLocalizedFailureMessage());
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            processor2.onTestFailure(testFailedEvent);
        }
    }

    private void fireOnTestIgnored(@NotNull TestIgnoredEvent testIgnoredEvent) {
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            processor2.onTestIgnored(testIgnoredEvent);
        }
    }

    private void fireOnTestFinished(@NotNull TestFinishedEvent testFinishedEvent) {
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            processor2.onTestFinished(testFinishedEvent);
        }
    }

    private void fireOnCustomProgressTestsCategory(String categoryName, int testsCount) {
        this.assertNotNull(categoryName);
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            boolean disableCustomMode = StringUtil.isEmpty((String)categoryName);
            processor2.onCustomProgressTestsCategory(disableCustomMode ? null : categoryName, disableCustomMode ? 0 : testsCount);
        }
    }

    private void fireOnCustomProgressTestStarted() {
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            processor2.onCustomProgressTestStarted();
        }
    }

    private void fireOnCustomProgressTestFinished() {
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            processor2.onCustomProgressTestFinished();
        }
    }

    private void fireOnCustomProgressTestFailed() {
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            processor2.onCustomProgressTestFailed();
        }
    }

    private void fireOnTestFrameworkAttached() {
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            processor2.onTestsReporterAttached();
        }
    }

    private void fireOnSuiteTreeNodeAdded(String testName, String locationHint) {
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            processor2.onSuiteTreeNodeAdded(testName, locationHint);
        }
    }

    private void fireRootPresentationAdded(String rootName, @Nullable String comment, String rootLocation) {
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            processor2.onRootPresentationAdded(rootName, comment, rootLocation);
        }
    }

    private void fireOnSuiteTreeStarted(String suiteName, String locationHint) {
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            processor2.onSuiteTreeStarted(suiteName, locationHint);
        }
    }

    private void fireOnSuiteTreeEnded(String suiteName) {
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            processor2.onSuiteTreeEnded(suiteName);
        }
    }

    private void fireOnBuildTreeEnded() {
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            processor2.onBuildTreeEnded();
        }
    }

    private void fireOnTestOutput(@NotNull TestOutputEvent testOutputEvent) {
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            processor2.onTestOutput(testOutputEvent);
        }
    }

    private void fireOnUncapturedOutput(String text, Key outputType) {
        this.assertNotNull(text);
        if (StringUtil.isEmpty((String)text)) {
            return;
        }
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            processor2.onUncapturedOutput(text, outputType);
        }
    }

    private void fireOnTestsCountInSuite(int count) {
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            processor2.onTestsCountInSuite(count);
        }
    }

    private void fireOnSuiteStarted(@NotNull TestSuiteStartedEvent suiteStartedEvent) {
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            processor2.onSuiteStarted(suiteStartedEvent);
        }
    }

    private void fireOnSuiteFinished(@NotNull TestSuiteFinishedEvent suiteFinishedEvent) {
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            processor2.onSuiteFinished(suiteFinishedEvent);
        }
    }

    protected void fireOnErrorMsg(String localizedMessage, @Nullable String stackTrace, boolean isCritical) {
        this.assertNotNull(localizedMessage);
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            processor2.onError(localizedMessage, stackTrace, isCritical);
        }
    }

    private void assertNotNull(String s) {
        if (s == null) {
            LOG.error(GeneralToSMTRunnerEventsConvertor.getTFrameworkPrefix(this.myTestFrameworkName) + " @NotNull value is expected.");
        }
    }

    public void onStartTesting() {
    }

    private class MyServiceMessageVisitor
    extends DefaultServiceMessageVisitor {
        @NonNls
        public static final String KEY_TESTS_COUNT = "testCount";
        @NonNls
        private static final String ATTR_KEY_TEST_ERROR = "error";
        @NonNls
        private static final String ATTR_KEY_TEST_COUNT = "count";
        @NonNls
        private static final String ATTR_KEY_TEST_DURATION = "duration";
        @NonNls
        private static final String ATTR_KEY_TEST_OUTPUT_FILE = "outputFile";
        @NonNls
        private static final String ATTR_KEY_LOCATION_URL = "locationHint";
        @NonNls
        private static final String ATTR_KEY_LOCATION_URL_OLD = "location";
        @NonNls
        private static final String ATTR_KEY_STACKTRACE_DETAILS = "details";
        @NonNls
        private static final String ATTR_KEY_DIAGNOSTIC = "diagnosticInfo";
        @NonNls
        private static final String ATTR_KEY_CONFIG = "config";
        @NonNls
        private static final String MESSAGE = "message";
        @NonNls
        private static final String TEST_REPORTER_ATTACHED = "enteredTheMatrix";
        @NonNls
        private static final String SUITE_TREE_STARTED = "suiteTreeStarted";
        @NonNls
        private static final String SUITE_TREE_ENDED = "suiteTreeEnded";
        @NonNls
        private static final String SUITE_TREE_NODE = "suiteTreeNode";
        @NonNls
        private static final String BUILD_TREE_ENDED_NODE = "treeEnded";
        @NonNls
        private static final String ROOT_PRESENTATION = "rootName";
        @NonNls
        private static final String ATTR_KEY_STATUS = "status";
        @NonNls
        private static final String ATTR_VALUE_STATUS_ERROR = "ERROR";
        @NonNls
        private static final String ATTR_VALUE_STATUS_WARNING = "WARNING";
        @NonNls
        private static final String ATTR_KEY_TEXT = "text";
        @NonNls
        private static final String ATTR_KEY_ERROR_DETAILS = "errorDetails";
        @NonNls
        private static final String ATTR_KEY_EXPECTED_FILE_PATH = "expectedFile";
        @NonNls
        private static final String ATTR_KEY_ACTUAL_FILE_PATH = "actualFile";
        @NonNls
        public static final String CUSTOM_STATUS = "customProgressStatus";
        @NonNls
        private static final String ATTR_KEY_TEST_TYPE = "type";
        @NonNls
        private static final String ATTR_KEY_TESTS_CATEGORY = "testsCategory";
        @NonNls
        private static final String ATTR_VAL_TEST_STARTED = "testStarted";
        @NonNls
        private static final String ATTR_VAL_TEST_FINISHED = "testFinished";
        @NonNls
        private static final String ATTR_VAL_TEST_FAILED = "testFailed";

        private MyServiceMessageVisitor() {
        }

        public void visitTestSuiteStarted(@NotNull TestSuiteStarted suiteStarted) {
            String locationUrl = this.fetchTestLocation(suiteStarted);
            TestSuiteStartedEvent suiteStartedEvent = new TestSuiteStartedEvent(suiteStarted, locationUrl);
            OutputToGeneralTestEventsConverter.this.fireOnSuiteStarted(suiteStartedEvent);
        }

        @Nullable
        private String fetchTestLocation(TestSuiteStarted suiteStarted) {
            Map attrs = suiteStarted.getAttributes();
            String location = (String)attrs.get(ATTR_KEY_LOCATION_URL);
            if (location == null) {
                String oldLocation = (String)attrs.get(ATTR_KEY_LOCATION_URL_OLD);
                if (oldLocation != null) {
                    LOG.error(GeneralToSMTRunnerEventsConvertor.getTFrameworkPrefix(OutputToGeneralTestEventsConverter.this.myTestFrameworkName) + "Test Runner API was changed for TeamCity 5.0 compatibility. Please use 'locationHint' attribute instead of 'location'.");
                    return oldLocation;
                }
                return null;
            }
            return location;
        }

        public void visitTestSuiteFinished(@NotNull TestSuiteFinished suiteFinished) {
            TestSuiteFinishedEvent finishedEvent = new TestSuiteFinishedEvent(suiteFinished);
            OutputToGeneralTestEventsConverter.this.fireOnSuiteFinished(finishedEvent);
        }

        public void visitTestStarted(@NotNull TestStarted testStarted) {
            Map attributes = testStarted.getAttributes();
            String locationUrl = (String)attributes.get(ATTR_KEY_LOCATION_URL);
            TestStartedEvent testStartedEvent = new TestStartedEvent(testStarted, locationUrl);
            testStartedEvent.setConfig(attributes.get(ATTR_KEY_CONFIG) != null);
            OutputToGeneralTestEventsConverter.this.fireOnTestStarted(testStartedEvent);
        }

        public void visitTestFinished(@NotNull TestFinished testFinished) {
            String durationStr = (String)testFinished.getAttributes().get(ATTR_KEY_TEST_DURATION);
            long duration = 0L;
            if (!StringUtil.isEmptyOrSpaces((String)durationStr)) {
                duration = this.convertToLong(durationStr, (ServiceMessage)testFinished);
            }
            TestFinishedEvent testFinishedEvent = new TestFinishedEvent(testFinished, duration, (String)testFinished.getAttributes().get(ATTR_KEY_TEST_OUTPUT_FILE));
            OutputToGeneralTestEventsConverter.this.fireOnTestFinished(testFinishedEvent);
        }

        public void visitTestIgnored(@NotNull TestIgnored testIgnored) {
            String stacktrace = (String)testIgnored.getAttributes().get(ATTR_KEY_STACKTRACE_DETAILS);
            OutputToGeneralTestEventsConverter.this.fireOnTestIgnored(new TestIgnoredEvent(testIgnored, stacktrace));
        }

        public void visitTestStdOut(@NotNull TestStdOut testStdOut) {
            OutputToGeneralTestEventsConverter.this.fireOnTestOutput(new TestOutputEvent((BaseTestMessage)testStdOut, testStdOut.getStdOut(), true));
        }

        public void visitTestStdErr(@NotNull TestStdErr testStdErr) {
            OutputToGeneralTestEventsConverter.this.fireOnTestOutput(new TestOutputEvent((BaseTestMessage)testStdErr, testStdErr.getStdErr(), false));
        }

        public void visitTestFailed(@NotNull TestFailed testFailed) {
            Map attributes = testFailed.getAttributes();
            LOG.assertTrue(testFailed.getFailureMessage() != null, (Object)("No failure message for: " + OutputToGeneralTestEventsConverter.this.myTestFrameworkName));
            boolean testError = attributes.get(ATTR_KEY_TEST_ERROR) != null;
            TestFailedEvent testFailedEvent = new TestFailedEvent(testFailed, testError, (String)attributes.get(ATTR_KEY_EXPECTED_FILE_PATH), (String)attributes.get(ATTR_KEY_ACTUAL_FILE_PATH));
            OutputToGeneralTestEventsConverter.this.fireOnTestFailure(testFailedEvent);
        }

        public void visitPublishArtifacts(@NotNull PublishArtifacts publishArtifacts) {
        }

        public void visitProgressMessage(@NotNull ProgressMessage progressMessage) {
        }

        public void visitProgressStart(@NotNull ProgressStart progressStart) {
        }

        public void visitProgressFinish(@NotNull ProgressFinish progressFinish) {
        }

        public void visitBuildStatus(@NotNull BuildStatus buildStatus) {
        }

        public void visitBuildNumber(@NotNull BuildNumber buildNumber) {
        }

        public void visitBuildStatisticValue(@NotNull BuildStatisticValue buildStatsValue) {
        }

        public void visitMessageWithStatus(@NotNull Message msg) {
            Map msgAttrs = msg.getAttributes();
            String text = (String)msgAttrs.get(ATTR_KEY_TEXT);
            if (!StringUtil.isEmpty((String)text)) {
                String status = (String)msgAttrs.get(ATTR_KEY_STATUS);
                if (status.equals(ATTR_VALUE_STATUS_ERROR)) {
                    String stackTrace = (String)msgAttrs.get(ATTR_KEY_ERROR_DETAILS);
                    OutputToGeneralTestEventsConverter.this.fireOnErrorMsg(text, stackTrace, true);
                } else if (status.equals(ATTR_VALUE_STATUS_WARNING)) {
                    String stackTrace = (String)msgAttrs.get(ATTR_KEY_ERROR_DETAILS);
                    OutputToGeneralTestEventsConverter.this.fireOnErrorMsg(text, stackTrace, false);
                } else {
                    OutputToGeneralTestEventsConverter.this.fireOnUncapturedOutput(text, ProcessOutputTypes.STDOUT);
                }
            }
        }

        public void visitServiceMessage(@NotNull ServiceMessage msg) {
            String name = msg.getMessageName();
            if (KEY_TESTS_COUNT.equals(name)) {
                this.processTestCountInSuite(msg);
            } else if (CUSTOM_STATUS.equals(name)) {
                this.processCustomStatus(msg);
            } else if (MESSAGE.equals(name)) {
                Map msgAttrs = msg.getAttributes();
                String text = (String)msgAttrs.get(ATTR_KEY_TEXT);
                if (!StringUtil.isEmpty((String)text)) {
                    OutputToGeneralTestEventsConverter.this.fireOnUncapturedOutput(text, ProcessOutputTypes.STDOUT);
                }
            } else if (TEST_REPORTER_ATTACHED.equals(name)) {
                OutputToGeneralTestEventsConverter.this.fireOnTestFrameworkAttached();
            } else if (SUITE_TREE_STARTED.equals(name)) {
                OutputToGeneralTestEventsConverter.this.fireOnSuiteTreeStarted((String)msg.getAttributes().get("name"), (String)msg.getAttributes().get(ATTR_KEY_LOCATION_URL));
            } else if (SUITE_TREE_ENDED.equals(name)) {
                OutputToGeneralTestEventsConverter.this.fireOnSuiteTreeEnded((String)msg.getAttributes().get("name"));
            } else if (SUITE_TREE_NODE.equals(name)) {
                OutputToGeneralTestEventsConverter.this.fireOnSuiteTreeNodeAdded((String)msg.getAttributes().get("name"), (String)msg.getAttributes().get(ATTR_KEY_LOCATION_URL));
            } else if (BUILD_TREE_ENDED_NODE.equals(name)) {
                OutputToGeneralTestEventsConverter.this.fireOnBuildTreeEnded();
            } else if (ROOT_PRESENTATION.equals(name)) {
                Map attributes = msg.getAttributes();
                OutputToGeneralTestEventsConverter.this.fireRootPresentationAdded((String)attributes.get("name"), (String)attributes.get("comment"), (String)attributes.get(ATTR_KEY_LOCATION_URL_OLD));
            } else {
                GeneralTestEventsProcessor.logProblem(LOG, "Unexpected service message:" + name, OutputToGeneralTestEventsConverter.this.myTestFrameworkName);
            }
        }

        private void processTestCountInSuite(ServiceMessage msg) {
            String countStr = (String)msg.getAttributes().get(ATTR_KEY_TEST_COUNT);
            OutputToGeneralTestEventsConverter.this.fireOnTestsCountInSuite(this.convertToInt(countStr, msg));
        }

        private int convertToInt(String countStr, ServiceMessage msg) {
            int count = 0;
            try {
                count = Integer.parseInt(countStr);
            }
            catch (NumberFormatException ex) {
                String diagnosticInfo = (String)msg.getAttributes().get(ATTR_KEY_DIAGNOSTIC);
                LOG.error(GeneralToSMTRunnerEventsConvertor.getTFrameworkPrefix(OutputToGeneralTestEventsConverter.this.myTestFrameworkName) + "Parse integer error." + (diagnosticInfo == null ? "" : " " + diagnosticInfo), (Throwable)ex);
            }
            return count;
        }

        private long convertToLong(String countStr, @NotNull ServiceMessage msg) {
            long count = 0L;
            try {
                count = Long.parseLong(countStr);
            }
            catch (NumberFormatException ex) {
                String diagnosticInfo = (String)msg.getAttributes().get(ATTR_KEY_DIAGNOSTIC);
                LOG.error(GeneralToSMTRunnerEventsConvertor.getTFrameworkPrefix(OutputToGeneralTestEventsConverter.this.myTestFrameworkName) + "Parse long error." + (diagnosticInfo == null ? "" : " " + diagnosticInfo), (Throwable)ex);
            }
            return count;
        }

        private void processCustomStatus(ServiceMessage msg) {
            Map attrs = msg.getAttributes();
            String msgType = (String)attrs.get(ATTR_KEY_TEST_TYPE);
            if (msgType != null) {
                if (msgType.equals(ATTR_VAL_TEST_STARTED)) {
                    OutputToGeneralTestEventsConverter.this.fireOnCustomProgressTestStarted();
                } else if (msgType.equals(ATTR_VAL_TEST_FINISHED)) {
                    OutputToGeneralTestEventsConverter.this.fireOnCustomProgressTestFinished();
                } else if (msgType.equals(ATTR_VAL_TEST_FAILED)) {
                    OutputToGeneralTestEventsConverter.this.fireOnCustomProgressTestFailed();
                }
                return;
            }
            String testsCategory = (String)attrs.get(ATTR_KEY_TESTS_CATEGORY);
            if (testsCategory != null) {
                String countStr = (String)msg.getAttributes().get(ATTR_KEY_TEST_COUNT);
                OutputToGeneralTestEventsConverter.this.fireOnCustomProgressTestsCategory(testsCategory, this.convertToInt(countStr, msg));
                return;
            }
        }
    }
}

