/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.TestProxyPrinterProvider;
import com.intellij.execution.testframework.sm.runner.events.BaseStartedNodeEvent;
import com.intellij.execution.testframework.sm.runner.events.TestFailedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestIgnoredEvent;
import com.intellij.execution.testframework.sm.runner.events.TestOutputEvent;
import com.intellij.execution.testframework.sm.runner.events.TestStartedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteStartedEvent;
import com.intellij.execution.testframework.sm.runner.events.TreeNodeEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntObjectHashMap;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralIdBasedToSMTRunnerEventsConvertor
extends GeneralTestEventsProcessor {
    private final TIntObjectHashMap<Node> myNodeByIdMap = new TIntObjectHashMap();
    private final Set<Node> myRunningTestNodes = ContainerUtil.newHashSet();
    private final SMTestProxy.SMRootTestProxy myTestsRootProxy;
    private final Node myTestsRootNode;
    private boolean myIsTestingFinished = false;
    private SMTestLocator myLocator = null;
    private TestProxyPrinterProvider myTestProxyPrinterProvider = null;

    public GeneralIdBasedToSMTRunnerEventsConvertor(Project project2, @NotNull SMTestProxy.SMRootTestProxy testsRootProxy, @NotNull String testFrameworkName) {
        super(project2, testFrameworkName);
        this.myTestsRootProxy = testsRootProxy;
        this.myTestsRootNode = new Node(0, null, testsRootProxy);
        this.myNodeByIdMap.put(this.myTestsRootNode.getId(), (Object)this.myTestsRootNode);
    }

    @Override
    public void setLocator(@NotNull SMTestLocator locator) {
        this.myLocator = locator;
    }

    @Override
    public void onStartTesting() {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GeneralIdBasedToSMTRunnerEventsConvertor.this.myTestsRootNode.setState(State.RUNNING, GeneralIdBasedToSMTRunnerEventsConvertor.this);
                GeneralIdBasedToSMTRunnerEventsConvertor.this.myTestsRootProxy.setStarted();
                GeneralIdBasedToSMTRunnerEventsConvertor.this.fireOnTestingStarted(GeneralIdBasedToSMTRunnerEventsConvertor.this.myTestsRootProxy);
            }
        });
    }

    @Override
    public void onTestsReporterAttached() {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GeneralTestEventsProcessor.fireOnTestsReporterAttached(GeneralIdBasedToSMTRunnerEventsConvertor.this.myTestsRootProxy);
            }
        });
    }

    @Override
    public void onFinishTesting() {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                if (GeneralIdBasedToSMTRunnerEventsConvertor.this.myIsTestingFinished) {
                    return;
                }
                GeneralIdBasedToSMTRunnerEventsConvertor.this.myIsTestingFinished = true;
                boolean completeTree = GeneralTestEventsProcessor.isTreeComplete(GeneralIdBasedToSMTRunnerEventsConvertor.this.myRunningTestNodes, GeneralIdBasedToSMTRunnerEventsConvertor.this.myTestsRootProxy);
                if (completeTree) {
                    GeneralIdBasedToSMTRunnerEventsConvertor.this.myTestsRootProxy.setFinished();
                } else {
                    GeneralIdBasedToSMTRunnerEventsConvertor.this.myTestsRootProxy.setTerminated();
                }
                if (!GeneralIdBasedToSMTRunnerEventsConvertor.this.myRunningTestNodes.isEmpty()) {
                    GeneralIdBasedToSMTRunnerEventsConvertor.this.logProblem("Unexpected running nodes: " + GeneralIdBasedToSMTRunnerEventsConvertor.this.myRunningTestNodes);
                }
                GeneralIdBasedToSMTRunnerEventsConvertor.this.myNodeByIdMap.clear();
                GeneralIdBasedToSMTRunnerEventsConvertor.this.myRunningTestNodes.clear();
                GeneralIdBasedToSMTRunnerEventsConvertor.this.fireOnTestingFinished(GeneralIdBasedToSMTRunnerEventsConvertor.this.myTestsRootProxy);
            }
        });
        this.stopEventProcessing();
    }

    @Override
    public void setPrinterProvider(@NotNull TestProxyPrinterProvider printerProvider) {
        this.myTestProxyPrinterProvider = printerProvider;
    }

    @Override
    public void onTestStarted(final @NotNull TestStartedEvent testStartedEvent) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GeneralIdBasedToSMTRunnerEventsConvertor.this.doStartNode(testStartedEvent, false);
            }
        });
    }

    @Override
    public void onSuiteStarted(final @NotNull TestSuiteStartedEvent suiteStartedEvent) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GeneralIdBasedToSMTRunnerEventsConvertor.this.doStartNode(suiteStartedEvent, true);
            }
        });
    }

    private void doStartNode(@NotNull BaseStartedNodeEvent startedNodeEvent, boolean suite) {
        Printer printer;
        Node node = this.findNode(startedNodeEvent);
        if (node != null) {
            if (node.getState() == State.NOT_RUNNING && startedNodeEvent.isRunning()) {
                this.setNodeAndAncestorsRunning(node);
            } else {
                this.logProblem(startedNodeEvent + " has been already started: " + node + "!");
            }
            return;
        }
        Node parentNode = this.findValidParentNode(startedNodeEvent);
        if (parentNode == null) {
            return;
        }
        if (!this.validateNodeId(startedNodeEvent)) {
            return;
        }
        String nodeName = startedNodeEvent.getName();
        SMTestProxy childProxy = new SMTestProxy(nodeName, suite, startedNodeEvent.getLocationUrl(), true);
        TestProxyPrinterProvider printerProvider = this.myTestProxyPrinterProvider;
        String nodeType = startedNodeEvent.getNodeType();
        if (printerProvider != null && nodeType != null && nodeName != null && (printer = printerProvider.getPrinterByType(nodeType, nodeName, startedNodeEvent.getNodeArgs())) != null) {
            childProxy.setPreferredPrinter(printer);
        }
        node = new Node(startedNodeEvent.getId(), parentNode, childProxy);
        this.myNodeByIdMap.put(startedNodeEvent.getId(), (Object)node);
        if (this.myLocator != null) {
            childProxy.setLocator(this.myLocator);
        }
        parentNode.getProxy().addChild(childProxy);
        if (startedNodeEvent.isRunning()) {
            this.setNodeAndAncestorsRunning(node);
        }
    }

    @Nullable
    private Node findValidParentNode(@NotNull BaseStartedNodeEvent startedNodeEvent) {
        int parentId = startedNodeEvent.getParentId();
        if (parentId < 0) {
            this.logProblem("Parent node id should be non-negative: " + startedNodeEvent + ".", true);
            return null;
        }
        Node parentNode = (Node)this.myNodeByIdMap.get(startedNodeEvent.getParentId());
        if (parentNode == null) {
            this.logProblem("Parent node is undefined for " + startedNodeEvent + ".", true);
            return null;
        }
        if (parentNode.getState() != State.NOT_RUNNING && parentNode.getState() != State.RUNNING) {
            this.logProblem("Parent node should be registered or running: " + parentNode + ", " + startedNodeEvent);
            return null;
        }
        return parentNode;
    }

    @Override
    public void onTestFinished(final @NotNull TestFinishedEvent testFinishedEvent) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Node node = GeneralIdBasedToSMTRunnerEventsConvertor.this.findNodeToTerminate(testFinishedEvent);
                if (node != null) {
                    SMTestProxy testProxy = node.getProxy();
                    testProxy.setDuration(testFinishedEvent.getDuration());
                    testProxy.setFrameworkOutputFile(testFinishedEvent.getOutputFile());
                    testProxy.setFinished();
                    GeneralIdBasedToSMTRunnerEventsConvertor.this.fireOnTestFinished(testProxy);
                    GeneralIdBasedToSMTRunnerEventsConvertor.this.terminateNode(node, State.FINISHED);
                }
            }
        });
    }

    @Override
    public void onSuiteFinished(final @NotNull TestSuiteFinishedEvent suiteFinishedEvent) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Node node = GeneralIdBasedToSMTRunnerEventsConvertor.this.findNodeToTerminate(suiteFinishedEvent);
                if (node != null) {
                    SMTestProxy suiteProxy = node.getProxy();
                    suiteProxy.setFinished();
                    GeneralIdBasedToSMTRunnerEventsConvertor.this.fireOnSuiteFinished(suiteProxy);
                    GeneralIdBasedToSMTRunnerEventsConvertor.this.terminateNode(node, State.FINISHED);
                }
            }
        });
    }

    @Nullable
    private Node findNodeToTerminate(@NotNull TreeNodeEvent treeNodeEvent) {
        Node node = this.findNode(treeNodeEvent);
        if (node == null) {
            this.logProblem("Trying to finish not existent node: " + treeNodeEvent);
            return null;
        }
        return node;
    }

    @Override
    public void onUncapturedOutput(final @NotNull String text, final Key outputType) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Node activeNode = GeneralIdBasedToSMTRunnerEventsConvertor.this.findActiveNode();
                SMTestProxy activeProxy = activeNode.getProxy();
                if (ProcessOutputTypes.STDERR.equals((Object)outputType)) {
                    activeProxy.addStdErr(text);
                } else if (ProcessOutputTypes.SYSTEM.equals((Object)outputType)) {
                    activeProxy.addSystemOutput(text);
                } else {
                    activeProxy.addStdOutput(text, outputType);
                }
            }
        });
    }

    @Override
    public void onError(final @NotNull String localizedMessage, final @Nullable String stackTrace, final boolean isCritical) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Node activeNode = GeneralIdBasedToSMTRunnerEventsConvertor.this.findActiveNode();
                SMTestProxy activeProxy = activeNode.getProxy();
                activeProxy.addError(localizedMessage, stackTrace, isCritical);
            }
        });
    }

    @Override
    public void onTestFailure(final @NotNull TestFailedEvent testFailedEvent) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Node node = GeneralIdBasedToSMTRunnerEventsConvertor.this.findNodeToTerminate(testFailedEvent);
                if (node == null) {
                    return;
                }
                SMTestProxy testProxy = node.getProxy();
                String comparisonFailureActualText = testFailedEvent.getComparisonFailureActualText();
                String comparisonFailureExpectedText = testFailedEvent.getComparisonFailureExpectedText();
                String failureMessage = testFailedEvent.getLocalizedFailureMessage();
                String stackTrace = testFailedEvent.getStacktrace();
                if (comparisonFailureActualText != null && comparisonFailureExpectedText != null) {
                    testProxy.setTestComparisonFailed(failureMessage, stackTrace, comparisonFailureActualText, comparisonFailureExpectedText, testFailedEvent.getFilePath());
                } else if (comparisonFailureActualText == null && comparisonFailureExpectedText == null) {
                    testProxy.setTestFailed(failureMessage, stackTrace, testFailedEvent.isTestError());
                } else {
                    GeneralIdBasedToSMTRunnerEventsConvertor.this.logProblem("Comparison failure actual and expected texts should be both null or not null.\nExpected:\n" + comparisonFailureExpectedText + "\n" + "Actual:\n" + comparisonFailureActualText);
                }
                long duration = testFailedEvent.getDurationMillis();
                if (duration >= 0L) {
                    testProxy.setDuration(duration);
                }
                GeneralIdBasedToSMTRunnerEventsConvertor.this.fireOnTestFailed(testProxy);
                GeneralIdBasedToSMTRunnerEventsConvertor.this.terminateNode(node, State.FAILED);
            }
        });
    }

    @Override
    public void onTestIgnored(final @NotNull TestIgnoredEvent testIgnoredEvent) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Node node = GeneralIdBasedToSMTRunnerEventsConvertor.this.findNodeToTerminate(testIgnoredEvent);
                if (node != null) {
                    SMTestProxy testProxy = node.getProxy();
                    testProxy.setTestIgnored(testIgnoredEvent.getIgnoreComment(), testIgnoredEvent.getStacktrace());
                    GeneralIdBasedToSMTRunnerEventsConvertor.this.fireOnTestIgnored(testProxy);
                    GeneralIdBasedToSMTRunnerEventsConvertor.this.terminateNode(node, State.IGNORED);
                }
            }
        });
    }

    @Override
    public void onTestOutput(final @NotNull TestOutputEvent testOutputEvent) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Node node = GeneralIdBasedToSMTRunnerEventsConvertor.this.findNode(testOutputEvent);
                if (node == null) {
                    GeneralIdBasedToSMTRunnerEventsConvertor.this.logProblem("Test wasn't started! But " + testOutputEvent + "!");
                    return;
                }
                SMTestProxy testProxy = node.getProxy();
                if (testOutputEvent.isStdOut()) {
                    testProxy.addStdOutput(testOutputEvent.getText(), ProcessOutputTypes.STDOUT);
                } else {
                    testProxy.addStdErr(testOutputEvent.getText());
                }
            }
        });
    }

    @Override
    public void onTestsCountInSuite(final int count) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GeneralIdBasedToSMTRunnerEventsConvertor.this.fireOnTestsCountInSuite(count);
            }
        });
    }

    private boolean validateNodeId(@NotNull TreeNodeEvent treeNodeEvent) {
        int nodeId = treeNodeEvent.getId();
        if (nodeId <= 0) {
            this.logProblem("Node id should be positive: " + treeNodeEvent + ".", true);
            return false;
        }
        return true;
    }

    @Nullable
    private Node findNode(@NotNull TreeNodeEvent treeNodeEvent) {
        if (!this.validateNodeId(treeNodeEvent)) {
            return null;
        }
        return (Node)this.myNodeByIdMap.get(treeNodeEvent.getId());
    }

    @Nullable
    public SMTestProxy findProxyById(int id) {
        Node node = (Node)this.myNodeByIdMap.get(id);
        return node != null ? node.getProxy() : null;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Application application;
                GeneralIdBasedToSMTRunnerEventsConvertor.this.disconnectListeners();
                if (!(GeneralIdBasedToSMTRunnerEventsConvertor.this.myRunningTestNodes.isEmpty() || (application = ApplicationManager.getApplication()).isHeadlessEnvironment() || application.isUnitTestMode())) {
                    GeneralIdBasedToSMTRunnerEventsConvertor.this.logProblem("Not all events were processed!");
                }
                GeneralIdBasedToSMTRunnerEventsConvertor.this.myRunningTestNodes.clear();
                GeneralIdBasedToSMTRunnerEventsConvertor.this.myNodeByIdMap.clear();
            }
        });
    }

    private void setNodeAndAncestorsRunning(@NotNull Node lowestNode) {
        for (Node node = lowestNode; node != null && node != this.myTestsRootNode && node.getState() == State.NOT_RUNNING; node = node.getParentNode()) {
            node.setState(State.RUNNING, this);
            SMTestProxy proxy = node.getProxy();
            proxy.setStarted();
            if (proxy.isSuite()) {
                this.fireOnSuiteStarted(proxy);
                continue;
            }
            this.myRunningTestNodes.add(lowestNode);
            this.fireOnTestStarted(proxy);
        }
    }

    private void terminateNode(@NotNull Node node, @NotNull State terminateState) {
        node.setState(terminateState, this);
        this.myRunningTestNodes.remove(node);
    }

    @NotNull
    private Node findActiveNode() {
        if (this.myRunningTestNodes.isEmpty()) {
            return this.myTestsRootNode;
        }
        return this.myRunningTestNodes.iterator().next();
    }

    private static class Node {
        private final int myId;
        private final Node myParentNode;
        private final SMTestProxy myProxy;
        private State myState;

        Node(int id, @Nullable Node parentNode, @NotNull SMTestProxy proxy) {
            this.myId = id;
            this.myParentNode = parentNode;
            this.myProxy = proxy;
            this.myState = State.NOT_RUNNING;
        }

        public int getId() {
            return this.myId;
        }

        @Nullable
        public Node getParentNode() {
            return this.myParentNode;
        }

        @NotNull
        public SMTestProxy getProxy() {
            return this.myProxy;
        }

        @NotNull
        public State getState() {
            return this.myState;
        }

        public void setState(@NotNull State newState, @NotNull GeneralIdBasedToSMTRunnerEventsConvertor convertor) {
            if (this.myState == State.NOT_RUNNING && newState != State.RUNNING && newState != State.IGNORED || this.myState == State.RUNNING && newState != State.FINISHED && newState != State.FAILED && newState != State.IGNORED || this.myState == State.FINISHED && newState != State.FAILED || this.myState == State.FAILED && newState != State.FINISHED || this.myState == State.IGNORED && newState != State.FINISHED) {
                convertor.logProblem("Illegal state change [" + (Object)((Object)this.myState) + " -> " + (Object)((Object)newState) + "]: " + this.toString(), false);
            }
            if (this.myState.ordinal() < newState.ordinal()) {
                this.myState = newState;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return this.myId == node.myId;
        }

        public int hashCode() {
            return this.myId;
        }

        public String toString() {
            return "{id=" + this.myId + ", parentId=" + (this.myParentNode != null ? String.valueOf(this.myParentNode.getId()) : "<undefined>") + ", name='" + this.myProxy.getName() + "', isSuite=" + this.myProxy.isSuite() + ", state=" + (Object)((Object)this.myState) + '}';
        }
    }

    private static enum State {
        NOT_RUNNING,
        RUNNING,
        FINISHED,
        FAILED,
        IGNORED;

    }
}

