/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.ModuleRunConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.CompositeTestLocationProvider;
import com.intellij.execution.testframework.sm.FileUrlProvider;
import com.intellij.execution.testframework.sm.SMCustomMessagesParsing;
import com.intellij.execution.testframework.sm.runner.GeneralIdBasedToSMTRunnerEventsConvertor;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.GeneralToSMTRunnerEventsConvertor;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.TestProxyFilterProvider;
import com.intellij.execution.testframework.sm.runner.TestProxyPrinterProvider;
import com.intellij.execution.testframework.sm.runner.ui.AttachToProcessListener;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerUIActionsHandler;
import com.intellij.execution.testframework.sm.runner.ui.SMTestRunnerResultsForm;
import com.intellij.execution.testframework.sm.runner.ui.statistics.StatisticsPanel;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testIntegration.TestLocationProvider;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SMTestRunnerConnectionUtil {
    private static final String TEST_RUNNER_DEBUG_MODE_PROPERTY = "idea.smrunner.debug";

    private SMTestRunnerConnectionUtil() {
    }

    @NotNull
    public static BaseTestsOutputConsoleView createAndAttachConsole(@NotNull String testFrameworkName, @NotNull ProcessHandler processHandler2, @NotNull TestConsoleProperties consoleProperties) throws ExecutionException {
        BaseTestsOutputConsoleView console = SMTestRunnerConnectionUtil.createConsole(testFrameworkName, consoleProperties);
        console.attachToProcess(processHandler2);
        return console;
    }

    @NotNull
    public static BaseTestsOutputConsoleView createConsole(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties) {
        String splitterPropertyName = SMTestRunnerConnectionUtil.getSplitterPropertyName(testFrameworkName);
        SMTRunnerConsoleView consoleView = new SMTRunnerConsoleView(consoleProperties, splitterPropertyName);
        SMTestRunnerConnectionUtil.initConsoleView(consoleView, testFrameworkName);
        return consoleView;
    }

    @NotNull
    public static String getSplitterPropertyName(@NotNull String testFrameworkName) {
        return testFrameworkName + ".Splitter.Proportion";
    }

    public static void initConsoleView(final @NotNull SMTRunnerConsoleView consoleView, final @NotNull String testFrameworkName) {
        consoleView.addAttachToProcessListener(new AttachToProcessListener(){

            @Override
            public void onAttachToProcess(@NotNull ProcessHandler processHandler2) {
                SMTestLocator customLocator;
                TestProxyFilterProvider filterProvider;
                TestConsoleProperties properties = consoleView.getProperties();
                TestProxyPrinterProvider printerProvider = null;
                if (properties instanceof SMTRunnerConsoleProperties && (filterProvider = ((SMTRunnerConsoleProperties)properties).getFilterProvider()) != null) {
                    printerProvider = new TestProxyPrinterProvider(consoleView, filterProvider);
                }
                SMTestLocator testLocator = FileUrlProvider.INSTANCE;
                if (properties instanceof SMTRunnerConsoleProperties && (customLocator = ((SMTRunnerConsoleProperties)properties).getTestLocator()) != null) {
                    testLocator = new CombinedTestLocator(customLocator);
                }
                boolean idBasedTestTree = false;
                if (properties instanceof SMTRunnerConsoleProperties) {
                    idBasedTestTree = ((SMTRunnerConsoleProperties)properties).isIdBasedTestTree();
                }
                SMTestRunnerResultsForm resultsForm = consoleView.getResultsViewer();
                SMTestRunnerConnectionUtil.attachEventsProcessors(properties, resultsForm, resultsForm.getStatisticsPane(), processHandler2, testFrameworkName, testLocator, idBasedTestTree, printerProvider);
            }
        });
        consoleView.setHelpId("reference.runToolWindow.testResultsTab");
        consoleView.initUI();
    }

    public static boolean isInDebugMode() {
        return Boolean.valueOf(System.getProperty(TEST_RUNNER_DEBUG_MODE_PROPERTY));
    }

    private static ProcessHandler attachEventsProcessors(TestConsoleProperties consoleProperties, SMTestRunnerResultsForm resultsViewer, StatisticsPanel statisticsPane, ProcessHandler processHandler2, String testFrameworkName, @Nullable SMTestLocator locator, boolean idBasedTestTree, @Nullable TestProxyPrinterProvider printerProvider) {
        final OutputToGeneralTestEventsConverter outputConsumer = consoleProperties instanceof SMCustomMessagesParsing ? ((SMCustomMessagesParsing)((Object)consoleProperties)).createTestEventsConverter(testFrameworkName, consoleProperties) : new OutputToGeneralTestEventsConverter(testFrameworkName, consoleProperties);
        final GeneralTestEventsProcessor eventsProcessor = idBasedTestTree ? new GeneralIdBasedToSMTRunnerEventsConvertor(consoleProperties.getProject(), resultsViewer.getTestsRootNode(), testFrameworkName) : new GeneralToSMTRunnerEventsConvertor(consoleProperties.getProject(), resultsViewer.getTestsRootNode(), testFrameworkName);
        if (locator != null) {
            eventsProcessor.setLocator(locator);
        }
        if (printerProvider != null) {
            eventsProcessor.setPrinterProvider(printerProvider);
        }
        SMTRunnerUIActionsHandler uiActionsHandler = new SMTRunnerUIActionsHandler(consoleProperties);
        outputConsumer.setProcessor(eventsProcessor);
        eventsProcessor.addEventsListener(resultsViewer);
        resultsViewer.addEventsListener(uiActionsHandler);
        if (Registry.is((String)"tests.view.old.statistics.panel")) {
            eventsProcessor.addEventsListener(statisticsPane.createTestEventsListener());
        }
        processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                outputConsumer.flushBufferBeforeTerminating();
                eventsProcessor.onFinishTesting();
                Disposer.dispose((Disposable)eventsProcessor);
                Disposer.dispose((Disposable)outputConsumer);
            }

            public void startNotified(ProcessEvent event) {
                eventsProcessor.onStartTesting();
                outputConsumer.onStartTesting();
            }

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                outputConsumer.process(event.getText(), outputType);
            }
        });
        return processHandler2;
    }

    public static BaseTestsOutputConsoleView createAndAttachConsole(@NotNull String testFrameworkName, @NotNull ProcessHandler processHandler2, @NotNull TestConsoleProperties consoleProperties, ExecutionEnvironment environment) throws ExecutionException {
        BaseTestsOutputConsoleView console = SMTestRunnerConnectionUtil.createConsole(testFrameworkName, consoleProperties, environment);
        console.attachToProcess(processHandler2);
        return console;
    }

    public static BaseTestsOutputConsoleView createConsole(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, ExecutionEnvironment environment) {
        return SMTestRunnerConnectionUtil.createConsoleWithCustomLocator(testFrameworkName, consoleProperties, environment, null);
    }

    public static BaseTestsOutputConsoleView createConsoleWithCustomLocator(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, ExecutionEnvironment environment, @Nullable TestLocationProvider locator) {
        return SMTestRunnerConnectionUtil.createConsoleWithCustomLocator(testFrameworkName, consoleProperties, environment, locator, false, null);
    }

    public static SMTRunnerConsoleView createConsoleWithCustomLocator(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, ExecutionEnvironment environment, @Nullable TestLocationProvider locator, boolean idBasedTreeConstruction, @Nullable TestProxyFilterProvider filterProvider) {
        String splitterPropertyName = SMTestRunnerConnectionUtil.getSplitterPropertyName(testFrameworkName);
        SMTRunnerConsoleView consoleView = new SMTRunnerConsoleView(consoleProperties, splitterPropertyName);
        SMTestRunnerConnectionUtil.initConsoleView(consoleView, testFrameworkName, locator, idBasedTreeConstruction, filterProvider);
        return consoleView;
    }

    public static void initConsoleView(final @NotNull SMTRunnerConsoleView consoleView, final @NotNull String testFrameworkName, final @Nullable TestLocationProvider locator, final boolean idBasedTreeConstruction, final @Nullable TestProxyFilterProvider filterProvider) {
        consoleView.addAttachToProcessListener(new AttachToProcessListener(){

            @Override
            public void onAttachToProcess(@NotNull ProcessHandler processHandler2) {
                TestConsoleProperties properties = consoleView.getProperties();
                CompositeTestLocationProvider testLocator = new CompositeTestLocationProvider(locator);
                TestProxyPrinterProvider printerProvider = null;
                if (filterProvider != null) {
                    printerProvider = new TestProxyPrinterProvider(consoleView, filterProvider);
                }
                SMTestRunnerResultsForm resultsForm = consoleView.getResultsViewer();
                SMTestRunnerConnectionUtil.attachEventsProcessors(properties, resultsForm, resultsForm.getStatisticsPane(), processHandler2, testFrameworkName, testLocator, idBasedTreeConstruction, printerProvider);
            }
        });
        consoleView.setHelpId("reference.runToolWindow.testResultsTab");
        consoleView.initUI();
    }

    public static ConsoleView createAndAttachConsole(@NotNull String testFrameworkName, @NotNull ProcessHandler processHandler2, @NotNull CommandLineState commandLineState, @NotNull ModuleRunConfiguration config, @NotNull Executor executor) throws ExecutionException {
        SMTRunnerConsoleProperties consoleProperties = new SMTRunnerConsoleProperties((RunConfiguration)config, testFrameworkName, executor);
        return SMTestRunnerConnectionUtil.createAndAttachConsole(testFrameworkName, processHandler2, consoleProperties, commandLineState.getEnvironment());
    }

    public static ConsoleView createConsole(@NotNull String testFrameworkName, @NotNull CommandLineState commandLineState, @NotNull ModuleRunConfiguration config, @NotNull Executor executor) throws ExecutionException {
        SMTRunnerConsoleProperties consoleProperties = new SMTRunnerConsoleProperties((RunConfiguration)config, testFrameworkName, executor);
        return SMTestRunnerConnectionUtil.createConsole(testFrameworkName, consoleProperties, commandLineState.getEnvironment());
    }

    private static class CombinedTestLocator
    implements SMTestLocator,
    DumbAware {
        private final SMTestLocator myLocator;

        public CombinedTestLocator(SMTestLocator locator) {
            this.myLocator = locator;
        }

        @Override
        @NotNull
        public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project2, @NotNull GlobalSearchScope scope) {
            if ("file".equals(protocol)) {
                return FileUrlProvider.INSTANCE.getLocation(protocol, path, project2, scope);
            }
            if (!DumbService.isDumb((Project)project2) || DumbService.isDumbAware((Object)this.myLocator) || Registry.is((String)"dumb.aware.run.configurations")) {
                return this.myLocator.getLocation(protocol, path, project2, scope);
            }
            return Collections.emptyList();
        }
    }
}

