/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm;

import com.intellij.execution.Location;
import com.intellij.execution.testframework.sm.FileUrlProvider;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testIntegration.TestLocationProvider;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeTestLocationProvider
implements SMTestLocator {
    private final TestLocationProvider myPrimaryLocator;
    private final TestLocationProvider[] myLocators;

    public CompositeTestLocationProvider(@Nullable TestLocationProvider primaryLocator) {
        this.myPrimaryLocator = primaryLocator;
        this.myLocators = (TestLocationProvider[])Extensions.getExtensions(TestLocationProvider.EP_NAME);
    }

    @Override
    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project2, @NotNull GlobalSearchScope scope) {
        List<Location> locations;
        boolean isDumbMode = DumbService.isDumb((Project)project2);
        if (!(this.myPrimaryLocator == null || isDumbMode && !(this.myPrimaryLocator instanceof DumbAware) || (locations = this.myPrimaryLocator.getLocation(protocol, path, project2)).isEmpty())) {
            return locations;
        }
        if ("file".equals(protocol) && !(locations = FileUrlProvider.INSTANCE.getLocation(protocol, path, project2, scope)).isEmpty()) {
            return locations;
        }
        for (TestLocationProvider provider : this.myLocators) {
            List<Location> locations2;
            if (isDumbMode && !(provider instanceof DumbAware) || (locations2 = provider.getLocation(protocol, path, project2)).isEmpty()) continue;
            return locations2;
        }
        return Collections.emptyList();
    }
}

