/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.autotest;

import com.intellij.execution.DelayedDocumentWatcher;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.content.Content;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="AutoTestManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class AutoTestManager
implements PersistentStateComponent<State> {
    private static final String AUTO_TEST_MANAGER_DELAY = "auto.test.manager.delay";
    private static final int AUTO_TEST_MANAGER_DELAY_DEFAULT = 3000;
    private static final Key<ProcessListener> ON_TERMINATION_RESTARTER_KEY = Key.create((String)"auto.test.manager.on.termination.restarter");
    private final Project myProject;
    private int myDelayMillis;
    private DelayedDocumentWatcher myDocumentWatcher;
    private final Set<RunProfile> myEnabledRunProfiles = ContainerUtil.newHashSet();

    @NotNull
    public static AutoTestManager getInstance(Project project2) {
        return (AutoTestManager)ServiceManager.getService((Project)project2, AutoTestManager.class);
    }

    public AutoTestManager(@NotNull Project project2) {
        this.myProject = project2;
        this.myDelayMillis = PropertiesComponent.getInstance((Project)project2).getInt(AUTO_TEST_MANAGER_DELAY, 3000);
        this.myDocumentWatcher = this.createWatcher();
    }

    @NotNull
    private DelayedDocumentWatcher createWatcher() {
        return new DelayedDocumentWatcher(this.myProject, this.myDelayMillis, new Consumer<Integer>(){

            public void consume(Integer modificationStamp) {
                AutoTestManager.this.restartAllAutoTests(modificationStamp);
            }
        }, new Condition<VirtualFile>(){

            public boolean value(VirtualFile file2) {
                if (ScratchFileService.getInstance().getRootType(file2) != null) {
                    return false;
                }
                return FileEditorManager.getInstance((Project)AutoTestManager.this.myProject).isFileOpen(file2);
            }
        });
    }

    public void setAutoTestEnabled(@NotNull RunContentDescriptor descriptor, @NotNull ExecutionEnvironment environment, boolean enabled) {
        Content content = descriptor.getAttachedContent();
        if (content != null) {
            if (enabled) {
                this.myEnabledRunProfiles.add(environment.getRunProfile());
                this.myDocumentWatcher.activate();
            } else {
                ProcessHandler processHandler2;
                this.myEnabledRunProfiles.remove(environment.getRunProfile());
                if (!this.hasEnabledAutoTests()) {
                    this.myDocumentWatcher.deactivate();
                }
                if ((processHandler2 = descriptor.getProcessHandler()) != null) {
                    AutoTestManager.clearRestarterListener(processHandler2);
                }
            }
        }
    }

    private boolean hasEnabledAutoTests() {
        RunContentManager contentManager = ExecutionManager.getInstance((Project)this.myProject).getContentManager();
        for (RunContentDescriptor descriptor : contentManager.getAllDescriptors()) {
            if (!this.isAutoTestEnabledForDescriptor(descriptor)) continue;
            return true;
        }
        return false;
    }

    public boolean isAutoTestEnabled(@NotNull RunContentDescriptor descriptor) {
        return this.isAutoTestEnabledForDescriptor(descriptor);
    }

    private boolean isAutoTestEnabledForDescriptor(@NotNull RunContentDescriptor descriptor) {
        Content content = descriptor.getAttachedContent();
        if (content != null) {
            ExecutionEnvironment environment = AutoTestManager.getCurrentEnvironment(content);
            return environment != null && this.myEnabledRunProfiles.contains(environment.getRunProfile());
        }
        return false;
    }

    @Nullable
    private static ExecutionEnvironment getCurrentEnvironment(@NotNull Content content) {
        JComponent component = content.getComponent();
        if (component == null) {
            return null;
        }
        return (ExecutionEnvironment)LangDataKeys.EXECUTION_ENVIRONMENT.getData(DataManager.getInstance().getDataContext((Component)component));
    }

    private static void clearRestarterListener(@NotNull ProcessHandler processHandler2) {
        ProcessListener restarterListener = (ProcessListener)ON_TERMINATION_RESTARTER_KEY.get((UserDataHolder)processHandler2, null);
        if (restarterListener != null) {
            processHandler2.removeProcessListener(restarterListener);
            ON_TERMINATION_RESTARTER_KEY.set((UserDataHolder)processHandler2, null);
        }
    }

    private void restartAllAutoTests(int modificationStamp) {
        RunContentManager contentManager = ExecutionManager.getInstance((Project)this.myProject).getContentManager();
        boolean active = false;
        for (RunContentDescriptor descriptor : contentManager.getAllDescriptors()) {
            if (!this.isAutoTestEnabledForDescriptor(descriptor)) continue;
            this.restartAutoTest(descriptor, modificationStamp, this.myDocumentWatcher);
            active = true;
        }
        if (!active) {
            this.myDocumentWatcher.deactivate();
        }
    }

    private void restartAutoTest(@NotNull RunContentDescriptor descriptor, int modificationStamp, @NotNull DelayedDocumentWatcher documentWatcher) {
        ProcessHandler processHandler2 = descriptor.getProcessHandler();
        if (processHandler2 != null && !processHandler2.isProcessTerminated()) {
            this.scheduleRestartOnTermination(descriptor, processHandler2, modificationStamp, documentWatcher);
        } else {
            AutoTestManager.restart(descriptor);
        }
    }

    private void scheduleRestartOnTermination(final @NotNull RunContentDescriptor descriptor, final @NotNull ProcessHandler processHandler2, final int modificationStamp, final @NotNull DelayedDocumentWatcher documentWatcher) {
        Object restarterListener = (ProcessListener)ON_TERMINATION_RESTARTER_KEY.get((UserDataHolder)processHandler2);
        if (restarterListener != null) {
            AutoTestManager.clearRestarterListener(processHandler2);
        }
        restarterListener = new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                AutoTestManager.clearRestarterListener(processHandler2);
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (AutoTestManager.this.isAutoTestEnabledForDescriptor(descriptor) && documentWatcher.isUpToDate(modificationStamp)) {
                            AutoTestManager.restart(descriptor);
                        }
                    }
                }, ModalityState.any());
            }
        };
        ON_TERMINATION_RESTARTER_KEY.set((UserDataHolder)processHandler2, restarterListener);
        processHandler2.addProcessListener(restarterListener);
    }

    private static void restart(@NotNull RunContentDescriptor descriptor) {
        descriptor.setActivateToolWindowWhenAdded(false);
        descriptor.setReuseToolWindowActivation(true);
        ExecutionUtil.restart((RunContentDescriptor)descriptor);
    }

    int getDelay() {
        return this.myDelayMillis;
    }

    void setDelay(int delay) {
        this.myDelayMillis = delay;
        this.myDocumentWatcher.deactivate();
        this.myDocumentWatcher = this.createWatcher();
        if (this.hasEnabledAutoTests()) {
            this.myDocumentWatcher.activate();
        }
        PropertiesComponent.getInstance((Project)this.myProject).setValue(AUTO_TEST_MANAGER_DELAY, this.myDelayMillis, 3000);
    }

    @Nullable
    public State getState() {
        State state = new State();
        for (RunProfile profile : this.myEnabledRunProfiles) {
            RunConfiguration runConfiguration = (RunConfiguration)ObjectUtils.tryCast((Object)profile, RunConfiguration.class);
            if (runConfiguration == null) continue;
            RunConfigurationDescriptor descriptor = new RunConfigurationDescriptor();
            descriptor.myType = runConfiguration.getType().getId();
            descriptor.myName = runConfiguration.getName();
            state.myEnabledRunConfigurations.add(descriptor);
        }
        return state;
    }

    public void loadState(State state) {
        ArrayList configurations = ContainerUtil.newArrayList();
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(this.myProject);
        List descriptors = ContainerUtil.notNullize(state.myEnabledRunConfigurations);
        for (RunConfigurationDescriptor descriptor : descriptors) {
            RunnerAndConfigurationSettings settings;
            RunConfiguration configuration;
            if (descriptor.myType == null || descriptor.myName == null || (configuration = (settings = runManager.findConfigurationByTypeAndName(descriptor.myType, descriptor.myName)) != null ? settings.getConfiguration() : null) == null) continue;
            configurations.add(configuration);
        }
        this.myEnabledRunProfiles.clear();
        this.myEnabledRunProfiles.addAll(configurations);
    }

    @Tag(value="run-configuration")
    static class RunConfigurationDescriptor {
        @Attribute(value="type")
        String myType;
        @Attribute(value="name")
        String myName;

        RunConfigurationDescriptor() {
        }
    }

    static class State {
        @Tag(value="enabled-run-configurations")
        @AbstractCollection(surroundWithTag=false)
        List<RunConfigurationDescriptor> myEnabledRunConfigurations = ContainerUtil.newArrayList();

        State() {
        }
    }
}

