/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.actions;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.impl.DiffWindowBase;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.execution.testframework.TestTreeViewAction;
import com.intellij.execution.testframework.actions.TestDiffRequestProcessor;
import com.intellij.execution.testframework.stacktrace.DiffHyperlink;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewAssertEqualsDiffAction
extends AnAction
implements TestTreeViewAction {
    @NonNls
    public static final String ACTION_ID = "openAssertEqualsDiff";

    public void actionPerformed(AnActionEvent e) {
        if (!ViewAssertEqualsDiffAction.openDiff(e.getDataContext(), null)) {
            Component component = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
            Messages.showInfoMessage((Component)component, (String)"Comparison error was not found", (String)"No Comparison Data Found");
        }
    }

    public static boolean openDiff(DataContext context, @Nullable DiffHyperlink currentHyperlink) {
        DiffHyperlink diffViewerProvider;
        AbstractTestProxy testProxy = (AbstractTestProxy)AbstractTestProxy.DATA_KEY.getData(context);
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(context);
        if (testProxy != null && (diffViewerProvider = testProxy.getDiffViewerProvider()) != null) {
            int index;
            List<DiffHyperlink> providers = ViewAssertEqualsDiffAction.collectAvailableProviders((TestFrameworkRunningModel)TestTreeView.MODEL_DATA_KEY.getData(context));
            int n = index = currentHyperlink != null ? providers.indexOf(currentHyperlink) : -1;
            if (index == -1) {
                index = providers.indexOf(diffViewerProvider);
            }
            new MyDiffWindow(project2, providers, Math.max(0, index)).show();
            return true;
        }
        if (currentHyperlink != null) {
            new MyDiffWindow(project2, currentHyperlink).show();
            return true;
        }
        return false;
    }

    private static List<DiffHyperlink> collectAvailableProviders(TestFrameworkRunningModel model) {
        ArrayList<DiffHyperlink> providers = new ArrayList<DiffHyperlink>();
        if (model != null) {
            AbstractTestProxy root = model.getRoot();
            List<? extends AbstractTestProxy> allTests = root.getAllTests();
            for (AbstractTestProxy abstractTestProxy : allTests) {
                if (!abstractTestProxy.isLeaf()) continue;
                providers.addAll(abstractTestProxy.getDiffViewerProviders());
            }
        }
        return providers;
    }

    public void update(AnActionEvent e) {
        AbstractTestProxy test;
        Presentation presentation = e.getPresentation();
        DataContext dataContext = e.getDataContext();
        boolean enabled = CommonDataKeys.PROJECT.getData(dataContext) == null ? false : ((test = (AbstractTestProxy)AbstractTestProxy.DATA_KEY.getData(dataContext)) != null ? (test.isLeaf() ? test.getDiffViewerProvider() != null : test.isDefect()) : false);
        presentation.setEnabled(enabled);
        presentation.setVisible(enabled);
    }

    private static class MyDiffWindow
    extends DiffWindowBase {
        @NotNull
        private final List<DiffHyperlink> myRequests;
        private final int myIndex;

        public MyDiffWindow(@Nullable Project project2, @NotNull DiffHyperlink request) {
            this(project2, Collections.singletonList(request), 0);
        }

        public MyDiffWindow(@Nullable Project project2, @NotNull List<DiffHyperlink> requests, int index) {
            super(project2, DiffDialogHints.DEFAULT);
            this.myRequests = requests;
            this.myIndex = index;
        }

        @Override
        @NotNull
        protected DiffRequestProcessor createProcessor() {
            return new MyTestDiffRequestProcessor(this.myProject, this.myRequests, this.myIndex);
        }

        private class MyTestDiffRequestProcessor
        extends TestDiffRequestProcessor {
            public MyTestDiffRequestProcessor(@NotNull Project project2, List<DiffHyperlink> requests, int index) {
                super(project2, requests, index);
                this.putContextUserData(DiffUserDataKeys.DIALOG_GROUP_KEY, "#com.intellij.execution.junit2.states.ComparisonFailureState$DiffDialog");
            }

            @Override
            protected void setWindowTitle(@NotNull String title) {
                MyDiffWindow.this.getWrapper().setTitle(title);
            }

            @Override
            protected void onAfterNavigate() {
                DiffUtil.closeWindow(MyDiffWindow.this.getWrapper().getWindow(), true, true);
            }
        }
    }
}

