/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.actions;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.NoDiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.testframework.stacktrace.DiffHyperlink;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestDiffRequestProcessor
extends DiffRequestProcessor {
    @NotNull
    private final List<DiffHyperlink> myRequests;
    private int myIndex;

    public TestDiffRequestProcessor(@Nullable Project project2, @NotNull List<DiffHyperlink> requests, int index) {
        super(project2, "TestsFiledAssertions");
        this.myRequests = requests;
        this.myIndex = index;
        this.putContextUserData(DiffUserDataKeys.DO_NOT_IGNORE_WHITESPACES, true);
    }

    @Override
    public void updateRequest(boolean force, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
        this.applyRequest(this.loadRequest(), force, scrollToChangePolicy);
    }

    @NotNull
    private DiffRequest loadRequest() {
        if (this.myIndex < 0 || this.myIndex >= this.myRequests.size()) {
            return NoDiffRequest.INSTANCE;
        }
        DiffHyperlink hyperlink = this.myRequests.get(this.myIndex);
        try {
            String title = hyperlink.getDiffTitle();
            Pair<String, DiffContent> content1 = this.createContentWithTitle("diff.content.expected.title", hyperlink.getLeft(), hyperlink.getFilePath());
            Pair<String, DiffContent> content2 = this.createContentWithTitle("diff.content.actual.title", hyperlink.getRight(), hyperlink.getActualFilePath());
            return new SimpleDiffRequest(title, (DiffContent)content1.second, (DiffContent)content2.second, (String)content1.first, (String)content2.first);
        }
        catch (Exception e) {
            return new ErrorDiffRequest((Throwable)e);
        }
    }

    private Pair<String, DiffContent> createContentWithTitle(String titleKey, String contentString, String contentFilePath) {
        DocumentContent content;
        String title;
        VirtualFile vFile;
        if (contentFilePath != null && (vFile = LocalFileSystem.getInstance().findFileByPath(contentFilePath)) != null) {
            title = ExecutionBundle.message((String)titleKey, (Object[])new Object[0]) + " (" + vFile.getPresentableUrl() + ")";
            content = DiffContentFactory.getInstance().create(this.getProject(), vFile);
        } else {
            title = ExecutionBundle.message((String)titleKey, (Object[])new Object[0]);
            content = DiffContentFactory.getInstance().create(contentString);
        }
        return Pair.create((Object)title, (Object)content);
    }

    @Override
    protected boolean hasNextChange() {
        return true;
    }

    @Override
    protected boolean hasPrevChange() {
        return true;
    }

    @Override
    protected void goToNextChange(boolean fromDifferences) {
        ++this.myIndex;
        if (this.myIndex >= this.myRequests.size()) {
            this.myIndex = 0;
        }
        this.updateRequest(false, fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE : null);
    }

    @Override
    protected void goToPrevChange(boolean fromDifferences) {
        --this.myIndex;
        if (this.myIndex < 0) {
            this.myIndex = this.myRequests.size() - 1;
        }
        this.updateRequest(false, fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.LAST_CHANGE : null);
    }

    @Override
    protected boolean isNavigationEnabled() {
        return this.myRequests.size() > 1;
    }
}

