/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.PredefinedLogFile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.WrappingRunConfiguration;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.components.JBList;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractRerunFailedTestsAction
extends AnAction
implements AnAction.TransparentUpdate {
    private static final Logger LOG = Logger.getInstance(AbstractRerunFailedTestsAction.class);
    private TestFrameworkRunningModel myModel;
    private Getter<TestFrameworkRunningModel> myModelProvider;
    protected TestConsoleProperties myConsoleProperties;

    protected AbstractRerunFailedTestsAction(@NotNull ComponentContainer componentContainer) {
        this.copyFrom(ActionManager.getInstance().getAction("RerunFailedTests"));
        this.registerCustomShortcutSet(this.getShortcutSet(), componentContainer.getComponent());
    }

    public void init(TestConsoleProperties consoleProperties) {
        this.myConsoleProperties = consoleProperties;
    }

    public void setModel(TestFrameworkRunningModel model) {
        this.myModel = model;
    }

    public void setModelProvider(Getter<TestFrameworkRunningModel> modelProvider) {
        this.myModelProvider = modelProvider;
    }

    public final void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabled(this.isActive(e));
    }

    private boolean isActive(AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 == null) {
            return false;
        }
        TestFrameworkRunningModel model = this.getModel();
        if (model == null || model.getRoot() == null) {
            return false;
        }
        Filter<?> filter = this.getFailuresFilter();
        for (AbstractTestProxy abstractTestProxy : model.getRoot().getAllTests()) {
            if (!filter.shouldAccept(abstractTestProxy)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected List<AbstractTestProxy> getFailedTests(@NotNull Project project2) {
        TestFrameworkRunningModel model = this.getModel();
        if (model == null) {
            return Collections.emptyList();
        }
        return this.getFilter(project2, model.getProperties().getScope()).select(model.getRoot().getAllTests());
    }

    @NotNull
    protected Filter getFilter(@NotNull Project project2, @NotNull GlobalSearchScope searchScope) {
        return this.getFailuresFilter();
    }

    protected Filter<?> getFailuresFilter() {
        return AbstractRerunFailedTestsAction.getFailuresFilter(this.myConsoleProperties);
    }

    public static Filter<?> getFailuresFilter(TestConsoleProperties consoleProperties) {
        if (TestConsoleProperties.INCLUDE_NON_STARTED_IN_RERUN_FAILED.value((AbstractProperty.AbstractPropertyContainer)consoleProperties)) {
            return Filter.NOT_PASSED.or(Filter.FAILED_OR_INTERRUPTED).and(Filter.IGNORED.not());
        }
        return Filter.FAILED_OR_INTERRUPTED.and(Filter.IGNORED.not());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ExecutionEnvironment environment = (ExecutionEnvironment)e.getData(LangDataKeys.EXECUTION_ENVIRONMENT);
        if (environment == null) {
            return;
        }
        this.execute(e, environment);
    }

    void execute(@NotNull AnActionEvent e, @NotNull ExecutionEnvironment environment) {
        MyRunProfile profile = this.getRunProfile(environment);
        if (profile == null) {
            return;
        }
        final ExecutionEnvironmentBuilder environmentBuilder = new ExecutionEnvironmentBuilder(environment).runProfile((RunProfile)profile);
        InputEvent event = e.getInputEvent();
        if (!(event instanceof MouseEvent) || !event.isShiftDown()) {
            AbstractRerunFailedTestsAction.performAction(environmentBuilder);
            return;
        }
        final LinkedHashMap<Executor, ProgramRunner> availableRunners = new LinkedHashMap<Executor, ProgramRunner>();
        for (Executor ex : new Executor[]{DefaultRunExecutor.getRunExecutorInstance(), DefaultDebugExecutor.getDebugExecutorInstance()}) {
            ProgramRunner runner = RunnerRegistry.getInstance().getRunner(ex.getId(), (RunProfile)profile);
            if (runner == null) continue;
            availableRunners.put(ex, runner);
        }
        if (availableRunners.isEmpty()) {
            LOG.error(environment.getExecutor().getActionName() + " is not available now");
        } else if (availableRunners.size() == 1) {
            AbstractRerunFailedTestsAction.performAction(environmentBuilder.runner((ProgramRunner)availableRunners.get(environment.getExecutor())));
        } else {
            final JBList list = new JBList(availableRunners.keySet());
            list.setSelectionMode(0);
            list.setSelectedValue((Object)environment.getExecutor(), true);
            list.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

                @Override
                @NotNull
                public Component getListCellRendererComponent(@NotNull JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (value instanceof Executor) {
                        this.setText(UIUtil.removeMnemonic((String)((Executor)value).getStartActionText()));
                        this.setIcon(((Executor)value).getIcon());
                    }
                    return component;
                }
            });
            JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Restart Failed Tests").setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(new Runnable(){

                @Override
                public void run() {
                    Object value = list.getSelectedValue();
                    if (value instanceof Executor) {
                        AbstractRerunFailedTestsAction.performAction(environmentBuilder.runner((ProgramRunner)availableRunners.get(value)).executor((Executor)value));
                    }
                }
            }).createPopup().showUnderneathOf(event.getComponent());
        }
    }

    private static void performAction(@NotNull ExecutionEnvironmentBuilder builder) {
        ExecutionEnvironment environment = builder.build();
        try {
            environment.getRunner().execute(environment);
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
        }
        finally {
            ((MyRunProfile)environment.getRunProfile()).clear();
        }
    }

    @Deprecated
    public MyRunProfile getRunProfile() {
        return null;
    }

    @Nullable
    protected MyRunProfile getRunProfile(@NotNull ExecutionEnvironment environment) {
        return this.getRunProfile();
    }

    @Nullable
    public TestFrameworkRunningModel getModel() {
        if (this.myModel != null) {
            return this.myModel;
        }
        if (this.myModelProvider != null) {
            return (TestFrameworkRunningModel)this.myModelProvider.get();
        }
        return null;
    }

    public boolean isDumbAware() {
        return Registry.is((String)"dumb.aware.run.configurations");
    }

    protected static abstract class MyRunProfile
    extends RunConfigurationBase
    implements ModuleRunProfile,
    WrappingRunConfiguration<RunConfigurationBase> {
        private final RunConfigurationBase myConfiguration;

        @Deprecated
        public RunConfigurationBase getConfiguration() {
            return this.getPeer();
        }

        public RunConfigurationBase getPeer() {
            return this.myConfiguration;
        }

        public MyRunProfile(RunConfigurationBase configuration) {
            super(configuration.getProject(), configuration.getFactory(), ActionsBundle.message((String)"action.RerunFailedTests.text", (Object[])new Object[0]));
            this.myConfiguration = configuration;
        }

        public void clear() {
        }

        public void checkConfiguration() throws RuntimeConfigurationException {
        }

        public void readExternal(Element element) throws InvalidDataException {
            this.myConfiguration.readExternal(element);
        }

        public void writeExternal(Element element) throws WriteExternalException {
            this.myConfiguration.writeExternal(element);
        }

        @NotNull
        public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
            return this.myConfiguration.getConfigurationEditor();
        }

        @NotNull
        public ConfigurationType getType() {
            return this.myConfiguration.getType();
        }

        public ConfigurationPerRunnerSettings createRunnerSettings(ConfigurationInfoProvider provider) {
            return this.myConfiguration.createRunnerSettings(provider);
        }

        public SettingsEditor<ConfigurationPerRunnerSettings> getRunnerSettingsEditor(ProgramRunner runner) {
            return this.myConfiguration.getRunnerSettingsEditor(runner);
        }

        public RunConfiguration clone() {
            return this.myConfiguration.clone();
        }

        public int getUniqueID() {
            return this.myConfiguration.getUniqueID();
        }

        public LogFileOptions getOptionsForPredefinedLogFile(PredefinedLogFile predefinedLogFile) {
            return this.myConfiguration.getOptionsForPredefinedLogFile(predefinedLogFile);
        }

        public ArrayList<PredefinedLogFile> getPredefinedLogFiles() {
            return this.myConfiguration.getPredefinedLogFiles();
        }

        @NotNull
        public ArrayList<LogFileOptions> getAllLogFiles() {
            return this.myConfiguration.getAllLogFiles();
        }

        public ArrayList<LogFileOptions> getLogFiles() {
            return this.myConfiguration.getLogFiles();
        }
    }
}

