/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.startup;

import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManagerAdapter;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.startup.ProjectStartupTaskManager;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Alarm;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ProjectStartupRunner
implements StartupActivity,
DumbAware {
    public static final int DELAY_MILLIS = 200;

    public void runActivity(@NotNull Project project2) {
        final ProjectStartupTaskManager projectStartupTaskManager = ProjectStartupTaskManager.getInstance(project2);
        if (projectStartupTaskManager.isEmpty()) {
            return;
        }
        RunManagerImpl.getInstanceImpl(project2).addRunManagerListener(new RunManagerAdapter(){

            @Override
            public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
                projectStartupTaskManager.delete(settings.getUniqueID());
            }

            @Override
            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings, String existingId) {
                if (existingId != null) {
                    projectStartupTaskManager.rename(existingId, settings);
                }
                projectStartupTaskManager.checkOnChange(settings);
            }

            @Override
            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                projectStartupTaskManager.checkOnChange(settings);
            }
        });
        Alarm alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project2);
        alarm.addRequest(ProjectStartupRunner.createRequest(project2, alarm), 200);
    }

    private static Runnable createRequest(final Project project2, final Alarm alarm) {
        return new Runnable(){

            @Override
            public void run() {
                if (!((StartupManagerEx)StartupManager.getInstance((Project)project2)).postStartupActivityPassed() && !Registry.is((String)"dumb.aware.run.configurations")) {
                    alarm.addRequest(ProjectStartupRunner.createRequest(project2, alarm), 200);
                } else {
                    ProjectStartupRunner.runActivities(project2);
                }
            }
        };
    }

    private static void runActivities(final Project project2) {
        ProjectStartupTaskManager projectStartupTaskManager = ProjectStartupTaskManager.getInstance(project2);
        ArrayList<RunnerAndConfigurationSettings> configurations = new ArrayList<RunnerAndConfigurationSettings>(projectStartupTaskManager.getLocalConfigurations());
        configurations.addAll(projectStartupTaskManager.getSharedConfigurations());
        final Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        for (final RunnerAndConfigurationSettings configuration : configurations) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!ProjectStartupRunner.canBeRun(configuration)) {
                        ProjectStartupTaskManager.NOTIFICATION_GROUP.createNotification("Project Startup Tasks:  Run Configuration '" + configuration.getName() + "' can not be started with 'Run' action.", MessageType.ERROR).notify(project2);
                        return;
                    }
                    ProgramRunnerUtil.executeConfiguration(project2, configuration, executor);
                    ProjectStartupTaskManager.NOTIFICATION_GROUP.createNotification("Project Startup Tasks:  started '" + configuration.getName() + "'", MessageType.INFO).notify(project2);
                }
            }, ModalityState.any());
        }
    }

    public static boolean canBeRun(@NotNull RunnerAndConfigurationSettings configuration) {
        return RunnerRegistry.getInstance().getRunner(DefaultRunExecutor.EXECUTOR_ID, (RunProfile)configuration.getConfiguration()) != null;
    }
}

