/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.scratch;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessAdapter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.DebuggingRunnerData;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.scratch.JavaScratchCompilationSupport;
import com.intellij.execution.scratch.JavaScratchConfigurable;
import com.intellij.execution.scratch.JavaScratchPositionManager;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScratchConfiguration
extends ApplicationConfiguration {
    public int SCRATCH_FILE_ID;

    protected JavaScratchConfiguration(String name, Project project2, ConfigurationFactory factory) {
        super(name, project2, factory);
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        JavaParametersUtil.checkAlternativeJRE(this);
        String className = this.MAIN_CLASS_NAME;
        if (className == null || className.length() == 0) {
            throw new RuntimeConfigurationError(ExecutionBundle.message((String)"no.main.class.specified.error.text", (Object[])new Object[0]));
        }
        if (this.SCRATCH_FILE_ID <= 0) {
            throw new RuntimeConfigurationError("No scratch file associated with configuration");
        }
        if (this.getScratchVirtualFile() == null) {
            throw new RuntimeConfigurationError("Associated scratch file not found");
        }
        ProgramParametersUtil.checkWorkingDirectoryExist(this, this.getProject(), ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule());
        JavaRunConfigurationExtensionManager.checkConfigurationIsValid((RunConfigurationBase)this);
    }

    @Override
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        ApplicationConfiguration.JavaApplicationCommandLineState<JavaScratchConfiguration> state = new ApplicationConfiguration.JavaApplicationCommandLineState<JavaScratchConfiguration>(this, env){

            @Override
            protected void setupJavaParameters(JavaParameters params) throws ExecutionException {
                super.setupJavaParameters(params);
                File scrachesOutput = JavaScratchCompilationSupport.getScratchOutputDirectory(JavaScratchConfiguration.this.getProject());
                if (scrachesOutput != null) {
                    params.getClassPath().add(scrachesOutput);
                }
            }

            @Override
            @NotNull
            protected OSProcessHandler startProcess() throws ExecutionException {
                VirtualFile vFile;
                OSProcessHandler handler2 = super.startProcess();
                if (this.getRunnerSettings() instanceof DebuggingRunnerData && (vFile = ((JavaScratchConfiguration)this.getConfiguration()).getScratchVirtualFile()) != null) {
                    DebuggerManager.getInstance((Project)JavaScratchConfiguration.this.getProject()).addDebugProcessListener((ProcessHandler)handler2, (DebugProcessListener)new DebugProcessAdapter(){

                        public void processAttached(DebugProcess process) {
                            if (vFile.isValid()) {
                                process.appendPositionManager((PositionManager)new JavaScratchPositionManager((DebugProcessImpl)process, vFile));
                            }
                            process.removeDebugProcessListener((DebugProcessListener)this);
                        }
                    });
                }
                return handler2;
            }
        };
        state.setConsoleBuilder(TextConsoleBuilderFactory.getInstance().createBuilder(this.getProject(), ((JavaRunConfigurationModule)this.getConfigurationModule()).getSearchScope()));
        return state;
    }

    @Override
    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new JavaScratchConfigurable(this.getProject());
    }

    public boolean isCompileBeforeLaunchAddedByDefault() {
        return true;
    }

    @Nullable
    public String getScratchFileUrl() {
        VirtualFile vFile = this.getScratchVirtualFile();
        return vFile != null ? vFile.getUrl() : null;
    }

    @Nullable
    public VirtualFile getScratchVirtualFile() {
        int id = this.SCRATCH_FILE_ID;
        if (id <= 0) {
            return null;
        }
        return ManagingFS.getInstance().findFileById(id);
    }
}

