/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessInfo {
    public static ProcessInfo[] EMPTY_ARRAY = new ProcessInfo[0];
    private final int myPid;
    @NotNull
    private final String myCommandLine;
    @NotNull
    private final Optional<String> myExecutablePath;
    @NotNull
    private final String myExecutableName;
    @NotNull
    private final String myArgs;

    public ProcessInfo(int pid, @NotNull String commandLine, @NotNull String executableName, @NotNull String args) {
        this.myPid = pid;
        this.myCommandLine = commandLine;
        this.myExecutablePath = Optional.empty();
        this.myExecutableName = executableName;
        this.myArgs = args;
    }

    public ProcessInfo(int pid, @NotNull String commandLine, @NotNull String executableName, @NotNull String args, @Nullable String executablePath) {
        this.myPid = pid;
        this.myCommandLine = commandLine;
        this.myExecutableName = executableName;
        this.myExecutablePath = StringUtil.isNotEmpty((String)executablePath) ? Optional.of(executablePath) : Optional.empty();
        this.myArgs = args;
    }

    public int getPid() {
        return this.myPid;
    }

    @NotNull
    public String getCommandLine() {
        return this.myCommandLine;
    }

    @NotNull
    public String getExecutableName() {
        return this.myExecutableName;
    }

    @NotNull
    public Optional<String> getExecutableCannonicalPath() {
        return this.myExecutablePath.map(s -> {
            try {
                return new File((String)s).getCanonicalPath();
            }
            catch (IOException e) {
                return s;
            }
        });
    }

    @NotNull
    public String getExecutableDisplayName() {
        return StringUtil.trimEnd((String)this.myExecutableName, (String)".exe", (boolean)true);
    }

    @NotNull
    public String getArgs() {
        return this.myArgs;
    }

    public String toString() {
        return this.myPid + " '" + this.myCommandLine + "' '" + this.myExecutableName + "' '" + this.myArgs + "'" + (this.myExecutablePath.isPresent() ? " " + this.myExecutablePath.get() : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessInfo info = (ProcessInfo)o;
        if (this.myPid != info.myPid) {
            return false;
        }
        if (!this.myExecutableName.equals(info.myExecutableName)) {
            return false;
        }
        if (!this.myArgs.equals(info.myArgs)) {
            return false;
        }
        if (!this.myCommandLine.equals(info.myCommandLine)) {
            return false;
        }
        return this.myExecutablePath.equals(info.myExecutablePath);
    }

    public int hashCode() {
        int result = this.myPid;
        result = 31 * result + this.myExecutableName.hashCode();
        result = 31 * result + this.myArgs.hashCode();
        result = 31 * result + this.myCommandLine.hashCode();
        return result;
    }
}

