/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.RunnerWinProcess;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.execution.process.impl.ProcessListUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jvnet.winp.WinProcess;

public class OSProcessUtil {
    private static final Logger LOG = Logger.getInstance(OSProcessUtil.class);

    @NotNull
    public static ProcessInfo[] getProcessList() {
        return ProcessListUtil.getProcessList();
    }

    public static boolean killProcessTree(@NotNull Process process) {
        if (SystemInfo.isWindows) {
            try {
                WinProcess winProcess = OSProcessUtil.createWinProcess(process);
                winProcess.killRecursively();
                return true;
            }
            catch (Throwable e) {
                LOG.info("Cannot kill process tree", e);
            }
        } else if (SystemInfo.isUnix) {
            return UnixProcessManager.sendSigKillToProcessTree((Process)process);
        }
        return false;
    }

    public static void killProcess(@NotNull Process process) {
        if (SystemInfo.isWindows) {
            try {
                WinProcess winProcess = OSProcessUtil.createWinProcess(process);
                winProcess.kill();
            }
            catch (Throwable e) {
                LOG.info("Cannot kill process", e);
            }
        } else if (SystemInfo.isUnix) {
            UnixProcessManager.sendSignal((int)UnixProcessManager.getProcessPid((Process)process), (int)9);
        }
    }

    public static int getProcessID(@NotNull Process process) {
        if (SystemInfo.isWindows) {
            try {
                return OSProcessUtil.createWinProcess(process).getPid();
            }
            catch (Throwable e) {
                LOG.info("Cannot get process id", e);
                return -1;
            }
        }
        if (SystemInfo.isUnix) {
            return UnixProcessManager.getProcessPid((Process)process);
        }
        throw new IllegalStateException("Unknown OS: " + SystemInfo.OS_NAME);
    }

    @NotNull
    private static WinProcess createWinProcess(@NotNull Process process) {
        if (process instanceof RunnerWinProcess) {
            process = ((RunnerWinProcess)process).getOriginalProcess();
        }
        return new WinProcess(process);
    }

    @Nullable
    public static List<String> getCommandLinesOfRunningProcesses() {
        ArrayList<String> result = new ArrayList<String>();
        for (ProcessInfo each : OSProcessUtil.getProcessList()) {
            result.add(each.getCommandLine());
        }
        return Collections.unmodifiableList(result);
    }
}

