/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.info;

import com.intellij.execution.Location;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;

public class LocationUtil {
    public static boolean isJarAttached(@NotNull Location location, @NotNull PsiPackage aPackage, String fqn) {
        return LocationUtil.isJarAttached(location, fqn, aPackage.getDirectories());
    }

    public static boolean isJarAttached(@NotNull Location location, String fqn, PsiDirectory[] directories) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)location.getProject());
        boolean testngJarFound = false;
        Module locationModule = location.getModule();
        if (locationModule != null) {
            testngJarFound = facade.findClass(fqn, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)locationModule, (boolean)true)) != null;
        } else {
            for (PsiDirectory directory : directories) {
                Module module2 = ModuleUtilCore.findModuleForFile((VirtualFile)directory.getVirtualFile(), (Project)location.getProject());
                if (module2 == null || facade.findClass(fqn, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module2, (boolean)true)) == null) continue;
                testngJarFound = true;
                break;
            }
        }
        return testngJarFound;
    }
}

