/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.util.Comparing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunnerRegistryImpl
extends RunnerRegistry {
    public boolean hasRunner(@NotNull String executorId, @NotNull RunProfile settings) {
        return this.getRunner(executorId, settings) != null;
    }

    public ProgramRunner getRunner(@NotNull String executorId, @Nullable RunProfile settings) {
        if (settings == null) {
            return null;
        }
        for (ProgramRunner runner : (ProgramRunner[])ProgramRunner.PROGRAM_RUNNER_EP.getExtensions()) {
            if (!runner.canRun(executorId, settings)) continue;
            return runner;
        }
        return null;
    }

    public ProgramRunner[] getRegisteredRunners() {
        return (ProgramRunner[])ProgramRunner.PROGRAM_RUNNER_EP.getExtensions();
    }

    @Nullable
    public ProgramRunner findRunnerById(String id) {
        for (ProgramRunner registeredRunner : (ProgramRunner[])ProgramRunner.PROGRAM_RUNNER_EP.getExtensions()) {
            if (!Comparing.equal((String)id, (String)registeredRunner.getRunnerId())) continue;
            return registeredRunner;
        }
        return null;
    }
}

