/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.ProjectTopics;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleComponent;
import com.intellij.openapi.project.ModuleAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ModuleRunConfigurationManager")
public final class ModuleRunConfigurationManager
extends ModuleAdapter
implements ModuleComponent,
PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(ModuleRunConfigurationManager.class);
    @NonNls
    static final String COMPONENT_NAME = "ModuleRunConfigurationManager";
    @NotNull
    private final Condition<RunnerAndConfigurationSettings> myModuleConfigCondition = new Condition<RunnerAndConfigurationSettings>(){

        public boolean value(@Nullable RunnerAndConfigurationSettings settings) {
            return settings != null && ModuleRunConfigurationManager.this.usesMyModule(settings.getConfiguration());
        }
    };
    @NotNull
    private final Module myModule;
    @NotNull
    private final RunManagerImpl myManager;
    @Nullable
    private List<Element> myUnloadedElements = null;

    public ModuleRunConfigurationManager(@NotNull Module module2, @NotNull RunManagerImpl runManager) {
        this.myModule = module2;
        this.myManager = runManager;
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void moduleAdded() {
    }

    public void initComponent() {
        LOG.debug("initComponent(" + this.myModule + ")");
        this.myModule.getMessageBus().connect((Disposable)this.myModule).subscribe(ProjectTopics.MODULES, (Object)this);
    }

    public void disposeComponent() {
    }

    @NotNull
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    @Nullable
    public Element getState() {
        try {
            Element e = new Element("state");
            this.writeExternal(e);
            return e;
        }
        catch (WriteExternalException e1) {
            LOG.error((Throwable)e1);
            return null;
        }
    }

    public void loadState(Element state) {
        try {
            this.readExternal(state);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    private Collection<? extends RunnerAndConfigurationSettings> getModuleRunConfigurationSettings() {
        return ContainerUtil.filter(this.myManager.getConfigurationSettings(), this.myModuleConfigCondition);
    }

    private boolean usesMyModule(RunConfiguration config) {
        return config instanceof ModuleBasedConfiguration && this.myModule.equals(((ModuleBasedConfiguration)config).getConfigurationModule().getModule());
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        LOG.debug("writeExternal(" + this.myModule + ")");
        for (RunnerAndConfigurationSettings runnerAndConfigurationSettings : this.getModuleRunConfigurationSettings()) {
            this.myManager.addConfigurationElement(element, runnerAndConfigurationSettings);
        }
        if (this.myUnloadedElements != null) {
            for (Element element2 : this.myUnloadedElements) {
                element.addContent(element2.clone());
            }
        }
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        LOG.debug("readExternal(" + this.myModule + ")");
        this.myUnloadedElements = null;
        HashSet existing = new HashSet();
        List children2 = element.getChildren();
        for (Object child : children2) {
            RunnerAndConfigurationSettings configuration = this.myManager.loadConfiguration((Element)child, true);
            if (configuration == null && Comparing.strEqual((String)element.getName(), (String)"configuration")) {
                if (this.myUnloadedElements == null) {
                    this.myUnloadedElements = new ArrayList<Element>(2);
                }
                this.myUnloadedElements.add(element);
            }
            if (configuration == null) continue;
            existing.add(configuration.getUniqueID());
        }
        for (RunConfiguration configuration : this.myManager.getAllConfigurationsList()) {
            RunnerAndConfigurationSettings settings;
            if (this.usesMyModule(configuration) || (settings = this.myManager.getSettings(configuration)) == null) continue;
            existing.add(settings.getUniqueID());
        }
        this.myManager.removeNotExistingSharedConfigurations((Set<String>)existing);
        this.myManager.setOrdered(false);
        this.myManager.getSortedConfigurations();
    }

    public void beforeModuleRemoved(@NotNull Project project2, @NotNull Module module2) {
        if (this.myModule.equals(module2)) {
            LOG.debug("time to remove something from project (" + project2 + ")");
            for (RunnerAndConfigurationSettings runnerAndConfigurationSettings : this.getModuleRunConfigurationSettings()) {
                this.myManager.removeConfiguration(runnerAndConfigurationSettings);
            }
        }
    }
}

