/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.CommonBundle;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManagerConfig;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunProfileStarter;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configuration.CompatibilityAwareRunProfile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.docking.DockManager;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionManagerImpl
extends ExecutionManager
implements Disposable {
    public static final Key<Object> EXECUTION_SESSION_ID_KEY = Key.create((String)"EXECUTION_SESSION_ID_KEY");
    public static final Key<Boolean> EXECUTION_SKIP_RUN = Key.create((String)"EXECUTION_SKIP_RUN");
    private static final Logger LOG = Logger.getInstance(ExecutionManagerImpl.class);
    private static final ProcessHandler[] EMPTY_PROCESS_HANDLERS = new ProcessHandler[0];
    private final Project myProject;
    private final Alarm awaitingTerminationAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private final List<Trinity<RunContentDescriptor, RunnerAndConfigurationSettings, Executor>> myRunningConfigurations = ContainerUtil.createLockFreeCopyOnWriteList();
    private RunContentManagerImpl myContentManager;
    private volatile boolean myForceCompilationInTests;

    @NotNull
    public static ExecutionManagerImpl getInstance(@NotNull Project project2) {
        return (ExecutionManagerImpl)((Object)ServiceManager.getService((Project)project2, ExecutionManager.class));
    }

    protected ExecutionManagerImpl(@NotNull Project project2) {
        this.myProject = project2;
    }

    @NotNull
    private static ExecutionEnvironmentBuilder createEnvironmentBuilder(@NotNull Project project2, @NotNull Executor executor, @Nullable RunnerAndConfigurationSettings configuration) {
        ExecutionEnvironmentBuilder builder = new ExecutionEnvironmentBuilder(project2, executor);
        ProgramRunner runner = RunnerRegistry.getInstance().getRunner(executor.getId(), (RunProfile)(configuration != null ? configuration.getConfiguration() : null));
        if (runner == null && configuration != null) {
            LOG.error("Cannot find runner for " + configuration.getName());
        } else if (runner != null) {
            assert (configuration != null);
            builder.runnerAndSettings(runner, configuration);
        }
        return builder;
    }

    public static boolean isProcessRunning(@Nullable RunContentDescriptor descriptor) {
        ProcessHandler processHandler2 = descriptor == null ? null : descriptor.getProcessHandler();
        return processHandler2 != null && !processHandler2.isProcessTerminated();
    }

    private static void start(@NotNull ExecutionEnvironment environment) {
        RunnerAndConfigurationSettings settings = environment.getRunnerAndConfigurationSettings();
        ProgramRunnerUtil.executeConfiguration(environment, settings != null && settings.isEditBeforeRun(), true);
    }

    private static boolean userApprovesStopForSameTypeConfigurations(Project project2, String configName, int instancesCount) {
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(project2);
        final RunManagerConfig config = runManager.getConfig();
        if (!config.isRestartRequiresConfirmation()) {
            return true;
        }
        DialogWrapper.DoNotAskOption option = new DialogWrapper.DoNotAskOption(){

            public boolean isToBeShown() {
                return config.isRestartRequiresConfirmation();
            }

            public void setToBeShown(boolean value, int exitCode) {
                config.setRestartRequiresConfirmation(value);
            }

            public boolean canBeHidden() {
                return true;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return false;
            }

            @NotNull
            public String getDoNotShowMessage() {
                return CommonBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]);
            }
        };
        return Messages.showOkCancelDialog((Project)project2, (String)ExecutionBundle.message((String)"rerun.singleton.confirmation.message", (Object[])new Object[]{configName, instancesCount}), (String)ExecutionBundle.message((String)"process.is.running.dialog.title", (Object[])new Object[]{configName}), (String)ExecutionBundle.message((String)"rerun.confirmation.button.text", (Object[])new Object[0]), (String)CommonBundle.message((String)"button.cancel", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)option) == 0;
    }

    private static boolean userApprovesStopForIncompatibleConfigurations(Project project2, String configName, List<RunContentDescriptor> runningIncompatibleDescriptors) {
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(project2);
        final RunManagerConfig config = runManager.getConfig();
        if (!config.isStopIncompatibleRequiresConfirmation()) {
            return true;
        }
        DialogWrapper.DoNotAskOption option = new DialogWrapper.DoNotAskOption(){

            public boolean isToBeShown() {
                return config.isStopIncompatibleRequiresConfirmation();
            }

            public void setToBeShown(boolean value, int exitCode) {
                config.setStopIncompatibleRequiresConfirmation(value);
            }

            public boolean canBeHidden() {
                return true;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return false;
            }

            @NotNull
            public String getDoNotShowMessage() {
                return CommonBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]);
            }
        };
        StringBuilder names = new StringBuilder();
        for (RunContentDescriptor descriptor : runningIncompatibleDescriptors) {
            String name = descriptor.getDisplayName();
            if (names.length() > 0) {
                names.append(", ");
            }
            names.append(StringUtil.isEmpty((String)name) ? ExecutionBundle.message((String)"run.configuration.no.name", (Object[])new Object[0]) : String.format("'%s'", name));
        }
        return Messages.showOkCancelDialog((Project)project2, (String)ExecutionBundle.message((String)"stop.incompatible.confirmation.message", (Object[])new Object[]{configName, names.toString(), runningIncompatibleDescriptors.size()}), (String)ExecutionBundle.message((String)"incompatible.configuration.is.running.dialog.title", (Object[])new Object[]{runningIncompatibleDescriptors.size()}), (String)ExecutionBundle.message((String)"stop.incompatible.confirmation.button.text", (Object[])new Object[0]), (String)CommonBundle.message((String)"button.cancel", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)option) == 0;
    }

    private static void stop(@Nullable RunContentDescriptor descriptor) {
        ProcessHandler processHandler2;
        ProcessHandler processHandler3 = processHandler2 = descriptor != null ? descriptor.getProcessHandler() : null;
        if (processHandler2 == null) {
            return;
        }
        if (processHandler2 instanceof KillableProcess && processHandler2.isProcessTerminating()) {
            ((KillableProcess)processHandler2).killProcess();
            return;
        }
        if (!processHandler2.isProcessTerminated()) {
            if (processHandler2.detachIsDefault()) {
                processHandler2.detachProcess();
            } else {
                processHandler2.destroyProcess();
            }
        }
    }

    public void dispose() {
        for (Trinity<RunContentDescriptor, RunnerAndConfigurationSettings, Executor> trinity : this.myRunningConfigurations) {
            Disposer.dispose((Disposable)((Disposable)trinity.first));
        }
        this.myRunningConfigurations.clear();
    }

    @NotNull
    public RunContentManager getContentManager() {
        if (this.myContentManager == null) {
            this.myContentManager = new RunContentManagerImpl(this.myProject, DockManager.getInstance((Project)this.myProject));
            Disposer.register((Disposable)this.myProject, (Disposable)this.myContentManager);
        }
        return this.myContentManager;
    }

    @NotNull
    public ProcessHandler[] getRunningProcesses() {
        if (this.myContentManager == null) {
            return EMPTY_PROCESS_HANDLERS;
        }
        List handlers = null;
        for (RunContentDescriptor descriptor : this.getContentManager().getAllDescriptors()) {
            ProcessHandler processHandler2 = descriptor.getProcessHandler();
            if (processHandler2 == null) continue;
            if (handlers == null) {
                handlers = new SmartList();
            }
            handlers.add(processHandler2);
        }
        return handlers == null ? EMPTY_PROCESS_HANDLERS : handlers.toArray(new ProcessHandler[handlers.size()]);
    }

    public void compileAndRun(final @NotNull Runnable startRunnable, final @NotNull ExecutionEnvironment environment, @Nullable RunProfileState state, final @Nullable Runnable onCancelRunnable) {
        RunProfile profile;
        long id = environment.getExecutionId();
        if (id == 0L) {
            id = environment.assignNewExecutionId();
        }
        if (!((profile = environment.getRunProfile()) instanceof RunConfiguration)) {
            startRunnable.run();
            return;
        }
        final RunConfiguration runConfiguration = (RunConfiguration)profile;
        final List<BeforeRunTask> beforeRunTasks = RunManagerEx.getInstanceEx(this.myProject).getBeforeRunTasks(runConfiguration);
        if (beforeRunTasks.isEmpty()) {
            startRunnable.run();
        } else {
            DataContext context = environment.getDataContext();
            final DataContext projectContext = context != null ? context : SimpleDataContext.getProjectContext(this.myProject);
            final long finalId = id;
            final Long executionSessionId = new Long(id);
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    for (BeforeRunTask task : beforeRunTasks) {
                        if (ExecutionManagerImpl.this.myProject.isDisposed()) {
                            return;
                        }
                        BeforeRunTaskProvider provider = BeforeRunTaskProvider.getProvider((Project)ExecutionManagerImpl.this.myProject, (Key)task.getProviderId());
                        if (provider == null) {
                            LOG.warn("Cannot find BeforeRunTaskProvider for id='" + task.getProviderId() + "'");
                            continue;
                        }
                        ExecutionEnvironment taskEnvironment = new ExecutionEnvironmentBuilder(environment).contentToReuse(null).build();
                        taskEnvironment.setExecutionId(finalId);
                        EXECUTION_SESSION_ID_KEY.set((UserDataHolder)taskEnvironment, (Object)executionSessionId);
                        if (provider.executeTask(projectContext, runConfiguration, taskEnvironment, task)) continue;
                        if (onCancelRunnable != null) {
                            SwingUtilities.invokeLater(onCancelRunnable);
                        }
                        return;
                    }
                    ExecutionManagerImpl.this.doRun(environment, startRunnable);
                }
            });
        }
    }

    protected void doRun(final @NotNull ExecutionEnvironment environment, final @NotNull Runnable startRunnable) {
        Boolean allowSkipRun = (Boolean)environment.getUserData(EXECUTION_SKIP_RUN);
        if (allowSkipRun != null && allowSkipRun.booleanValue()) {
            ((ExecutionListener)environment.getProject().getMessageBus().syncPublisher(EXECUTION_TOPIC)).processNotStarted(environment.getExecutor().getId(), environment);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!ExecutionManagerImpl.this.myProject.isDisposed()) {
                        if (!Registry.is((String)"dumb.aware.run.configurations")) {
                            DumbService.getInstance((Project)ExecutionManagerImpl.this.myProject).runWhenSmart(startRunnable);
                        } else {
                            try {
                                DumbService.getInstance((Project)ExecutionManagerImpl.this.myProject).setAlternativeResolveEnabled(true);
                                startRunnable.run();
                            }
                            catch (IndexNotReadyException ignored) {
                                ExecutionUtil.handleExecutionError((ExecutionEnvironment)environment, (ExecutionException)new ExecutionException("cannot start while indexing is in progress."));
                            }
                            finally {
                                DumbService.getInstance((Project)ExecutionManagerImpl.this.myProject).setAlternativeResolveEnabled(false);
                            }
                        }
                    }
                }
            });
        }
    }

    public void startRunProfile(final @NotNull RunProfileStarter starter, final @NotNull RunProfileState state, final @NotNull ExecutionEnvironment environment) {
        final Project project2 = environment.getProject();
        RunContentDescriptor reuseContent = this.getContentManager().getReuseContent(environment);
        if (reuseContent != null) {
            reuseContent.setExecutionId(environment.getExecutionId());
            environment.setContentToReuse(reuseContent);
        }
        final Executor executor = environment.getExecutor();
        ((ExecutionListener)project2.getMessageBus().syncPublisher(EXECUTION_TOPIC)).processStartScheduled(executor.getId(), environment);
        Runnable startRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (project2.isDisposed()) {
                    return;
                }
                RunProfile profile = environment.getRunProfile();
                boolean started = false;
                try {
                    ((ExecutionListener)project2.getMessageBus().syncPublisher(ExecutionManager.EXECUTION_TOPIC)).processStarting(executor.getId(), environment);
                    RunContentDescriptor descriptor = starter.execute(state, environment);
                    if (descriptor != null) {
                        final Trinity trinity = Trinity.create((Object)descriptor, (Object)environment.getRunnerAndConfigurationSettings(), (Object)executor);
                        ExecutionManagerImpl.this.myRunningConfigurations.add(trinity);
                        Disposer.register((Disposable)descriptor, (Disposable)new Disposable(){

                            public void dispose() {
                                ExecutionManagerImpl.this.myRunningConfigurations.remove(trinity);
                            }
                        });
                        ExecutionManagerImpl.this.getContentManager().showRunContent(executor, descriptor, environment.getContentToReuse());
                        ProcessHandler processHandler2 = descriptor.getProcessHandler();
                        if (processHandler2 != null) {
                            if (!processHandler2.isStartNotified()) {
                                processHandler2.startNotify();
                            }
                            ((ExecutionListener)project2.getMessageBus().syncPublisher(ExecutionManager.EXECUTION_TOPIC)).processStarted(executor.getId(), environment, processHandler2);
                            started = true;
                            processHandler2.addProcessListener((ProcessListener)new ProcessExecutionListener(project2, profile, processHandler2));
                        }
                        environment.setContentToReuse(descriptor);
                    }
                }
                catch (ProcessCanceledException e) {
                    LOG.info((Throwable)e);
                }
                catch (ExecutionException e) {
                    ExecutionUtil.handleExecutionError((Project)project2, (String)executor.getToolWindowId(), (RunProfile)profile, (ExecutionException)e);
                    LOG.info((Throwable)e);
                }
                finally {
                    if (!started) {
                        ((ExecutionListener)project2.getMessageBus().syncPublisher(ExecutionManager.EXECUTION_TOPIC)).processNotStarted(executor.getId(), environment);
                    }
                }
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode() && !this.myForceCompilationInTests) {
            startRunnable.run();
        } else {
            this.compileAndRun(startRunnable, environment, state, new Runnable(){

                @Override
                public void run() {
                    if (!project2.isDisposed()) {
                        ((ExecutionListener)project2.getMessageBus().syncPublisher(ExecutionManager.EXECUTION_TOPIC)).processNotStarted(executor.getId(), environment);
                    }
                }
            });
        }
    }

    public void restartRunProfile(@NotNull Project project2, @NotNull Executor executor, @NotNull ExecutionTarget target, @Nullable RunnerAndConfigurationSettings configuration, @Nullable ProcessHandler processHandler2) {
        ExecutionEnvironmentBuilder builder = ExecutionManagerImpl.createEnvironmentBuilder(project2, executor, configuration);
        if (processHandler2 != null) {
            for (RunContentDescriptor descriptor : this.getContentManager().getAllDescriptors()) {
                if (descriptor.getProcessHandler() != processHandler2) continue;
                builder.contentToReuse(descriptor);
                break;
            }
        }
        this.restartRunProfile(builder.target(target).build());
    }

    public void restartRunProfile(final @NotNull ExecutionEnvironment environment) {
        RunnerAndConfigurationSettings configuration = environment.getRunnerAndConfigurationSettings();
        List<Object> runningIncompatible = configuration == null ? Collections.emptyList() : this.getIncompatibleRunningDescriptors(configuration);
        RunContentDescriptor contentToReuse = environment.getContentToReuse();
        SmartList runningOfTheSameType = new SmartList();
        if (configuration != null && configuration.isSingleton()) {
            runningOfTheSameType.addAll(this.getRunningDescriptorsOfTheSameConfigType(configuration));
        } else if (ExecutionManagerImpl.isProcessRunning(contentToReuse)) {
            runningOfTheSameType.add(contentToReuse);
        }
        List runningToStop = ContainerUtil.concat((List)runningOfTheSameType, runningIncompatible);
        if (!runningToStop.isEmpty()) {
            if (configuration != null) {
                if (!(runningOfTheSameType.isEmpty() || runningOfTheSameType.size() <= 1 && contentToReuse != null && runningOfTheSameType.get(0) == contentToReuse || ExecutionManagerImpl.userApprovesStopForSameTypeConfigurations(environment.getProject(), configuration.getName(), runningOfTheSameType.size()))) {
                    return;
                }
                if (!runningIncompatible.isEmpty() && !ExecutionManagerImpl.userApprovesStopForIncompatibleConfigurations(this.myProject, configuration.getName(), runningIncompatible)) {
                    return;
                }
            }
            for (RunContentDescriptor descriptor : runningToStop) {
                ExecutionManagerImpl.stop(descriptor);
            }
        }
        this.awaitingTerminationAlarm.addRequest(new Runnable((List)runningOfTheSameType){
            final /* synthetic */ List val$runningOfTheSameType;
            {
                this.val$runningOfTheSameType = list;
            }

            @Override
            public void run() {
                if (DumbService.getInstance((Project)ExecutionManagerImpl.this.myProject).isDumb() && !Registry.is((String)"dumb.aware.run.configurations") || ExecutorRegistry.getInstance().isStarting(environment)) {
                    ExecutionManagerImpl.this.awaitingTerminationAlarm.addRequest((Runnable)this, 100);
                    return;
                }
                for (RunContentDescriptor descriptor : this.val$runningOfTheSameType) {
                    ProcessHandler processHandler2 = descriptor.getProcessHandler();
                    if (processHandler2 == null || processHandler2.isProcessTerminated()) continue;
                    ExecutionManagerImpl.this.awaitingTerminationAlarm.addRequest((Runnable)this, 100);
                    return;
                }
                ExecutionManagerImpl.start(environment);
            }
        }, 50);
    }

    public void setForceCompilationInTests(boolean forceCompilationInTests) {
        this.myForceCompilationInTests = forceCompilationInTests;
    }

    @NotNull
    private List<RunContentDescriptor> getRunningDescriptorsOfTheSameConfigType(final @NotNull RunnerAndConfigurationSettings configurationAndSettings) {
        return this.getRunningDescriptors(new Condition<RunnerAndConfigurationSettings>(){

            public boolean value(@Nullable RunnerAndConfigurationSettings runningConfigurationAndSettings) {
                return configurationAndSettings == runningConfigurationAndSettings;
            }
        });
    }

    @NotNull
    private List<RunContentDescriptor> getIncompatibleRunningDescriptors(@NotNull RunnerAndConfigurationSettings configurationAndSettings) {
        final RunConfiguration configurationToCheckCompatibility = configurationAndSettings.getConfiguration();
        return this.getRunningDescriptors(new Condition<RunnerAndConfigurationSettings>(){

            public boolean value(@Nullable RunnerAndConfigurationSettings runningConfigurationAndSettings) {
                RunConfiguration runningConfiguration;
                RunConfiguration runConfiguration = runningConfiguration = runningConfigurationAndSettings == null ? null : runningConfigurationAndSettings.getConfiguration();
                if (runningConfiguration == null || !(runningConfiguration instanceof CompatibilityAwareRunProfile)) {
                    return false;
                }
                return ((CompatibilityAwareRunProfile)runningConfiguration).mustBeStoppedToRun(configurationToCheckCompatibility);
            }
        });
    }

    @NotNull
    public List<RunContentDescriptor> getRunningDescriptors(@NotNull Condition<RunnerAndConfigurationSettings> condition) {
        SmartList result = new SmartList();
        for (Trinity<RunContentDescriptor, RunnerAndConfigurationSettings, Executor> trinity : this.myRunningConfigurations) {
            ProcessHandler processHandler2;
            if (!condition.value(trinity.getSecond()) || (processHandler2 = ((RunContentDescriptor)trinity.getFirst()).getProcessHandler()) == null || processHandler2.isProcessTerminated()) continue;
            result.add(trinity.getFirst());
        }
        return result;
    }

    @NotNull
    public Set<Executor> getExecutors(RunContentDescriptor descriptor) {
        HashSet<Executor> result = new HashSet<Executor>();
        for (Trinity<RunContentDescriptor, RunnerAndConfigurationSettings, Executor> trinity : this.myRunningConfigurations) {
            if (descriptor != trinity.first) continue;
            result.add((Executor)trinity.third);
        }
        return result;
    }

    private static class ProcessExecutionListener
    extends ProcessAdapter {
        private final Project myProject;
        private final RunProfile myProfile;
        private final ProcessHandler myProcessHandler;

        public ProcessExecutionListener(Project project2, RunProfile profile, ProcessHandler processHandler2) {
            this.myProject = project2;
            this.myProfile = profile;
            this.myProcessHandler = processHandler2;
        }

        public void processTerminated(ProcessEvent event) {
            if (this.myProject.isDisposed()) {
                return;
            }
            ((ExecutionListener)this.myProject.getMessageBus().syncPublisher(ExecutionManager.EXECUTION_TOPIC)).processTerminated(this.myProfile, this.myProcessHandler);
            SaveAndSyncHandler saveAndSyncHandler = SaveAndSyncHandler.getInstance();
            if (saveAndSyncHandler != null) {
                saveAndSyncHandler.scheduleRefresh();
            }
        }

        public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
            if (this.myProject.isDisposed()) {
                return;
            }
            ((ExecutionListener)this.myProject.getMessageBus().syncPublisher(ExecutionManager.EXECUTION_TOPIC)).processTerminating(this.myProfile, this.myProcessHandler);
        }
    }
}

