/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.DelegateColorScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.Font;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleViewUtil {
    public static final Key<Boolean> EDITOR_IS_CONSOLE_VIEW = Key.create((String)"EDITOR_IS_CONSOLE_VIEW");

    public static EditorEx setupConsoleEditor(Project project2, boolean foldingOutlineShown, boolean lineMarkerAreaShown) {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document document = ((EditorFactoryImpl)editorFactory).createDocument(true);
        UndoUtil.disableUndoFor((Document)document);
        EditorEx editor = (EditorEx)editorFactory.createViewer(document, project2);
        ConsoleViewUtil.setupConsoleEditor(editor, foldingOutlineShown, lineMarkerAreaShown);
        return editor;
    }

    public static void setupConsoleEditor(final @NotNull EditorEx editor, final boolean foldingOutlineShown, final boolean lineMarkerAreaShown) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                editor.setSoftWrapAppliancePlace(SoftWrapAppliancePlaces.CONSOLE);
                EditorSettings editorSettings = editor.getSettings();
                editorSettings.setLineMarkerAreaShown(lineMarkerAreaShown);
                editorSettings.setIndentGuidesShown(false);
                editorSettings.setLineNumbersShown(false);
                editorSettings.setFoldingOutlineShown(foldingOutlineShown);
                editorSettings.setAdditionalPageAtBottom(false);
                editorSettings.setAdditionalColumnsCount(0);
                editorSettings.setAdditionalLinesCount(0);
                editorSettings.setRightMarginShown(false);
                editorSettings.setCaretRowShown(false);
                editor.getGutterComponentEx().setPaintBackground(false);
                editor.putUserData(EDITOR_IS_CONSOLE_VIEW, true);
                DelegateColorScheme scheme = ConsoleViewUtil.updateConsoleColorScheme(editor.getColorsScheme());
                if (UISettings.getInstance().PRESENTATION_MODE) {
                    scheme.setEditorFontSize(UISettings.getInstance().PRESENTATION_MODE_FONT_SIZE);
                }
                editor.setColorsScheme(scheme);
            }
        });
    }

    @NotNull
    public static DelegateColorScheme updateConsoleColorScheme(@NotNull EditorColorsScheme scheme) {
        return new DelegateColorScheme(scheme){

            @Override
            @NotNull
            public Color getDefaultBackground() {
                Color color = this.getColor(ConsoleViewContentType.CONSOLE_BACKGROUND_KEY);
                return color == null ? super.getDefaultBackground() : color;
            }

            @Override
            @NotNull
            public FontPreferences getFontPreferences() {
                return this.getConsoleFontPreferences();
            }

            @Override
            public int getEditorFontSize() {
                return this.getConsoleFontSize();
            }

            @Override
            public String getEditorFontName() {
                return this.getConsoleFontName();
            }

            @Override
            public float getLineSpacing() {
                return this.getConsoleLineSpacing();
            }

            @Override
            public Font getFont(EditorFontType key) {
                return super.getFont(EditorFontType.getConsoleType((EditorFontType)key));
            }

            @Override
            public void setEditorFontSize(int fontSize) {
                this.setConsoleFontSize(fontSize);
            }
        };
    }

    public static boolean isConsoleViewEditor(@NotNull Editor editor) {
        return editor.getUserData(EDITOR_IS_CONSOLE_VIEW) == Boolean.TRUE;
    }

    public static void printWithHighlighting(@NotNull ConsoleView console, @NotNull String text, @NotNull SyntaxHighlighter highlighter) {
        IElementType tokenType;
        Lexer lexer = highlighter.getHighlightingLexer();
        lexer.start((CharSequence)text, 0, text.length(), 0);
        while ((tokenType = lexer.getTokenType()) != null) {
            console.print(lexer.getTokenText(), ConsoleViewUtil.getContentTypeForToken(tokenType, highlighter));
            lexer.advance();
        }
    }

    @NotNull
    public static ConsoleViewContentType getContentTypeForToken(@NotNull IElementType tokenType, @NotNull SyntaxHighlighter highlighter) {
        TextAttributesKey[] keys = highlighter.getTokenHighlights(tokenType);
        return keys.length == 0 ? ConsoleViewContentType.NORMAL_OUTPUT : ConsoleViewContentType.getConsoleViewType((Key)ColorCache.keys.get(Arrays.asList(keys)));
    }

    public static void printAsFileType(@NotNull ConsoleView console, @NotNull String text, @NotNull FileType fileType) {
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)fileType, null, null);
        if (highlighter != null) {
            ConsoleViewUtil.printWithHighlighting(console, text, highlighter);
        } else {
            console.print(text, ConsoleViewContentType.NORMAL_OUTPUT);
        }
    }

    private static class ColorCache {
        static final Map<Key, List<TextAttributesKey>> textAttributeKeys;
        static final Map<Key, TextAttributes> mergedTextAttributes;
        static final Map<List<TextAttributesKey>, Key> keys;

        private ColorCache() {
        }

        static {
            LafManager.getInstance().addLafManagerListener(new LafManagerListener(){

                public void lookAndFeelChanged(LafManager source) {
                    mergedTextAttributes.clear();
                }
            });
            textAttributeKeys = ContainerUtil.newConcurrentMap();
            mergedTextAttributes = new ConcurrentFactoryMap<Key, TextAttributes>(){

                @Nullable
                protected TextAttributes create(Key contentKey) {
                    EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
                    TextAttributes result = scheme.getAttributes(HighlighterColors.TEXT);
                    for (TextAttributesKey key : textAttributeKeys.get(contentKey)) {
                        TextAttributes attributes = scheme.getAttributes(key);
                        if (attributes == null) continue;
                        result = TextAttributes.merge((TextAttributes)result, (TextAttributes)attributes);
                    }
                    return result;
                }
            };
            keys = new ConcurrentFactoryMap<List<TextAttributesKey>, Key>(){

                protected Key create(List<TextAttributesKey> keys) {
                    StringBuilder keyName = new StringBuilder("ConsoleViewUtil_");
                    for (TextAttributesKey key : keys) {
                        keyName.append("_").append(key.getExternalName());
                    }
                    final Key newKey = new Key(keyName.toString());
                    textAttributeKeys.put(newKey, keys);
                    ConsoleViewContentType contentType = new ConsoleViewContentType(keyName.toString(), HighlighterColors.TEXT){

                        public TextAttributes getAttributes() {
                            return mergedTextAttributes.get(newKey);
                        }
                    };
                    ConsoleViewContentType.registerNewConsoleViewType((Key)newKey, (ConsoleViewContentType)contentType);
                    return newKey;
                }
            };
        }
    }
}

