/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.ConsoleUtil;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TIntArrayList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleBuffer {
    private static final int DEFAULT_CYCLIC_BUFFER_UNIT_SIZE = 256;
    private static final boolean DEBUG_PROCESSING = false;
    private final Deque<StringBuilder> myDeferredOutput = new ArrayDeque<StringBuilder>();
    private final Set<ConsoleViewContentType> myContentTypesToNotStripOnCycling = new HashSet<ConsoleViewContentType>();
    private final int myCyclicBufferSize;
    private final int myCyclicBufferUnitSize;
    private final boolean myUseCyclicBuffer;
    private int myDeferredOutputLength;
    private StringBuffer myDeferredUserInput = new StringBuffer();
    private final List<ConsoleViewImpl.TokenInfo> myDeferredTokens = new ArrayList<ConsoleViewImpl.TokenInfo>();
    private final Set<ConsoleViewContentType> myDeferredTypes = new HashSet<ConsoleViewContentType>();
    private boolean myKeepSlashR = true;

    public ConsoleBuffer() {
        this(ConsoleBuffer.useCycleBuffer(), ConsoleBuffer.getCycleBufferSize(), 256);
    }

    public ConsoleBuffer(boolean useCyclicBuffer, int cyclicBufferSize, int cyclicBufferUnitSize) {
        this.myUseCyclicBuffer = useCyclicBuffer;
        this.myCyclicBufferSize = Math.max(cyclicBufferSize, 0);
        this.myCyclicBufferUnitSize = cyclicBufferUnitSize;
        this.myContentTypesToNotStripOnCycling.add(ConsoleViewContentType.USER_INPUT);
    }

    public static boolean useCycleBuffer() {
        return !"disabled".equalsIgnoreCase(System.getProperty("idea.cycle.buffer.size"));
    }

    public static int getCycleBufferSize() {
        if (UISettings.getInstance().OVERRIDE_CONSOLE_CYCLE_BUFFER_SIZE) {
            return UISettings.getInstance().CONSOLE_CYCLE_BUFFER_SIZE_KB * 1024;
        }
        return ConsoleBuffer.getLegacyCycleBufferSize();
    }

    public static int getLegacyCycleBufferSize() {
        String cycleBufferSizeProperty = System.getProperty("idea.cycle.buffer.size");
        if (cycleBufferSizeProperty == null) {
            return 0x100000;
        }
        try {
            return Integer.parseInt(cycleBufferSizeProperty) * 1024;
        }
        catch (NumberFormatException e) {
            return 0x100000;
        }
    }

    public boolean isUseCyclicBuffer() {
        return this.myUseCyclicBuffer;
    }

    public int getCyclicBufferSize() {
        return this.myCyclicBufferSize;
    }

    void setKeepSlashR(boolean keep) {
        this.myKeepSlashR = keep;
    }

    public boolean isEmpty() {
        return this.myDeferredOutput.isEmpty() || this.myDeferredOutput.size() == 1 && this.myDeferredOutput.getFirst().length() <= 0;
    }

    public int getLength() {
        return this.myDeferredOutputLength;
    }

    public int getUserInputLength() {
        return this.myDeferredUserInput.length();
    }

    public String getUserInput() {
        return this.myDeferredUserInput.toString();
    }

    public List<ConsoleViewImpl.TokenInfo> getDeferredTokens() {
        return this.myDeferredTokens;
    }

    public Set<ConsoleViewContentType> getDeferredTokenTypes() {
        return this.myDeferredTypes;
    }

    public Deque<StringBuilder> getDeferredOutput() {
        return this.myDeferredOutput;
    }

    public String getText() {
        if (this.myDeferredOutput.size() > 1) {
            StringBuilder buffer = new StringBuilder();
            for (StringBuilder builder : this.myDeferredOutput) {
                buffer.append((CharSequence)builder);
            }
            return buffer.toString();
        }
        if (this.myDeferredOutput.size() == 1) {
            return this.myDeferredOutput.getFirst().substring(0);
        }
        return "";
    }

    public void setContentTypesToNotStripOnCycling(@NotNull Collection<ConsoleViewContentType> types) {
        this.myContentTypesToNotStripOnCycling.clear();
        this.myContentTypesToNotStripOnCycling.addAll(types);
    }

    public void clear() {
        this.clear(true);
    }

    public void clear(boolean clearUserInputAsWell) {
        if (this.myUseCyclicBuffer) {
            this.myDeferredOutput.clear();
            this.myDeferredOutput.add(new StringBuilder(this.myCyclicBufferUnitSize));
        } else {
            for (StringBuilder builder : this.myDeferredOutput) {
                builder.setLength(0);
            }
        }
        this.myDeferredOutputLength = 0;
        this.myDeferredTypes.clear();
        this.myDeferredTokens.clear();
        if (clearUserInputAsWell) {
            this.myDeferredUserInput = new StringBuffer();
        }
    }

    @Nullable
    public String cutFirstUserInputLine() {
        String text = this.myDeferredUserInput.substring(0, this.myDeferredUserInput.length());
        int index = Math.max(text.lastIndexOf(10), text.lastIndexOf(13));
        if (index < 0) {
            return null;
        }
        String result = text.substring(0, index + 1);
        this.myDeferredUserInput.setLength(0);
        this.myDeferredUserInput.append(text.substring(index + 1));
        return result;
    }

    public void addUserText(int offset, String text) {
        this.myDeferredUserInput.insert(offset, text);
    }

    public void removeUserText(int startOffset, int endOffset) {
        if (startOffset >= this.myDeferredUserInput.length()) {
            return;
        }
        int startToUse = Math.max(0, startOffset);
        int endToUse = Math.min(this.myDeferredUserInput.length(), endOffset);
        this.myDeferredUserInput.delete(startToUse, endToUse);
    }

    public void replaceUserText(int startOffset, int endOffset, String text) {
        this.myDeferredUserInput.replace(startOffset, endOffset, text);
    }

    @NotNull
    public Pair<String, Integer> print(@NotNull String s, @NotNull ConsoleViewContentType contentType, @Nullable HyperlinkInfo info) {
        StringBuilder bufferToUse;
        int numberOfSymbolsToProceed = s.length();
        int trimmedSymbolsNumber = this.myDeferredOutputLength;
        if (contentType != ConsoleViewContentType.USER_INPUT) {
            numberOfSymbolsToProceed = this.trimDeferredOutputIfNecessary(s.length());
            trimmedSymbolsNumber -= this.myDeferredOutputLength;
        } else {
            trimmedSymbolsNumber = 0;
        }
        if (numberOfSymbolsToProceed <= 0) {
            return new Pair((Object)"", (Object)0);
        }
        if (numberOfSymbolsToProceed < s.length()) {
            s = s.substring(s.length() - numberOfSymbolsToProceed);
        }
        this.myDeferredTypes.add(contentType);
        s = StringUtil.convertLineSeparators((String)s, (boolean)this.myKeepSlashR);
        this.myDeferredOutputLength += s.length();
        if (this.myDeferredOutput.isEmpty()) {
            bufferToUse = new StringBuilder(this.myCyclicBufferUnitSize);
            this.myDeferredOutput.add(bufferToUse);
        } else {
            bufferToUse = this.myDeferredOutput.getLast();
        }
        int offset = 0;
        while (offset < s.length()) {
            if (bufferToUse.length() >= this.myCyclicBufferUnitSize) {
                bufferToUse = new StringBuilder(this.myCyclicBufferUnitSize);
                this.myDeferredOutput.add(bufferToUse);
            }
            if (bufferToUse.length() >= this.myCyclicBufferUnitSize) continue;
            int numberOfSymbolsToAdd = Math.min(this.myCyclicBufferUnitSize - bufferToUse.length(), s.length() - offset);
            bufferToUse.append(s.substring(offset, offset + numberOfSymbolsToAdd));
            offset += numberOfSymbolsToAdd;
        }
        if (contentType == ConsoleViewContentType.USER_INPUT) {
            this.myDeferredUserInput.append(s);
        }
        ConsoleUtil.addToken(s.length(), info, contentType, this.myDeferredTokens);
        return new Pair((Object)s, (Object)trimmedSymbolsNumber);
    }

    private int trimDeferredOutputIfNecessary(int numberOfNewSymbols) {
        int i;
        if (!this.myUseCyclicBuffer || this.myDeferredOutputLength + numberOfNewSymbols <= this.myCyclicBufferSize) {
            return numberOfNewSymbols;
        }
        int numberOfSymbolsToRemove = Math.min(this.myDeferredOutputLength, this.myDeferredOutputLength + numberOfNewSymbols - this.myCyclicBufferSize);
        this.myDeferredTypes.clear();
        Context context = new Context(numberOfSymbolsToRemove);
        TIntArrayList indicesOfTokensToRemove = new TIntArrayList();
        for (i = 0; i < this.myDeferredTokens.size(); ++i) {
            ConsoleViewImpl.TokenInfo tokenInfo = this.myDeferredTokens.get(i);
            tokenInfo.startOffset -= context.removedSymbolsNumber;
            tokenInfo.endOffset -= context.removedSymbolsNumber;
            if (!context.canContinueProcessing()) {
                this.myDeferredTypes.add(tokenInfo.contentType);
                if (context.removedSymbolsNumber != 0) continue;
                break;
            }
            int tokenLength = tokenInfo.getLength();
            if (this.myContentTypesToNotStripOnCycling.contains(tokenInfo.contentType)) {
                ConsoleBuffer.skip(context, tokenLength);
                this.myDeferredTypes.add(tokenInfo.contentType);
                continue;
            }
            int removedTokenSymbolsNumber = this.remove(context, tokenLength);
            if (removedTokenSymbolsNumber == tokenLength) {
                indicesOfTokensToRemove.add(i);
                continue;
            }
            tokenInfo.endOffset -= removedTokenSymbolsNumber;
            this.myDeferredTypes.add(tokenInfo.contentType);
        }
        for (i = indicesOfTokensToRemove.size() - 1; i >= 0; --i) {
            this.myDeferredTokens.remove(indicesOfTokensToRemove.get(i));
        }
        if (!this.myDeferredTokens.isEmpty()) {
            ConsoleViewImpl.TokenInfo tokenInfo = this.myDeferredTokens.get(0);
            if (tokenInfo.startOffset > 0) {
                HyperlinkInfo hyperlinkInfo = tokenInfo.getHyperlinkInfo();
                this.myDeferredTokens.add(0, hyperlinkInfo != null ? new ConsoleViewImpl.HyperlinkTokenInfo(ConsoleViewContentType.USER_INPUT, 0, tokenInfo.startOffset, hyperlinkInfo) : new ConsoleViewImpl.TokenInfo(ConsoleViewContentType.USER_INPUT, 0, tokenInfo.startOffset));
                this.myDeferredTypes.add(ConsoleViewContentType.USER_INPUT);
            }
        }
        if (numberOfNewSymbols + this.myDeferredOutputLength > this.myCyclicBufferSize) {
            int result = this.myCyclicBufferSize - this.myDeferredOutputLength;
            if (result < 0) {
                return 0;
            }
            return result;
        }
        return numberOfNewSymbols;
    }

    private static void skip(@NotNull Context context, int symbolsToSkipNumber) {
        int remainingNumberOfBufferSymbols = context.currentBuffer.length() - context.bufferOffset;
        if (remainingNumberOfBufferSymbols < symbolsToSkipNumber) {
            symbolsToSkipNumber -= remainingNumberOfBufferSymbols;
            while (context.iterator.hasNext()) {
                context.currentBuffer = context.iterator.next();
                context.bufferOffset = 0;
                if (symbolsToSkipNumber <= 0) break;
                if (context.currentBuffer.length() > symbolsToSkipNumber) {
                    context.bufferOffset = symbolsToSkipNumber;
                    symbolsToSkipNumber = 0;
                    break;
                }
                symbolsToSkipNumber -= context.currentBuffer.length();
            }
            assert (symbolsToSkipNumber <= 0);
        } else {
            context.bufferOffset += symbolsToSkipNumber;
        }
    }

    private int remove(@NotNull Context context, int tokenLength) {
        int removedSymbolsNumber = 0;
        int remainingTotalNumberOfSymbolsToRemove = context.numberOfSymbolsToRemove - context.removedSymbolsNumber;
        int numberOfTokenSymbolsToRemove = Math.min(remainingTotalNumberOfSymbolsToRemove, tokenLength);
        while (numberOfTokenSymbolsToRemove > 0 && context.currentBuffer != null) {
            int diff = numberOfTokenSymbolsToRemove - (context.currentBuffer.length() - context.bufferOffset);
            int endDeleteBufferOffset = Math.min(context.bufferOffset + numberOfTokenSymbolsToRemove, context.currentBuffer.length());
            int numberOfSymbolsRemovedFromCurrentBuffer = endDeleteBufferOffset - context.bufferOffset;
            numberOfTokenSymbolsToRemove -= numberOfSymbolsRemovedFromCurrentBuffer;
            removedSymbolsNumber += numberOfSymbolsRemovedFromCurrentBuffer;
            context.removedSymbolsNumber += numberOfSymbolsRemovedFromCurrentBuffer;
            this.myDeferredOutputLength -= numberOfSymbolsRemovedFromCurrentBuffer;
            if (context.bufferOffset == 0 && (diff >= 0 || endDeleteBufferOffset == context.currentBuffer.length())) {
                context.iterator.remove();
                context.nextBuffer();
                continue;
            }
            context.currentBuffer.delete(context.bufferOffset, endDeleteBufferOffset);
            if (context.bufferOffset != context.currentBuffer.length()) continue;
            context.nextBuffer();
        }
        return removedSymbolsNumber;
    }

    private void dumpDeferredOutput() {
    }

    private static void log(Object o) {
    }

    private static void log(String message, Object ... formatData) {
    }

    private final class Context {
        public final int numberOfSymbolsToRemove;
        public StringBuilder currentBuffer;
        public Iterator<StringBuilder> iterator;
        public int bufferOffset;
        public int removedSymbolsNumber;

        Context(int numberOfSymbolsToRemove) {
            this.numberOfSymbolsToRemove = numberOfSymbolsToRemove;
            this.iterator = ConsoleBuffer.this.myDeferredOutput.iterator();
            this.currentBuffer = this.iterator.hasNext() ? this.iterator.next() : null;
        }

        public boolean canContinueProcessing() {
            return this.removedSymbolsNumber < this.numberOfSymbolsToRemove && this.currentBuffer != null;
        }

        public boolean nextBuffer() {
            if (this.iterator.hasNext()) {
                this.currentBuffer = this.iterator.next();
                this.bufferOffset = 0;
                return true;
            }
            return false;
        }
    }
}

