/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.compound;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.compound.CompoundRunConfiguration;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.UnknownConfigurationType;
import com.intellij.execution.impl.RunConfigurationBeforeRunProvider;
import com.intellij.execution.impl.RunConfigurationSelector;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.ide.DataManager;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MultiSelectionListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompoundRunConfigurationSettingsEditor
extends SettingsEditor<CompoundRunConfiguration> {
    private final JBList myList;
    private final RunManagerImpl myRunManager;
    private final SortedListModel<RunConfiguration> myModel;
    private CompoundRunConfiguration mySnapshot;

    public CompoundRunConfigurationSettingsEditor(@NotNull Project project2) {
        this.myRunManager = RunManagerImpl.getInstanceImpl(project2);
        this.myModel = new SortedListModel(CompoundRunConfiguration.COMPARATOR);
        this.myList = new JBList(this.myModel);
        this.myList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                RunConfiguration configuration = (RunConfiguration)CompoundRunConfigurationSettingsEditor.this.myModel.get(index);
                this.setIcon(configuration.getType().getIcon());
                this.append(configuration.getType().getDisplayName() + " '" + configuration.getName() + "'");
            }
        });
        this.myList.setVisibleRowCount(15);
    }

    private boolean canBeAdded(@NotNull RunConfiguration candidate, @NotNull CompoundRunConfiguration root) {
        if (candidate.getType() == root.getType() && candidate.getName().equals(root.getName())) {
            return false;
        }
        List<BeforeRunTask> tasks = this.myRunManager.getBeforeRunTasks(candidate);
        for (BeforeRunTask task : tasks) {
            RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask runTask;
            RunnerAndConfigurationSettings settings;
            if (!(task instanceof RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask) || (settings = (runTask = (RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask)task).getSettings()) == null || this.canBeAdded(settings.getConfiguration(), root)) continue;
            return false;
        }
        if (candidate instanceof CompoundRunConfiguration) {
            Set<RunConfiguration> set = ((CompoundRunConfiguration)candidate).getSetToRun();
            for (RunConfiguration configuration : set) {
                if (this.canBeAdded(configuration, root)) continue;
                return false;
            }
        }
        return true;
    }

    protected void resetEditorFrom(CompoundRunConfiguration compoundRunConfiguration) {
        this.myModel.clear();
        this.myModel.addAll(compoundRunConfiguration.getSetToRun());
        this.mySnapshot = compoundRunConfiguration;
    }

    protected void applyEditorTo(CompoundRunConfiguration s) throws ConfigurationException {
        HashSet<RunConfiguration> checked = new HashSet<RunConfiguration>();
        for (int i = 0; i < this.myModel.getSize(); ++i) {
            RunConfiguration configuration = (RunConfiguration)this.myModel.get(i);
            String message = LangBundle.message("compound.run.configuration.cycle", configuration.getType().getDisplayName(), configuration.getName());
            if (!this.canBeAdded(configuration, s)) {
                throw new ConfigurationException(message);
            }
            checked.add(configuration);
        }
        Set<RunConfiguration> toRun = s.getSetToRun();
        toRun.clear();
        toRun.addAll(checked);
    }

    @NotNull
    protected JComponent createEditor() {
        final ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JList)this.myList);
        return decorator.disableUpDownActions().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ArrayList<RunConfiguration> all = new ArrayList<RunConfiguration>();
                for (ConfigurationType type : CompoundRunConfigurationSettingsEditor.this.myRunManager.getConfigurationFactories()) {
                    if (type instanceof UnknownConfigurationType) continue;
                    for (RunnerAndConfigurationSettings settings : CompoundRunConfigurationSettingsEditor.this.myRunManager.getConfigurationSettingsList(type)) {
                        all.add(settings.getConfiguration());
                    }
                }
                final List configurations = ContainerUtil.filter(all, (Condition)new Condition<RunConfiguration>(){

                    public boolean value(RunConfiguration configuration) {
                        return !CompoundRunConfigurationSettingsEditor.this.mySnapshot.getSetToRun().contains(configuration) && CompoundRunConfigurationSettingsEditor.this.canBeAdded(configuration, CompoundRunConfigurationSettingsEditor.this.mySnapshot);
                    }
                });
                JBPopupFactory.getInstance().createListPopup((ListPopupStep)new MultiSelectionListPopupStep<RunConfiguration>(null, configurations){

                    @Nullable
                    public ListSeparator getSeparatorAbove(RunConfiguration value) {
                        int i = configurations.indexOf(value);
                        if (i < 1) {
                            return null;
                        }
                        RunConfiguration previous = (RunConfiguration)configurations.get(i - 1);
                        return value.getType() != previous.getType() ? new ListSeparator() : null;
                    }

                    public Icon getIconFor(RunConfiguration value) {
                        return value.getType().getIcon();
                    }

                    public boolean isSpeedSearchEnabled() {
                        return true;
                    }

                    @NotNull
                    public String getTextFor(RunConfiguration value) {
                        return value.getName();
                    }

                    @Override
                    public PopupStep<?> onChosen(List<RunConfiguration> selectedValues, boolean finalChoice) {
                        CompoundRunConfigurationSettingsEditor.this.myList.clearSelection();
                        CompoundRunConfigurationSettingsEditor.this.myModel.addAll(selectedValues);
                        return FINAL_CHOICE;
                    }
                }).showUnderneathOf((Component)decorator.getActionsPanel());
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int index = CompoundRunConfigurationSettingsEditor.this.myList.getSelectedIndex();
                if (index == -1) {
                    return;
                }
                RunConfiguration configuration = (RunConfiguration)CompoundRunConfigurationSettingsEditor.this.myModel.get(index);
                RunConfigurationSelector selector = (RunConfigurationSelector)RunConfigurationSelector.KEY.getData(DataManager.getInstance().getDataContext((Component)button.getContextComponent()));
                if (selector != null) {
                    selector.select(configuration);
                }
            }
        }).setToolbarPosition(ActionToolbarPosition.TOP).createPanel();
    }
}

