/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.application;

import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.JavaParametersUtil;
import org.jetbrains.annotations.NotNull;

public abstract class BaseJavaApplicationCommandLineState<T extends RunConfigurationBase>
extends JavaCommandLineState {
    protected final T myConfiguration;

    public BaseJavaApplicationCommandLineState(ExecutionEnvironment environment, @NotNull T configuration) {
        super(environment);
        this.myConfiguration = configuration;
    }

    protected void setupJavaParameters(JavaParameters params) throws ExecutionException {
        JavaParametersUtil.configureConfiguration((SimpleJavaParameters)params, (CommonJavaRunConfigurationParameters)this.myConfiguration);
        for (RunConfigurationExtension ext : (RunConfigurationExtension[])RunConfigurationExtension.EP_NAME.getExtensions()) {
            ext.updateJavaParameters(this.getConfiguration(), params, this.getRunnerSettings());
        }
    }

    @NotNull
    protected OSProcessHandler startProcess() throws ExecutionException {
        KillableColoredProcessHandler handler2 = new KillableColoredProcessHandler(this.createCommandLine());
        ProcessTerminatedListener.attach((ProcessHandler)handler2);
        JavaRunConfigurationExtensionManager.getInstance().attachExtensionsToProcess((RunConfigurationBase)this.getConfiguration(), (ProcessHandler)handler2, this.getRunnerSettings());
        return handler2;
    }

    protected T getConfiguration() {
        return this.myConfiguration;
    }
}

