/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.BaseRunConfigurationAction;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunDialog;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.actionSystem.Presentation;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CreateAction
extends BaseRunConfigurationAction {
    private static final BaseCreatePolicy CREATE_AND_EDIT = new CreateAndEditPolicy();
    private static final BaseCreatePolicy SELECT = new SelectPolicy();
    private static final BaseCreatePolicy SAVE = new SavePolicy();
    private static final BaseCreatePolicy SELECTED_STABLE = new BaseCreatePolicy(BaseCreatePolicy.ActionType.SELECT){

        @Override
        public void perform(ConfigurationContext context) {
        }

        @Override
        public void update(Presentation presentation, ConfigurationContext context, @NotNull String actionText) {
            super.update(presentation, context, actionText);
            presentation.setVisible(false);
        }
    };

    public CreateAction() {
        super(ExecutionBundle.message((String)"create.run.configuration.action.name", (Object[])new Object[0]), null, null);
    }

    @Override
    protected void perform(ConfigurationContext context) {
        CreateAction.choosePolicy(context).perform(context);
    }

    @Override
    protected void updatePresentation(Presentation presentation, @NotNull String actionText, ConfigurationContext context) {
        CreateAction.choosePolicy(context).update(presentation, context, actionText);
    }

    private static BaseCreatePolicy choosePolicy(ConfigurationContext context) {
        RunnerAndConfigurationSettings configuration = context.findExisting();
        if (configuration == null) {
            return CREATE_AND_EDIT;
        }
        RunManager runManager = context.getRunManager();
        if (runManager.getSelectedConfiguration() != configuration) {
            return SELECT;
        }
        if (configuration.isTemporary()) {
            return SAVE;
        }
        return SELECTED_STABLE;
    }

    private static class SavePolicy
    extends BaseCreatePolicy {
        public SavePolicy() {
            super(BaseCreatePolicy.ActionType.SAVE);
        }

        @Override
        public void perform(ConfigurationContext context) {
            RunnerAndConfigurationSettings settings = context.findExisting();
            if (settings != null) {
                context.getRunManager().makeStable(settings);
            }
        }

        @Override
        protected void updateIcon(Presentation presentation, ConfigurationContext context) {
            RunnerAndConfigurationSettings configuration = context.findExisting();
            if (configuration != null) {
                presentation.setIcon(configuration.getType().getIcon());
            } else {
                super.updateIcon(presentation, context);
            }
        }
    }

    private static class CreateAndEditPolicy
    extends CreatePolicy {
        private CreateAndEditPolicy() {
        }

        @Override
        protected void updateText(Presentation presentation, String actionText) {
            presentation.setText(actionText.length() > 0 ? ExecutionBundle.message((String)"create.run.configuration.for.item.action.name", (Object[])new Object[]{actionText}) + "..." : ExecutionBundle.message((String)"create.run.configuration.action.name", (Object[])new Object[0]), false);
        }

        @Override
        public void perform(ConfigurationContext context) {
            RunnerAndConfigurationSettings configuration = context.getConfiguration();
            if (RunDialog.editConfiguration(context.getProject(), configuration, ExecutionBundle.message((String)"create.run.configuration.for.item.dialog.title", (Object[])new Object[]{configuration.getName()}))) {
                RunManagerImpl runManager = (RunManagerImpl)context.getRunManager();
                runManager.addConfiguration(configuration, runManager.isConfigurationShared(configuration), runManager.getBeforeRunTasks(configuration.getConfiguration()), false);
                runManager.setSelectedConfiguration(configuration);
            }
        }
    }

    private static class CreatePolicy
    extends BaseCreatePolicy {
        public CreatePolicy() {
            super(BaseCreatePolicy.ActionType.CREATE);
        }

        @Override
        public void perform(ConfigurationContext context) {
            RunManagerImpl runManager = (RunManagerImpl)context.getRunManager();
            RunnerAndConfigurationSettings configuration = context.getConfiguration();
            RunnerAndConfigurationSettings template = runManager.getConfigurationTemplate(configuration.getFactory());
            RunConfiguration templateConfiguration = template.getConfiguration();
            runManager.addConfiguration(configuration, runManager.isConfigurationShared(template), runManager.getBeforeRunTasks(templateConfiguration), false);
            runManager.setSelectedConfiguration(configuration);
        }
    }

    private static class SelectPolicy
    extends BaseCreatePolicy {
        public SelectPolicy() {
            super(BaseCreatePolicy.ActionType.SELECT);
        }

        @Override
        public void perform(ConfigurationContext context) {
            RunnerAndConfigurationSettings configuration = context.findExisting();
            if (configuration == null) {
                return;
            }
            context.getRunManager().setSelectedConfiguration(configuration);
        }

        @Override
        protected void updateIcon(Presentation presentation, ConfigurationContext context) {
            RunnerAndConfigurationSettings configuration = context.findExisting();
            if (configuration != null) {
                presentation.setIcon(configuration.getType().getIcon());
            } else {
                super.updateIcon(presentation, context);
            }
        }
    }

    private static abstract class BaseCreatePolicy {
        private final ActionType myType;

        public BaseCreatePolicy(ActionType type) {
            this.myType = type;
        }

        public void update(Presentation presentation, ConfigurationContext context, @NotNull String actionText) {
            this.updateText(presentation, actionText);
            this.updateIcon(presentation, context);
        }

        protected void updateIcon(Presentation presentation, ConfigurationContext context) {
            List fromContext = context.getConfigurationsFromContext();
            if (fromContext != null && fromContext.size() == 1) {
                presentation.setIcon(((ConfigurationFromContext)fromContext.iterator().next()).getConfiguration().getFactory().getIcon());
            }
        }

        protected void updateText(Presentation presentation, String actionText) {
            presentation.setText(this.generateName(actionText), false);
        }

        private String generateName(String actionText) {
            switch (this.myType) {
                case CREATE: {
                    return ExecutionBundle.message((String)"create.run.configuration.for.item.action.name", (Object[])new Object[]{actionText});
                }
                case SELECT: {
                    return ExecutionBundle.message((String)"select.run.configuration.for.item.action.name", (Object[])new Object[]{actionText});
                }
            }
            return ExecutionBundle.message((String)"save.run.configuration.for.item.action.name", (Object[])new Object[]{actionText});
        }

        public abstract void perform(ConfigurationContext var1);

        public static enum ActionType {
            CREATE,
            SAVE,
            SELECT;

        }
    }
}

