/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.Location;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.ExecutorProvider;
import com.intellij.execution.actions.PreferredProducerFind;
import com.intellij.execution.actions.RunConfigurationsComboBoxAction;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.UnknownConfigurationType;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.execution.impl.RunDialog;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseRunConfigurationPopup
implements ExecutorProvider {
    private final Project myProject;
    @NotNull
    private final String myAddKey;
    @NotNull
    private final Executor myDefaultExecutor;
    @Nullable
    private final Executor myAlternativeExecutor;
    private Executor myCurrentExecutor;
    private boolean myEditConfiguration;
    private final RunListPopup myPopup;

    public ChooseRunConfigurationPopup(@NotNull Project project2, @NotNull String addKey, @NotNull Executor defaultExecutor, @Nullable Executor alternativeExecutor) {
        this.myProject = project2;
        this.myAddKey = addKey;
        this.myDefaultExecutor = defaultExecutor;
        this.myAlternativeExecutor = alternativeExecutor;
        this.myPopup = new RunListPopup((ListPopupStep)new ConfigurationListPopupStep(this, this.myProject, this, this.myDefaultExecutor.getActionName()));
    }

    public void show() {
        String adText = this.getAdText(this.myAlternativeExecutor);
        if (adText != null) {
            this.myPopup.setAdText(adText);
        }
        this.myPopup.showCenteredInCurrentWindow(this.myProject);
    }

    protected static boolean canRun(@NotNull Executor executor, RunnerAndConfigurationSettings settings) {
        return ProgramRunnerUtil.getRunner(executor.getId(), settings) != null;
    }

    @Nullable
    protected String getAdText(Executor alternateExecutor) {
        PropertiesComponent properties = PropertiesComponent.getInstance();
        if (alternateExecutor != null && !properties.isTrueValue(this.myAddKey)) {
            return String.format("Hold %s to %s", KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke("SHIFT")), alternateExecutor.getActionName());
        }
        if (!properties.isTrueValue("run.configuration.edit.ad")) {
            return String.format("Press %s to Edit", KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke("F4")));
        }
        if (!properties.isTrueValue("run.configuration.delete.ad")) {
            return String.format("Press %s to Delete configuration", KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke("DELETE")));
        }
        return null;
    }

    private void registerActions(final RunListPopup popup) {
        popup.registerAction("alternateExecutor", KeyStroke.getKeyStroke("shift pressed SHIFT"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseRunConfigurationPopup.this.myCurrentExecutor = ChooseRunConfigurationPopup.this.myAlternativeExecutor;
                ChooseRunConfigurationPopup.this.updatePresentation();
            }
        });
        popup.registerAction("restoreDefaultExecutor", KeyStroke.getKeyStroke("released SHIFT"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseRunConfigurationPopup.this.myCurrentExecutor = ChooseRunConfigurationPopup.this.myDefaultExecutor;
                ChooseRunConfigurationPopup.this.updatePresentation();
            }
        });
        popup.registerAction("invokeAction", KeyStroke.getKeyStroke("shift ENTER"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                popup.handleSelect(true);
            }
        });
        popup.registerAction("editConfiguration", KeyStroke.getKeyStroke("F4"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseRunConfigurationPopup.this.myEditConfiguration = true;
                popup.handleSelect(true);
            }
        });
        popup.registerAction("deleteConfiguration", KeyStroke.getKeyStroke("DELETE"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                popup.removeSelected();
            }
        });
        popup.registerAction("deleteConfiguration_bksp", KeyStroke.getKeyStroke("BACK_SPACE"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpeedSearch speedSearch = popup.getSpeedSearch();
                if (speedSearch.isHoldingFilter()) {
                    speedSearch.backspace();
                    speedSearch.update();
                } else {
                    popup.removeSelected();
                }
            }
        });
        Action action0 = ChooseRunConfigurationPopup.createNumberAction(0, popup, this.myDefaultExecutor);
        Action action0_ = ChooseRunConfigurationPopup.createNumberAction(0, popup, this.myAlternativeExecutor);
        popup.registerAction("0Action", KeyStroke.getKeyStroke("0"), action0);
        popup.registerAction("0Action_", KeyStroke.getKeyStroke("shift pressed 0"), action0_);
        popup.registerAction("0Action1", KeyStroke.getKeyStroke("NUMPAD0"), action0);
        popup.registerAction("0Action_1", KeyStroke.getKeyStroke("shift pressed NUMPAD0"), action0_);
        Action action1 = ChooseRunConfigurationPopup.createNumberAction(1, popup, this.myDefaultExecutor);
        Action action1_ = ChooseRunConfigurationPopup.createNumberAction(1, popup, this.myAlternativeExecutor);
        popup.registerAction("1Action", KeyStroke.getKeyStroke("1"), action1);
        popup.registerAction("1Action_", KeyStroke.getKeyStroke("shift pressed 1"), action1_);
        popup.registerAction("1Action1", KeyStroke.getKeyStroke("NUMPAD1"), action1);
        popup.registerAction("1Action_1", KeyStroke.getKeyStroke("shift pressed NUMPAD1"), action1_);
        Action action2 = ChooseRunConfigurationPopup.createNumberAction(2, popup, this.myDefaultExecutor);
        Action action2_ = ChooseRunConfigurationPopup.createNumberAction(2, popup, this.myAlternativeExecutor);
        popup.registerAction("2Action", KeyStroke.getKeyStroke("2"), action2);
        popup.registerAction("2Action_", KeyStroke.getKeyStroke("shift pressed 2"), action2_);
        popup.registerAction("2Action1", KeyStroke.getKeyStroke("NUMPAD2"), action2);
        popup.registerAction("2Action_1", KeyStroke.getKeyStroke("shift pressed NUMPAD2"), action2_);
        Action action3 = ChooseRunConfigurationPopup.createNumberAction(3, popup, this.myDefaultExecutor);
        Action action3_ = ChooseRunConfigurationPopup.createNumberAction(3, popup, this.myAlternativeExecutor);
        popup.registerAction("3Action", KeyStroke.getKeyStroke("3"), action3);
        popup.registerAction("3Action_", KeyStroke.getKeyStroke("shift pressed 3"), action3_);
        popup.registerAction("3Action1", KeyStroke.getKeyStroke("NUMPAD3"), action3);
        popup.registerAction("3Action_1", KeyStroke.getKeyStroke("shift pressed NUMPAD3"), action3_);
    }

    private void updatePresentation() {
        this.myPopup.setCaption(this.getExecutor().getActionName());
    }

    static void execute(final ItemWrapper itemWrapper, final Executor executor) {
        if (executor == null) {
            return;
        }
        final DataContext dataContext = DataManager.getInstance().getDataContext();
        final Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    itemWrapper.perform(project2, executor, dataContext);
                }
            });
        }
    }

    void editConfiguration(@NotNull Project project2, @NotNull RunnerAndConfigurationSettings configuration) {
        Executor executor = this.getExecutor();
        PropertiesComponent.getInstance().setValue("run.configuration.edit.ad", Boolean.toString(true));
        if (RunDialog.editConfiguration(project2, configuration, "Edit configuration settings", executor)) {
            RunManagerEx.getInstanceEx(project2).setSelectedConfiguration(configuration);
            ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)configuration, (Executor)executor);
        }
    }

    private static void deleteConfiguration(Project project2, @NotNull RunnerAndConfigurationSettings configurationSettings) {
        RunManagerEx manager = RunManagerEx.getInstanceEx(project2);
        manager.removeConfiguration(configurationSettings);
    }

    @Override
    @NotNull
    public Executor getExecutor() {
        return this.myCurrentExecutor == null ? this.myDefaultExecutor : this.myCurrentExecutor;
    }

    private static Action createNumberAction(int number, ListPopupImpl listPopup, Executor executor) {
        return new MyAbstractAction(listPopup, number, executor);
    }

    public static ItemWrapper[] createSettingsList(@NotNull Project project2, @NotNull ExecutorProvider executorProvider, boolean createEditAction) {
        RunManagerEx manager;
        RunnerAndConfigurationSettings selectedConfiguration;
        ArrayList<ItemWrapper> result = new ArrayList<ItemWrapper>();
        if (createEditAction) {
            ItemWrapper<Void> edit = new ItemWrapper<Void>(null){

                @Override
                public Icon getIcon() {
                    return AllIcons.Actions.EditSource;
                }

                @Override
                public String getText() {
                    return UIUtil.removeMnemonic((String)ActionsBundle.message((String)"action.editRunConfigurations.text", (Object[])new Object[0]));
                }

                @Override
                public void perform(final @NotNull Project project2, final @NotNull Executor executor, @NotNull DataContext context) {
                    if (new EditConfigurationsDialog(project2){

                        protected void init() {
                            this.setOKButtonText(executor.getStartActionText());
                            this.setOKButtonIcon(executor.getIcon());
                            this.myExecutor = executor;
                            super.init();
                        }
                    }.showAndGet()) {
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                RunnerAndConfigurationSettings configuration = RunManager.getInstance((Project)project2).getSelectedConfiguration();
                                if (configuration != null) {
                                    ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)configuration, (Executor)executor);
                                }
                            }
                        }, project2.getDisposed());
                    }
                }

                @Override
                public boolean available(Executor executor) {
                    return true;
                }
            };
            edit.setMnemonic(0);
            result.add(edit);
        }
        if ((selectedConfiguration = (manager = RunManagerEx.getInstanceEx(project2)).getSelectedConfiguration()) != null) {
            boolean isFirst = true;
            final ExecutionTarget activeTarget = ExecutionTargetManager.getActiveTarget((Project)project2);
            for (ExecutionTarget eachTarget : ExecutionTargetManager.getTargetsToChooseFor((Project)project2, (RunnerAndConfigurationSettings)selectedConfiguration)) {
                result.add(new ItemWrapper<ExecutionTarget>(eachTarget, isFirst){
                    {
                        super(value, addSeparatorAbove);
                        this.setChecked(((ExecutionTarget)this.getValue()).equals((Object)activeTarget));
                    }

                    @Override
                    public Icon getIcon() {
                        return ((ExecutionTarget)this.getValue()).getIcon();
                    }

                    @Override
                    public String getText() {
                        return ((ExecutionTarget)this.getValue()).getDisplayName();
                    }

                    @Override
                    public void perform(@NotNull Project project2, @NotNull Executor executor, @NotNull DataContext context) {
                        ExecutionTargetManager.setActiveTarget((Project)project2, (ExecutionTarget)((ExecutionTarget)this.getValue()));
                        ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)selectedConfiguration, (Executor)executor);
                    }

                    @Override
                    public boolean available(Executor executor) {
                        return true;
                    }
                });
                isFirst = false;
            }
        }
        LinkedHashMap<RunnerAndConfigurationSettings, ItemWrapper> wrappedExisting = new LinkedHashMap<RunnerAndConfigurationSettings, ItemWrapper>();
        for (ConfigurationType type : manager.getConfigurationFactories()) {
            if (type instanceof UnknownConfigurationType) continue;
            Map<String, List<RunnerAndConfigurationSettings>> structure = manager.getStructure(type);
            for (Map.Entry<String, List<RunnerAndConfigurationSettings>> entry : structure.entrySet()) {
                if (entry.getValue().isEmpty()) continue;
                String key = entry.getKey();
                if (key != null) {
                    boolean isSelected = entry.getValue().contains(selectedConfiguration);
                    if (isSelected) assert (selectedConfiguration != null);
                    FolderWrapper folderWrapper = new FolderWrapper(project2, executorProvider, key + (isSelected ? "  (mnemonic is to \"" + selectedConfiguration.getName() + "\")" : ""), entry.getValue());
                    if (isSelected) {
                        folderWrapper.setMnemonic(1);
                    }
                    result.add(folderWrapper);
                    continue;
                }
                for (RunnerAndConfigurationSettings configuration : entry.getValue()) {
                    ItemWrapper wrapped = ItemWrapper.wrap(project2, configuration);
                    if (configuration == selectedConfiguration) {
                        wrapped.setMnemonic(1);
                    }
                    wrappedExisting.put(configuration, wrapped);
                }
            }
        }
        if (!DumbService.isDumb((Project)project2)) {
            ChooseRunConfigurationPopup.populateWithDynamicRunners(result, wrappedExisting, project2, manager, selectedConfiguration);
        }
        result.addAll(wrappedExisting.values());
        return result.toArray(new ItemWrapper[result.size()]);
    }

    @NotNull
    private static List<RunnerAndConfigurationSettings> populateWithDynamicRunners(List<ItemWrapper> result, Map<RunnerAndConfigurationSettings, ItemWrapper> existing, final Project project2, final RunManagerEx manager, RunnerAndConfigurationSettings selectedConfiguration) {
        ArrayList<RunnerAndConfigurationSettings> contextConfigurations = new ArrayList<RunnerAndConfigurationSettings>();
        if (!EventQueue.isDispatchThread()) {
            return Collections.emptyList();
        }
        DataContext dataContext = DataManager.getInstance().getDataContext();
        ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)dataContext);
        List producers = PreferredProducerFind.getConfigurationsFromContext((Location)context.getLocation(), (ConfigurationContext)context, (boolean)false);
        if (producers == null) {
            return Collections.emptyList();
        }
        Collections.sort(producers, ConfigurationFromContext.NAME_COMPARATOR);
        RunnerAndConfigurationSettings[] preferred = new RunnerAndConfigurationSettings[]{null};
        int i = 2;
        for (ConfigurationFromContext fromContext : producers) {
            ItemWrapper wrapper;
            final RunnerAndConfigurationSettings configuration = fromContext.getConfigurationSettings();
            if (existing.keySet().contains(configuration)) {
                wrapper = existing.get(configuration);
                if (wrapper.getMnemonic() == 1) continue;
                wrapper.setMnemonic(i);
                ++i;
                continue;
            }
            if (selectedConfiguration != null && configuration.equals(selectedConfiguration)) continue;
            contextConfigurations.add(configuration);
            if (preferred[0] == null) {
                preferred[0] = configuration;
            }
            wrapper = new ItemWrapper(configuration){

                @Override
                public Icon getIcon() {
                    return RunManagerEx.getInstanceEx(project2).getConfigurationIcon(configuration);
                }

                @Override
                public String getText() {
                    return configuration.getName();
                }

                @Override
                public boolean available(Executor executor) {
                    return ChooseRunConfigurationPopup.canRun(executor, configuration);
                }

                @Override
                public void perform(@NotNull Project project22, @NotNull Executor executor, @NotNull DataContext context) {
                    manager.setTemporaryConfiguration(configuration);
                    RunManagerEx.getInstanceEx(project22).setSelectedConfiguration(configuration);
                    ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)configuration, (Executor)executor);
                }

                @Override
                public PopupStep getNextStep(@NotNull Project project22, @NotNull ChooseRunConfigurationPopup action) {
                    return new ConfigurationActionsStep(project22, action, configuration, this.isDynamic());
                }

                @Override
                public boolean hasActions() {
                    return true;
                }
            };
            wrapper.setDynamic(true);
            wrapper.setMnemonic(i);
            result.add(wrapper);
            ++i;
        }
        return contextConfigurations;
    }

    private static final class FolderStep
    extends BaseListPopupStep<ConfigurationActionsStep> {
        private final Project myProject;
        private final ChooseRunConfigurationPopup myPopup;
        private final ExecutorProvider myExecutorProvider;

        private FolderStep(Project project2, ExecutorProvider executorProvider, String folderName, List<ConfigurationActionsStep> children2, ChooseRunConfigurationPopup popup) {
            super(folderName, children2, new ArrayList());
            this.myProject = project2;
            this.myExecutorProvider = executorProvider;
            this.myPopup = popup;
        }

        public PopupStep onChosen(final ConfigurationActionsStep selectedValue, boolean finalChoice) {
            if (finalChoice) {
                if (this.myPopup.myEditConfiguration) {
                    final RunnerAndConfigurationSettings settings = selectedValue.getSettings();
                    return this.doFinalStep(new Runnable(){

                        @Override
                        public void run() {
                            myPopup.editConfiguration(myProject, settings);
                        }
                    });
                }
                return this.doFinalStep(new Runnable(){

                    @Override
                    public void run() {
                        RunnerAndConfigurationSettings settings = selectedValue.getSettings();
                        RunManagerEx.getInstanceEx(myProject).setSelectedConfiguration(settings);
                        ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)settings, (Executor)myExecutorProvider.getExecutor());
                    }
                });
            }
            return selectedValue;
        }

        public Icon getIconFor(ConfigurationActionsStep aValue) {
            return aValue.getIcon();
        }

        @NotNull
        public String getTextFor(ConfigurationActionsStep value) {
            return value.getName();
        }

        public boolean hasSubstep(ConfigurationActionsStep selectedValue) {
            return !selectedValue.getValues().isEmpty();
        }
    }

    private static class FolderWrapper
    extends ItemWrapper<String> {
        private final Project myProject;
        private final ExecutorProvider myExecutorProvider;
        private final List<RunnerAndConfigurationSettings> myConfigurations;

        private FolderWrapper(Project project2, ExecutorProvider executorProvider, @Nullable String value, List<RunnerAndConfigurationSettings> configurations) {
            super(value);
            this.myProject = project2;
            this.myExecutorProvider = executorProvider;
            this.myConfigurations = configurations;
        }

        @Override
        public void perform(@NotNull Project project2, @NotNull Executor executor, @NotNull DataContext context) {
            RunnerAndConfigurationSettings selectedConfiguration = RunManagerEx.getInstanceEx(project2).getSelectedConfiguration();
            if (this.myConfigurations.contains(selectedConfiguration)) {
                RunManagerEx.getInstanceEx(project2).setSelectedConfiguration(selectedConfiguration);
                ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)selectedConfiguration, (Executor)this.myExecutorProvider.getExecutor());
            }
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return AllIcons.Nodes.Folder;
        }

        @Override
        public String getText() {
            return (String)this.getValue();
        }

        @Override
        public boolean hasActions() {
            return true;
        }

        @Override
        public PopupStep getNextStep(Project project2, ChooseRunConfigurationPopup action) {
            ArrayList<ConfigurationActionsStep> steps = new ArrayList<ConfigurationActionsStep>();
            for (RunnerAndConfigurationSettings settings : this.myConfigurations) {
                steps.add(new ConfigurationActionsStep(project2, action, settings, false));
            }
            return new FolderStep(this.myProject, this.myExecutorProvider, null, steps, action);
        }
    }

    private class RunListPopup
    extends ListPopupImpl {
        public RunListPopup(ListPopupStep step) {
            super(step);
            ChooseRunConfigurationPopup.this.registerActions(this);
        }

        protected RunListPopup(WizardPopup aParent, ListPopupStep aStep, Object parentValue) {
            super(aParent, aStep, parentValue);
            ChooseRunConfigurationPopup.this.registerActions(this);
        }

        @Override
        protected WizardPopup createPopup(WizardPopup parent, PopupStep step, Object parentValue) {
            return new RunListPopup(parent, (ListPopupStep)step, parentValue);
        }

        @Override
        public void handleSelect(boolean handleFinalChoices, InputEvent e) {
            if (e instanceof MouseEvent && e.isShiftDown()) {
                this.handleShiftClick(handleFinalChoices, e, this);
                return;
            }
            this._handleSelect(handleFinalChoices, e);
        }

        private void _handleSelect(boolean handleFinalChoices, InputEvent e) {
            super.handleSelect(handleFinalChoices, e);
        }

        protected void handleShiftClick(boolean handleFinalChoices, InputEvent inputEvent, RunListPopup popup) {
            ChooseRunConfigurationPopup.this.myCurrentExecutor = ChooseRunConfigurationPopup.this.myAlternativeExecutor;
            popup._handleSelect(handleFinalChoices, inputEvent);
        }

        @Override
        protected ListCellRenderer getListElementRenderer() {
            boolean hasSideBar = false;
            for (Object each : this.getListStep().getValues()) {
                if (!(each instanceof Wrapper) || ((Wrapper)each).getMnemonic() == -1) continue;
                hasSideBar = true;
                break;
            }
            return new RunListElementRenderer(this, hasSideBar);
        }

        public void removeSelected() {
            int index;
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
            if (!propertiesComponent.isTrueValue("run.configuration.delete.ad")) {
                propertiesComponent.setValue("run.configuration.delete.ad", Boolean.toString(true));
            }
            if ((index = this.getSelectedIndex()) == -1) {
                return;
            }
            Object o = this.getListModel().get(index);
            if (o != null && o instanceof ItemWrapper && ((ItemWrapper)o).canBeDeleted()) {
                ChooseRunConfigurationPopup.deleteConfiguration(ChooseRunConfigurationPopup.this.myProject, (RunnerAndConfigurationSettings)((ItemWrapper)o).getValue());
                this.getListModel().deleteItem(o);
                List values = this.getListStep().getValues();
                values.remove(o);
                if (index < values.size()) {
                    this.onChildSelectedFor(values.get(index));
                } else if (index - 1 >= 0) {
                    this.onChildSelectedFor(values.get(index - 1));
                }
            }
        }
    }

    private static class MyAbstractAction
    extends AbstractAction
    implements DumbAware {
        private final ListPopupImpl myListPopup;
        private final int myNumber;
        private final Executor myExecutor;

        public MyAbstractAction(ListPopupImpl listPopup, int number, Executor executor) {
            this.myListPopup = listPopup;
            this.myNumber = number;
            this.myExecutor = executor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.myListPopup.getSpeedSearch().isHoldingFilter()) {
                return;
            }
            for (final Object item : this.myListPopup.getListStep().getValues()) {
                if (!(item instanceof ItemWrapper) || ((ItemWrapper)item).getMnemonic() != this.myNumber) continue;
                this.myListPopup.setFinalRunnable(new Runnable(){

                    @Override
                    public void run() {
                        ChooseRunConfigurationPopup.execute((ItemWrapper)item, myExecutor);
                    }
                });
                this.myListPopup.closeOk(null);
            }
        }
    }

    private static class RunListElementRenderer
    extends PopupListElementRenderer {
        private JLabel myLabel;
        private final ListPopupImpl myPopup1;
        private final boolean myHasSideBar;

        private RunListElementRenderer(ListPopupImpl popup, boolean hasSideBar) {
            super(popup);
            this.myPopup1 = popup;
            this.myHasSideBar = hasSideBar;
        }

        @Override
        protected JComponent createItemComponent() {
            if (this.myLabel == null) {
                this.myLabel = new JLabel();
                this.myLabel.setPreferredSize(new JLabel("8.").getPreferredSize());
            }
            JComponent result = super.createItemComponent();
            result.add((Component)this.myLabel, "West");
            return result;
        }

        @Override
        protected void customizeComponent(JList list, Object value, boolean isSelected) {
            super.customizeComponent(list, value, isSelected);
            this.myLabel.setVisible(this.myHasSideBar);
            ListPopupStep<Object> step = this.myPopup1.getListStep();
            boolean isSelectable = step.isSelectable(value);
            this.myLabel.setEnabled(isSelectable);
            this.myLabel.setIcon(null);
            if (isSelected) {
                this.setSelected(this.myLabel);
            } else {
                this.setDeselected(this.myLabel);
            }
            if (value instanceof Wrapper) {
                Wrapper wrapper = (Wrapper)value;
                int mnemonic = wrapper.getMnemonic();
                if (mnemonic != -1 && !this.myPopup1.getSpeedSearch().isHoldingFilter()) {
                    this.myLabel.setText(mnemonic + ".");
                    this.myLabel.setDisplayedMnemonicIndex(0);
                } else {
                    if (wrapper.isChecked()) {
                        this.myTextLabel.setIcon(isSelected ? RunConfigurationsComboBoxAction.CHECKED_SELECTED_ICON : RunConfigurationsComboBoxAction.CHECKED_ICON);
                    } else if (this.myTextLabel.getIcon() == null) {
                        this.myTextLabel.setIcon(RunConfigurationsComboBoxAction.EMPTY_ICON);
                    }
                    this.myLabel.setText("");
                }
            }
        }
    }

    private static abstract class ActionWrapper
    extends Wrapper {
        private final String myName;
        private final Icon myIcon;

        private ActionWrapper(String name, Icon icon) {
            this(name, icon, false);
        }

        private ActionWrapper(String name, Icon icon, boolean addSeparatorAbove) {
            super(addSeparatorAbove);
            this.myName = name;
            this.myIcon = icon;
        }

        public abstract void perform();

        @Override
        public String getText() {
            return this.myName;
        }

        @Override
        public Icon getIcon() {
            return this.myIcon;
        }
    }

    private static final class ConfigurationActionsStep
    extends BaseListPopupStep<ActionWrapper> {
        @NotNull
        private final RunnerAndConfigurationSettings mySettings;
        @NotNull
        private final Project myProject;

        private ConfigurationActionsStep(@NotNull Project project2, ChooseRunConfigurationPopup action, @NotNull RunnerAndConfigurationSettings settings, boolean dynamic) {
            super(null, (Object[])ConfigurationActionsStep.buildActions(project2, action, settings, dynamic));
            this.myProject = project2;
            this.mySettings = settings;
        }

        @NotNull
        public RunnerAndConfigurationSettings getSettings() {
            return this.mySettings;
        }

        public String getName() {
            return this.mySettings.getName();
        }

        public Icon getIcon() {
            return RunManagerEx.getInstanceEx(this.myProject).getConfigurationIcon(this.mySettings);
        }

        public ListSeparator getSeparatorAbove(ActionWrapper value) {
            return value.addSeparatorAbove() ? new ListSeparator() : null;
        }

        private static ActionWrapper[] buildActions(final @NotNull Project project2, final ChooseRunConfigurationPopup action, final @NotNull RunnerAndConfigurationSettings settings, final boolean dynamic) {
            ArrayList<ActionWrapper> result = new ArrayList<ActionWrapper>();
            final ExecutionTarget active = ExecutionTargetManager.getActiveTarget((Project)project2);
            for (final ExecutionTarget eachTarget : ExecutionTargetManager.getTargetsToChooseFor((Project)project2, (RunnerAndConfigurationSettings)settings)) {
                result.add(new ActionWrapper(eachTarget.getDisplayName(), eachTarget.getIcon()){
                    {
                        super(name, icon);
                        this.setChecked(eachTarget.equals((Object)active));
                    }

                    @Override
                    public void perform() {
                        RunManagerEx manager = RunManagerEx.getInstanceEx(project2);
                        if (dynamic) {
                            manager.setTemporaryConfiguration(settings);
                        }
                        manager.setSelectedConfiguration(settings);
                        ExecutionTargetManager.setActiveTarget((Project)project2, (ExecutionTarget)eachTarget);
                        ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)settings, (Executor)action.getExecutor());
                    }
                });
            }
            boolean isFirst = true;
            for (final Executor executor : ExecutorRegistry.getInstance().getRegisteredExecutors()) {
                ProgramRunner runner = RunnerRegistry.getInstance().getRunner(executor.getId(), (RunProfile)settings.getConfiguration());
                if (runner == null) continue;
                result.add(new ActionWrapper(executor.getActionName(), executor.getIcon(), isFirst){

                    @Override
                    public void perform() {
                        RunManagerEx manager = RunManagerEx.getInstanceEx(project2);
                        if (dynamic) {
                            manager.setTemporaryConfiguration(settings);
                        }
                        manager.setSelectedConfiguration(settings);
                        ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)settings, (Executor)executor);
                    }
                });
                isFirst = false;
            }
            result.add(new ActionWrapper("Edit...", AllIcons.Actions.EditSource, true){

                @Override
                public void perform() {
                    RunManagerEx manager = RunManagerEx.getInstanceEx(project2);
                    if (dynamic) {
                        manager.setTemporaryConfiguration(settings);
                    }
                    action.editConfiguration(project2, settings);
                }
            });
            if (settings.isTemporary() || dynamic) {
                result.add(new ActionWrapper("Save configuration", AllIcons.Actions.Menu_saveall){

                    @Override
                    public void perform() {
                        RunManagerEx manager = RunManagerEx.getInstanceEx(project2);
                        if (dynamic) {
                            manager.setTemporaryConfiguration(settings);
                        }
                        manager.makeStable(settings);
                    }
                });
            }
            return result.toArray(new ActionWrapper[result.size()]);
        }

        public PopupStep onChosen(final ActionWrapper selectedValue, boolean finalChoice) {
            return this.doFinalStep(new Runnable(){

                @Override
                public void run() {
                    selectedValue.perform();
                }
            });
        }

        public Icon getIconFor(ActionWrapper aValue) {
            return aValue.getIcon();
        }

        @NotNull
        public String getTextFor(ActionWrapper value) {
            return value.getText();
        }
    }

    private static final class ConfigurationListPopupStep
    extends BaseListPopupStep<ItemWrapper> {
        private final Project myProject;
        private final ChooseRunConfigurationPopup myAction;
        private int myDefaultConfiguration = -1;

        private ConfigurationListPopupStep(@NotNull ChooseRunConfigurationPopup action, @NotNull Project project2, @NotNull ExecutorProvider executorProvider, @NotNull String title) {
            super(title, (Object[])ChooseRunConfigurationPopup.createSettingsList(project2, executorProvider, true));
            this.myProject = project2;
            this.myAction = action;
            if (-1 == this.getDefaultOptionIndex()) {
                this.myDefaultConfiguration = this.getDynamicIndex();
            }
        }

        private int getDynamicIndex() {
            int i = 0;
            for (ItemWrapper wrapper : this.getValues()) {
                if (wrapper.isDynamic()) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public boolean isAutoSelectionEnabled() {
            return false;
        }

        public ListSeparator getSeparatorAbove(ItemWrapper value) {
            if (value.addSeparatorAbove()) {
                return new ListSeparator();
            }
            List configurations = this.getValues();
            int index = configurations.indexOf(value);
            if (index > 0 && index <= configurations.size() - 1) {
                ConfigurationType aboveType;
                ItemWrapper aboveConfiguration = (ItemWrapper)configurations.get(index - 1);
                if (aboveConfiguration != null && aboveConfiguration.isDynamic() != value.isDynamic()) {
                    return new ListSeparator();
                }
                ConfigurationType currentType = value.getType();
                ConfigurationType configurationType = aboveType = aboveConfiguration == null ? null : aboveConfiguration.getType();
                if (aboveType != currentType && currentType != null) {
                    return new ListSeparator();
                }
            }
            return null;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public int getDefaultOptionIndex() {
            RunnerAndConfigurationSettings currentConfiguration = RunManager.getInstance((Project)this.myProject).getSelectedConfiguration();
            if (currentConfiguration == null && this.myDefaultConfiguration != -1) {
                return this.myDefaultConfiguration;
            }
            return currentConfiguration instanceof RunnerAndConfigurationSettingsImpl ? this.getValues().indexOf(ItemWrapper.wrap(this.myProject, currentConfiguration)) : -1;
        }

        public PopupStep onChosen(final ItemWrapper wrapper, boolean finalChoice) {
            Object o;
            if (this.myAction.myEditConfiguration && (o = wrapper.getValue()) instanceof RunnerAndConfigurationSettingsImpl) {
                return this.doFinalStep(new Runnable(){

                    @Override
                    public void run() {
                        myAction.editConfiguration(myProject, (RunnerAndConfigurationSettings)o);
                    }
                });
            }
            if (finalChoice && wrapper.available(this.myAction.getExecutor())) {
                return this.doFinalStep(new Runnable(){

                    @Override
                    public void run() {
                        if (myAction.getExecutor() == myAction.myAlternativeExecutor) {
                            PropertiesComponent.getInstance().setValue(myAction.myAddKey, Boolean.toString(true));
                        }
                        wrapper.perform(myProject, myAction.getExecutor(), DataManager.getInstance().getDataContext());
                    }
                });
            }
            return wrapper.getNextStep(this.myProject, this.myAction);
        }

        public boolean hasSubstep(ItemWrapper selectedValue) {
            return selectedValue.hasActions();
        }

        @NotNull
        public String getTextFor(ItemWrapper value) {
            return value.getText();
        }

        public Icon getIconFor(ItemWrapper value) {
            return value.getIcon();
        }
    }

    public static abstract class ItemWrapper<T>
    extends Wrapper {
        private final T myValue;
        private boolean myDynamic;

        protected ItemWrapper(@Nullable T value) {
            this(value, false);
        }

        protected ItemWrapper(@Nullable T value, boolean addSeparatorAbove) {
            super(addSeparatorAbove);
            this.myValue = value;
        }

        public T getValue() {
            return this.myValue;
        }

        public boolean isDynamic() {
            return this.myDynamic;
        }

        public void setDynamic(boolean b) {
            this.myDynamic = b;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ItemWrapper)) {
                return false;
            }
            ItemWrapper that = (ItemWrapper)o;
            return !(this.myValue != null ? !this.myValue.equals(that.myValue) : that.myValue != null);
        }

        public int hashCode() {
            return this.myValue != null ? this.myValue.hashCode() : 0;
        }

        public abstract void perform(@NotNull Project var1, @NotNull Executor var2, @NotNull DataContext var3);

        @Nullable
        public ConfigurationType getType() {
            return null;
        }

        public boolean available(Executor executor) {
            return false;
        }

        public boolean hasActions() {
            return false;
        }

        public PopupStep getNextStep(Project project2, ChooseRunConfigurationPopup action) {
            return PopupStep.FINAL_CHOICE;
        }

        public static ItemWrapper wrap(@NotNull Project project2, @NotNull RunnerAndConfigurationSettings settings, boolean dynamic) {
            ItemWrapper result = ItemWrapper.wrap(project2, settings);
            result.setDynamic(dynamic);
            return result;
        }

        public static ItemWrapper wrap(final @NotNull Project project2, @NotNull RunnerAndConfigurationSettings settings) {
            return new ItemWrapper<RunnerAndConfigurationSettings>(settings){

                @Override
                public void perform(@NotNull Project project22, @NotNull Executor executor, @NotNull DataContext context) {
                    RunnerAndConfigurationSettings config = (RunnerAndConfigurationSettings)this.getValue();
                    RunManagerEx.getInstanceEx(project22).setSelectedConfiguration(config);
                    ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)config, (Executor)executor);
                }

                @Override
                public ConfigurationType getType() {
                    return ((RunnerAndConfigurationSettings)this.getValue()).getType();
                }

                @Override
                public Icon getIcon() {
                    return RunManagerEx.getInstanceEx(project2).getConfigurationIcon((RunnerAndConfigurationSettings)this.getValue());
                }

                @Override
                public String getText() {
                    return ((RunnerAndConfigurationSettings)this.getValue()).getName();
                }

                @Override
                public boolean hasActions() {
                    return true;
                }

                @Override
                public boolean available(Executor executor) {
                    return ProgramRunnerUtil.getRunner(executor.getId(), (RunnerAndConfigurationSettings)this.getValue()) != null;
                }

                @Override
                public PopupStep getNextStep(@NotNull Project project22, @NotNull ChooseRunConfigurationPopup action) {
                    return new ConfigurationActionsStep(project22, action, (RunnerAndConfigurationSettings)this.getValue(), this.isDynamic());
                }
            };
        }

        @Override
        public boolean canBeDeleted() {
            return !this.isDynamic() && this.getValue() instanceof RunnerAndConfigurationSettings;
        }
    }

    private static abstract class Wrapper {
        private int myMnemonic = -1;
        private final boolean myAddSeparatorAbove;
        private boolean myChecked;

        protected Wrapper(boolean addSeparatorAbove) {
            this.myAddSeparatorAbove = addSeparatorAbove;
        }

        public int getMnemonic() {
            return this.myMnemonic;
        }

        public boolean isChecked() {
            return this.myChecked;
        }

        public void setChecked(boolean checked) {
            this.myChecked = checked;
        }

        public void setMnemonic(int mnemonic) {
            this.myMnemonic = mnemonic;
        }

        public boolean addSeparatorAbove() {
            return this.myAddSeparatorAbove;
        }

        @Nullable
        public abstract Icon getIcon();

        public abstract String getText();

        public boolean canBeDeleted() {
            return false;
        }

        public String toString() {
            return "Wrapper[" + this.getText() + "]";
        }
    }
}

