/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.newvfs.persistent.FlushingDaemon;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestStateStorage
implements Disposable {
    private static final File TEST_HISTORY_PATH = new File(PathManager.getSystemPath(), "testHistory");
    private final File myFile;
    private static final Logger LOG = Logger.getInstance(TestStateStorage.class);
    @Nullable
    private PersistentHashMap<String, Record> myMap;
    private volatile ScheduledFuture<?> myMapFlusher;

    public static File getTestHistoryRoot(Project project2) {
        return new File(TEST_HISTORY_PATH, project2.getLocationHash());
    }

    public static TestStateStorage getInstance(@NotNull Project project2) {
        return (TestStateStorage)ServiceManager.getService((Project)project2, TestStateStorage.class);
    }

    public TestStateStorage(Project project2) {
        this.myFile = new File(TestStateStorage.getTestHistoryRoot(project2).getPath() + "/testStateMap");
        FileUtilRt.createParentDirs((File)this.myFile);
        try {
            this.myMap = this.initializeMap();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        this.myMapFlusher = FlushingDaemon.everyFiveSeconds(new Runnable(){

            @Override
            public void run() {
                TestStateStorage.this.flushMap();
            }
        });
        Disposer.register((Disposable)project2, (Disposable)this);
    }

    private PersistentHashMap<String, Record> initializeMap() throws IOException {
        return (PersistentHashMap)IOUtil.openCleanOrResetBroken(TestStateStorage.getComputable(this.myFile), (File)this.myFile);
    }

    private synchronized void flushMap() {
        if (this.myMapFlusher == null) {
            return;
        }
        if (this.myMap != null && this.myMap.isDirty()) {
            this.myMap.force();
        }
    }

    @NotNull
    private static ThrowableComputable<PersistentHashMap<String, Record>, IOException> getComputable(final File file2) {
        return new ThrowableComputable<PersistentHashMap<String, Record>, IOException>(){

            public PersistentHashMap<String, Record> compute() throws IOException {
                return new PersistentHashMap(file2, (KeyDescriptor)new EnumeratorStringDescriptor(), (DataExternalizer)new DataExternalizer<Record>(){

                    public void save(@NotNull DataOutput out, Record value) throws IOException {
                        out.writeInt(value.magnitude);
                        out.writeLong(value.date.getTime());
                    }

                    public Record read(@NotNull DataInput in) throws IOException {
                        return new Record(in.readInt(), new Date(in.readLong()));
                    }
                });
            }
        };
    }

    @Nullable
    public synchronized Record getState(String testUrl) {
        try {
            return this.myMap == null ? null : (Record)this.myMap.get((Object)testUrl);
        }
        catch (IOException e) {
            this.thingsWentWrongLetsReinitialize(e, "Can't get state for " + testUrl);
            return null;
        }
    }

    public synchronized void removeState(String url) {
        if (this.myMap != null) {
            try {
                this.myMap.remove((Object)url);
            }
            catch (IOException e) {
                this.thingsWentWrongLetsReinitialize(e, "Can't remove state for " + url);
            }
        }
    }

    @Nullable
    public synchronized Map<String, Record> getRecentTests(int limit, Date since) {
        if (this.myMap == null) {
            return null;
        }
        HashMap result = ContainerUtil.newHashMap();
        try {
            for (String key : this.myMap.getAllKeysWithExistingMapping()) {
                Record record = (Record)this.myMap.get((Object)key);
                if (record == null || record.date.compareTo(since) <= 0) continue;
                result.put(key, record);
                if (result.size() < limit) continue;
                break;
            }
        }
        catch (IOException e) {
            this.thingsWentWrongLetsReinitialize(e, "Can't get recent tests");
        }
        return result;
    }

    public synchronized void writeState(@NotNull String testUrl, Record record) {
        if (this.myMap == null) {
            return;
        }
        try {
            this.myMap.put((Object)testUrl, (Object)record);
        }
        catch (IOException e) {
            this.thingsWentWrongLetsReinitialize(e, "Can't write state for " + testUrl);
        }
    }

    public synchronized void dispose() {
        this.myMapFlusher.cancel(false);
        this.myMapFlusher = null;
        if (this.myMap == null) {
            return;
        }
        try {
            this.myMap.close();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        finally {
            this.myMap = null;
        }
    }

    private void thingsWentWrongLetsReinitialize(IOException e, String message) {
        try {
            if (this.myMap != null) {
                try {
                    this.myMap.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                IOUtil.deleteAllFilesStartingWith((File)this.myFile);
            }
            this.myMap = this.initializeMap();
            LOG.error(message, (Throwable)e);
        }
        catch (IOException e1) {
            LOG.error("Cannot repair", (Throwable)e1);
            this.myMap = null;
        }
    }

    public static class Record {
        public final int magnitude;
        public final Date date;

        public Record(int magnitude, Date date) {
            this.magnitude = magnitude;
            this.date = date;
        }
    }
}

