/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetListener;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.ExecutionTargetProvider;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerAdapter;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ExecutionTargetManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ExecutionTargetManagerImpl
extends ExecutionTargetManager
implements PersistentStateComponent<Element> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Object myActiveTargetLock = new Object();
    @Nullable
    private ExecutionTarget myActiveTarget;
    @Nullable
    private String mySavedActiveTargetId;

    public ExecutionTargetManagerImpl(@NotNull Project project2, @NotNull RunManager runManager) {
        this.myProject = project2;
        ((RunManagerEx)runManager).addRunManagerListener(new RunManagerAdapter(){

            @Override
            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == RunManager.getInstance((Project)ExecutionTargetManagerImpl.this.myProject).getSelectedConfiguration()) {
                    ExecutionTargetManagerImpl.this.updateActiveTarget(settings);
                }
            }

            @Override
            public void runConfigurationSelected() {
                ExecutionTargetManagerImpl.this.updateActiveTarget();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getState() {
        Object object = this.myActiveTargetLock;
        synchronized (object) {
            String id;
            Element state = new Element("state");
            String string = id = this.myActiveTarget == null ? this.mySavedActiveTargetId : this.myActiveTarget.getId();
            if (id != null) {
                state.setAttribute("SELECTED_TARGET", id);
            }
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(Element state) {
        Object object = this.myActiveTargetLock;
        synchronized (object) {
            if (this.myActiveTarget == null && this.mySavedActiveTargetId == null) {
                this.mySavedActiveTargetId = state.getAttributeValue("SELECTED_TARGET");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ExecutionTarget getActiveTarget() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Object object = this.myActiveTargetLock;
        synchronized (object) {
            if (this.myActiveTarget == null) {
                this.updateActiveTarget();
            }
            return this.myActiveTarget;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveTarget(@NotNull ExecutionTarget target) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Object object = this.myActiveTargetLock;
        synchronized (object) {
            this.updateActiveTarget(RunManager.getInstance((Project)this.myProject).getSelectedConfiguration(), target);
        }
    }

    private void updateActiveTarget() {
        this.updateActiveTarget(RunManager.getInstance((Project)this.myProject).getSelectedConfiguration());
    }

    private void updateActiveTarget(@Nullable RunnerAndConfigurationSettings settings) {
        this.updateActiveTarget(settings, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateActiveTarget(@Nullable RunnerAndConfigurationSettings settings, @Nullable ExecutionTarget toSelect) {
        ExecutionTarget toNotify;
        List<ExecutionTarget> suitable = settings == null ? Collections.singletonList(DefaultExecutionTarget.INSTANCE) : this.getTargetsFor(settings);
        Object object = this.myActiveTargetLock;
        synchronized (object) {
            if (toSelect == null) {
                toSelect = this.myActiveTarget;
            }
            int index = -1;
            if (toSelect != null) {
                index = suitable.indexOf(toSelect);
            } else if (this.mySavedActiveTargetId != null) {
                int size = suitable.size();
                for (int i = 0; i < size; ++i) {
                    if (!suitable.get(i).getId().equals(this.mySavedActiveTargetId)) continue;
                    index = i;
                    break;
                }
            }
            toNotify = this.doSetActiveTarget(index >= 0 ? suitable.get(index) : (ExecutionTarget)ContainerUtil.getFirstItem(suitable, (Object)DefaultExecutionTarget.INSTANCE));
        }
        if (toNotify != null) {
            ((ExecutionTargetListener)this.myProject.getMessageBus().syncPublisher(TOPIC)).activeTargetChanged(toNotify);
        }
    }

    @Nullable
    private ExecutionTarget doSetActiveTarget(@NotNull ExecutionTarget newTarget) {
        this.mySavedActiveTargetId = null;
        ExecutionTarget prev = this.myActiveTarget;
        this.myActiveTarget = newTarget;
        if (prev != null && !prev.equals((Object)this.myActiveTarget)) {
            return this.myActiveTarget;
        }
        return null;
    }

    @NotNull
    public List<ExecutionTarget> getTargetsFor(@Nullable RunnerAndConfigurationSettings settings) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (settings == null) {
            return Collections.emptyList();
        }
        ArrayList<ExecutionTarget> result = new ArrayList<ExecutionTarget>();
        for (ExecutionTargetProvider eachTargetProvider : (ExecutionTargetProvider[])Extensions.getExtensions((ExtensionPointName)ExecutionTargetProvider.EXTENSION_NAME)) {
            for (ExecutionTarget eachTarget : eachTargetProvider.getTargets(this.myProject, settings)) {
                if (!ExecutionTargetManagerImpl.canRun((RunnerAndConfigurationSettings)settings, (ExecutionTarget)eachTarget)) continue;
                result.add(eachTarget);
            }
        }
        return Collections.unmodifiableList(result);
    }

    public void update() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.updateActiveTarget();
    }
}

