/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.push.PushController;
import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.push.PushTarget;
import com.intellij.dvcs.push.VcsPushOptionValue;
import com.intellij.dvcs.push.VcsPushOptionsPanel;
import com.intellij.dvcs.push.ui.PushLog;
import com.intellij.dvcs.repo.Repository;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.OptionAction;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsPushDialog
extends DialogWrapper {
    private static final String ID = "Vcs.Push.Dialog";
    private final PushLog myListPanel;
    private final PushController myController;
    private final Map<PushSupport, VcsPushOptionsPanel> myAdditionalPanels;
    private Action myPushAction;
    @Nullable
    private ForcePushAction myForcePushAction;

    public VcsPushDialog(@NotNull Project project2, @NotNull List<? extends Repository> selectedRepositories, @Nullable Repository currentRepo) {
        super(project2);
        this.myController = new PushController(project2, this, selectedRepositories, currentRepo);
        this.myAdditionalPanels = this.myController.createAdditionalPanels();
        this.myListPanel = this.myController.getPushPanelLog();
        this.init();
        this.updateOkActions();
        this.setOKButtonText("Push");
        this.setOKButtonMnemonic(80);
        this.setTitle("Push Commits");
    }

    protected JComponent createCenterPanel() {
        JPanel optionsPanel = new JPanel((LayoutManager)new MigLayout("ins 0 0, flowx"));
        for (VcsPushOptionsPanel panel : this.myAdditionalPanels.values()) {
            optionsPanel.add((Component)panel);
        }
        optionsPanel.setBorder((Border)JBUI.Borders.emptyTop((int)6));
        BorderLayoutPanel panel = JBUI.Panels.simplePanel((Component)optionsPanel);
        if (!this.myController.isForcePushEnabled()) {
            panel.addToTop((Component)this.createForcePushInfoLabel());
        }
        return JBUI.Panels.simplePanel((int)0, (int)2).addToCenter((Component)this.myListPanel).addToBottom((Component)panel);
    }

    @NotNull
    private JComponent createForcePushInfoLabel() {
        JPanel text = new JPanel();
        text.setLayout(new BoxLayout(text, 0));
        JLabel label = new JLabel("You can enable and configure Force Push in " + ShowSettingsUtil.getSettingsMenuName() + ".");
        label.setEnabled(false);
        label.setFont((Font)JBUI.Fonts.smallFont());
        text.add(label);
        ActionLink here = new ActionLink("Configure", new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                Project project2 = VcsPushDialog.this.myController.getProject();
                VcsPushDialog.this.doCancelAction(e.getInputEvent());
                ShowSettingsUtilImpl.showSettingsDialog(project2, "vcs.Git", "force push");
            }
        });
        here.setFont((Font)JBUI.Fonts.smallFont());
        text.add((Component)here);
        return JBUI.Panels.simplePanel().addToRight((Component)text).withBorder((Border)JBUI.Borders.emptyBottom((int)4));
    }

    protected String getDimensionServiceKey() {
        return ID;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        this.updateOkActions();
        return null;
    }

    protected boolean postponeValidation() {
        return false;
    }

    protected void doOKAction() {
        this.myController.push(false);
        this.close(0);
    }

    @NotNull
    protected Action[] createActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        this.myForcePushAction = new ForcePushAction();
        this.myForcePushAction.setEnabled(this.canForcePush());
        this.myForcePushAction.putValue("Name", "&Force Push");
        if (this.myController.isForcePushEnabled()) {
            this.myPushAction = new ComplexPushAction(this.myForcePushAction);
        } else {
            this.myPushAction = new DialogWrapper.OkAction(){};
            this.myPushAction.putValue("Name", "&Push");
        }
        this.myPushAction.putValue("DefaultAction", Boolean.TRUE);
        actions.add(this.myPushAction);
        actions.add(this.getCancelAction());
        actions.add(this.getHelpAction());
        return actions.toArray(new Action[actions.size()]);
    }

    private boolean canPush() {
        return this.myController.isPushAllowed(false);
    }

    private boolean canForcePush() {
        return this.myController.isForcePushEnabled() && this.myController.getProhibitedTarget() == null && this.myController.isPushAllowed(true);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myListPanel.getPreferredFocusedComponent();
    }

    @NotNull
    protected Action getOKAction() {
        return this.myPushAction;
    }

    protected String getHelpId() {
        return ID;
    }

    public void updateOkActions() {
        this.myPushAction.setEnabled(this.canPush());
        if (this.myForcePushAction != null) {
            boolean canForcePush = this.canForcePush();
            this.myForcePushAction.setEnabled(canForcePush);
            String tooltip = null;
            if (!canForcePush) {
                PushTarget target = this.myController.getProhibitedTarget();
                tooltip = this.myController.isForcePushEnabled() && target != null ? "Force push to <b>" + target.getPresentation() + "</b> is prohibited" : "<b>Force Push</b> can be enabled in the Settings";
            }
            this.myForcePushAction.putValue("ShortDescription", tooltip);
        }
    }

    public void disableOkActions() {
        this.myPushAction.setEnabled(false);
    }

    @Nullable
    public VcsPushOptionValue getAdditionalOptionValue(@NotNull PushSupport support) {
        VcsPushOptionsPanel panel = this.myAdditionalPanels.get(support);
        return panel == null ? null : panel.getValue();
    }

    private class ComplexPushAction
    extends AbstractAction
    implements OptionAction {
        private final Action[] myOptions;

        private ComplexPushAction(Action additionalAction) {
            super("&Push");
            this.myOptions = new Action[]{additionalAction};
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VcsPushDialog.this.myController.push(false);
            VcsPushDialog.this.close(0);
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            for (Action optionAction : this.myOptions) {
                optionAction.setEnabled(isEnabled);
            }
        }

        @NotNull
        public Action[] getOptions() {
            return this.myOptions;
        }
    }

    private class ForcePushAction
    extends AbstractAction {
        ForcePushAction() {
            super("&Force Push");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (VcsPushDialog.this.myController.ensureForcePushIsNeeded()) {
                VcsPushDialog.this.myController.push(true);
                VcsPushDialog.this.close(0);
            }
        }
    }
}

