/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.dvcs.push.ui.TooltipNode;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JTree;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsCommitInfoBalloon {
    private static final String EMPTY_COMMIT_INFO = "<i style='color:gray;'>No commit information found</i>";
    @NotNull
    private final JTree myTree;
    @NotNull
    private final Wrapper myWrapper;
    @Nullable
    private JBPopup myBalloon;
    @NotNull
    private final JEditorPane myEditorPane;
    @NotNull
    private final ComponentPopupBuilder myPopupBuilder;

    public VcsCommitInfoBalloon(@NotNull JTree tree) {
        this.myTree = tree;
        this.myEditorPane = new JEditorPane("text/html", "");
        this.myEditorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.myEditorPane.setEditable(false);
        this.myEditorPane.setBackground(HintUtil.INFORMATION_COLOR);
        this.myEditorPane.setFont(UIUtil.getToolTipFont());
        this.myEditorPane.setBorder(HintUtil.createHintBorder());
        Border margin = IdeBorderFactory.createEmptyBorder((int)3, (int)3, (int)3, (int)3);
        this.myEditorPane.setBorder(new CompoundBorder(this.myEditorPane.getBorder(), margin));
        this.myEditorPane.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                BrowserUtil.browse((URL)e.getURL());
            }
        });
        this.myWrapper = new Wrapper((JComponent)this.myEditorPane);
        this.myPopupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.myWrapper, null);
        this.myPopupBuilder.setCancelOnClickOutside(true).setResizable(true).setMovable(true).setRequestFocus(false).setMinSize(new Dimension(80, 30));
    }

    public void updateCommitDetails() {
        if (this.myBalloon != null && this.myBalloon.isVisible()) {
            TreePath[] selectionPaths = this.myTree.getSelectionPaths();
            if (selectionPaths == null || selectionPaths.length != 1) {
                this.myBalloon.cancel();
            } else {
                Object node = selectionPaths[0].getLastPathComponent();
                this.myEditorPane.setText(XmlStringUtil.wrapInHtml((CharSequence)(node instanceof TooltipNode ? ((TooltipNode)node).getTooltip().replaceAll("\n", "<br>") : EMPTY_COMMIT_INFO)));
                RepaintManager rp = RepaintManager.currentManager(this.myEditorPane);
                rp.markCompletelyDirty(this.myEditorPane);
                rp.validateInvalidComponents();
                rp.paintDirtyRegions();
                this.myBalloon.setSize(this.myWrapper.getPreferredSize());
                this.myBalloon.setLocation(this.calculateBestPopupLocation());
            }
        }
    }

    @NotNull
    private Point calculateBestPopupLocation() {
        Point defaultLocation = this.myTree.getLocationOnScreen();
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath == null) {
            return defaultLocation;
        }
        Rectangle rectangle = this.myTree.getPathBounds(selectionPath);
        if (rectangle == null) {
            return defaultLocation;
        }
        Point location = rectangle.getLocation();
        SwingUtilities.convertPointToScreen(location, this.myTree);
        return new Point(location.x, location.y + rectangle.height);
    }

    private void createNewCommitInfoBalloon() {
        this.myBalloon = this.myPopupBuilder.createPopup();
        this.myBalloon.setSize(this.myEditorPane.getPreferredSize());
    }

    public void showCommitDetails() {
        if (this.myBalloon == null || !this.myBalloon.isVisible()) {
            this.createNewCommitInfoBalloon();
            this.myBalloon.show(new RelativePoint(this.calculateBestPopupLocation()));
        }
        this.updateCommitDetails();
    }
}

