/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.openapi.editor.SpellCheckingEditorCustomizationProvider;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorCustomization;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PushTargetTextField
extends TextFieldWithAutoCompletion<String> {
    public PushTargetTextField(@NotNull Project project2, @NotNull List<String> targetVariants, @NotNull String defaultTargetName) {
        super(project2, PushTargetTextField.getCompletionProvider(targetVariants), true, defaultTargetName);
        this.setOneLineMode(true);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                PushTargetTextField.this.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
                PushTargetTextField.this.removeSelection();
            }
        });
    }

    @Override
    protected EditorEx createEditor() {
        EditorEx editorEx = super.createEditor();
        EditorCustomization customization = SpellCheckingEditorCustomizationProvider.getInstance().getDisabledCustomization();
        if (customization != null) {
            customization.customize(editorEx);
        }
        return editorEx;
    }

    @Override
    protected void updateBorder(@NotNull EditorEx editor) {
    }

    @NotNull
    private static TextFieldWithAutoCompletionListProvider<String> getCompletionProvider(final @NotNull List<String> targetVariants) {
        return new TextFieldWithAutoCompletion.StringsCompletionProvider(targetVariants, null){

            @Override
            public int compare(String item1, String item2) {
                return Integer.valueOf(ContainerUtil.indexOf((List)targetVariants, (Object)item1)).compareTo(ContainerUtil.indexOf((List)targetVariants, (Object)item2));
            }
        };
    }
}

