/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.ui.CustomRenderedTreeNode;
import com.intellij.dvcs.push.ui.PushLogTreeUtil;
import com.intellij.dvcs.push.ui.RepositoryNode;
import com.intellij.dvcs.push.ui.TooltipNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsFullCommitDetails;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class CommitNode
extends DefaultMutableTreeNode
implements CustomRenderedTreeNode,
TooltipNode {
    @NotNull
    private final Project myProject;

    public CommitNode(@NotNull Project project2, @NotNull VcsFullCommitDetails commit) {
        super(commit, false);
        this.myProject = project2;
    }

    public VcsFullCommitDetails getUserObject() {
        return (VcsFullCommitDetails)super.getUserObject();
    }

    @Override
    public void render(@NotNull ColoredTreeCellRenderer renderer) {
        renderer.append("   ");
        TreeNode parent = this.getParent();
        new IssueLinkRenderer(this.myProject, (SimpleColoredComponent)renderer).appendTextWithLinks(this.getUserObject().getSubject(), PushLogTreeUtil.addTransparencyIfNeeded(SimpleTextAttributes.REGULAR_ATTRIBUTES, !(parent instanceof RepositoryNode) || ((RepositoryNode)((Object)parent)).isChecked()));
    }

    @Override
    public String getTooltip() {
        String hash = DvcsUtil.getShortHash(((Hash)this.getUserObject().getId()).toString());
        String date = DvcsUtil.getDateString((TimedVcsCommit)this.getUserObject());
        String author = this.getUserObject().getAuthor().getName();
        String message = IssueLinkHtmlRenderer.formatTextWithLinks(this.myProject, this.getUserObject().getFullMessage());
        return String.format("%s  %s  by %s\n\n%s", hash, date, author, message);
    }
}

