/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.branch.DvcsMultiRootBranchConfig;
import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.BranchActionGroupPopup;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DvcsBranchPopup<Repo extends Repository> {
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final AbstractRepositoryManager<Repo> myRepositoryManager;
    @NotNull
    protected final DvcsSyncSettings myVcsSettings;
    @NotNull
    protected final AbstractVcs myVcs;
    @NotNull
    protected final DvcsMultiRootBranchConfig<Repo> myMultiRootBranchConfig;
    @NotNull
    protected final Repo myCurrentRepository;
    @NotNull
    protected final ListPopupImpl myPopup;

    protected DvcsBranchPopup(@NotNull Repo currentRepository, @NotNull AbstractRepositoryManager<Repo> repositoryManager, @NotNull DvcsMultiRootBranchConfig<Repo> multiRootBranchConfig, @NotNull DvcsSyncSettings vcsSettings, @NotNull Condition<AnAction> preselectActionCondition) {
        this.myProject = currentRepository.getProject();
        this.myCurrentRepository = currentRepository;
        this.myRepositoryManager = repositoryManager;
        this.myVcs = currentRepository.getVcs();
        this.myVcsSettings = vcsSettings;
        this.myMultiRootBranchConfig = multiRootBranchConfig;
        String title = this.createPopupTitle(currentRepository);
        this.myPopup = new BranchActionGroupPopup(title, this.myProject, preselectActionCondition, this.createActions());
        this.initBranchSyncPolicyIfNotInitialized();
        this.setCurrentBranchInfo();
        this.warnThatBranchesDivergedIfNeeded();
    }

    @NotNull
    public ListPopup asListPopup() {
        return this.myPopup;
    }

    private void initBranchSyncPolicyIfNotInitialized() {
        if (this.myRepositoryManager.moreThanOneRoot() && this.myVcsSettings.getSyncSetting() == DvcsSyncSettings.Value.NOT_DECIDED) {
            if (!this.myMultiRootBranchConfig.diverged()) {
                this.notifyAboutSyncedBranches();
                this.myVcsSettings.setSyncSetting(DvcsSyncSettings.Value.SYNC);
            } else {
                this.myVcsSettings.setSyncSetting(DvcsSyncSettings.Value.DONT_SYNC);
            }
        }
    }

    @NotNull
    private String createPopupTitle(@NotNull Repo currentRepository) {
        String title = this.myVcs.getDisplayName() + " Branches";
        if (this.myRepositoryManager.moreThanOneRoot() && this.myVcsSettings.getSyncSetting() == DvcsSyncSettings.Value.DONT_SYNC) {
            title = title + " in " + DvcsUtil.getShortRepositoryName(currentRepository);
        }
        return title;
    }

    protected void setCurrentBranchInfo() {
        String branchText = "Current branch : ";
        this.myPopup.setAdText(branchText + this.myCurrentRepository.getCurrentBranchName(), 0);
    }

    private void notifyAboutSyncedBranches() {
        String description = "You have several " + this.myVcs.getDisplayName() + " roots in the project and they all are checked out at the same branch. " + "We've enabled synchronous branch control for the project. <br/>" + "If you wish to control branches in different roots separately, " + "you may <a href='settings'>disable</a> the setting.";
        NotificationListener listener2 = new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    ShowSettingsUtil.getInstance().showSettingsDialog(DvcsBranchPopup.this.myProject, DvcsBranchPopup.this.myVcs.getConfigurable().getDisplayName());
                    if (DvcsBranchPopup.this.myVcsSettings.getSyncSetting() == DvcsSyncSettings.Value.DONT_SYNC) {
                        notification.expire();
                    }
                }
            }
        };
        VcsNotifier.getInstance(this.myProject).notifyImportantInfo("Synchronous branch control enabled", description, listener2);
    }

    @NotNull
    private ActionGroup createActions() {
        DefaultActionGroup popupGroup = new DefaultActionGroup(null, false);
        AbstractRepositoryManager<Repo> repositoryManager = this.myRepositoryManager;
        if (repositoryManager.moreThanOneRoot()) {
            if (this.userWantsSyncControl()) {
                this.fillWithCommonRepositoryActions(popupGroup, repositoryManager);
            } else {
                this.fillPopupWithCurrentRepositoryActions(popupGroup, this.createRepositoriesActions());
            }
        } else {
            this.fillPopupWithCurrentRepositoryActions(popupGroup, null);
        }
        popupGroup.addSeparator();
        return popupGroup;
    }

    private boolean userWantsSyncControl() {
        return this.myVcsSettings.getSyncSetting() != DvcsSyncSettings.Value.DONT_SYNC;
    }

    protected abstract void fillWithCommonRepositoryActions(@NotNull DefaultActionGroup var1, @NotNull AbstractRepositoryManager<Repo> var2);

    @NotNull
    protected List<Repo> filterRepositoriesNotOnThisBranch(final @NotNull String branch, @NotNull List<Repo> allRepositories) {
        return ContainerUtil.filter(allRepositories, (Condition)new Condition<Repo>(){

            public boolean value(Repo repository) {
                return !branch.equals(repository.getCurrentBranchName());
            }
        });
    }

    private void warnThatBranchesDivergedIfNeeded() {
        if (this.myRepositoryManager.moreThanOneRoot() && this.myMultiRootBranchConfig.diverged() && this.userWantsSyncControl()) {
            this.myPopup.setWarning("Branches have diverged");
        }
    }

    @NotNull
    protected abstract DefaultActionGroup createRepositoriesActions();

    protected boolean highlightCurrentRepo() {
        return !this.userWantsSyncControl() || this.myMultiRootBranchConfig.diverged();
    }

    protected abstract void fillPopupWithCurrentRepositoryActions(@NotNull DefaultActionGroup var1, @Nullable DefaultActionGroup var2);
}

