/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.dupLocator.ExternalizableDuplocatorState;
import com.intellij.lang.Language;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.Map;
import java.util.TreeMap;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="MultiLanguageDuplocatorSettings", storages={@Storage(value="duplocatorSettings.xml")})
public class MultilanguageDuplocatorSettings
implements PersistentStateComponent<Element> {
    private final Map<String, ExternalizableDuplocatorState> mySettingsMap = new TreeMap<String, ExternalizableDuplocatorState>();

    public static MultilanguageDuplocatorSettings getInstance() {
        return (MultilanguageDuplocatorSettings)ServiceManager.getService(MultilanguageDuplocatorSettings.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerState(@NotNull Language language, @NotNull ExternalizableDuplocatorState state) {
        Map<String, ExternalizableDuplocatorState> map = this.mySettingsMap;
        synchronized (map) {
            this.mySettingsMap.put(language.getDisplayName(), state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalizableDuplocatorState getState(@NotNull Language language) {
        Map<String, ExternalizableDuplocatorState> map = this.mySettingsMap;
        synchronized (map) {
            return this.mySettingsMap.get(language.getDisplayName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getState() {
        Map<String, ExternalizableDuplocatorState> map = this.mySettingsMap;
        synchronized (map) {
            Element state = new Element("state");
            if (this.mySettingsMap.isEmpty()) {
                return state;
            }
            SkipDefaultValuesSerializationFilters filter = new SkipDefaultValuesSerializationFilters();
            for (String name : this.mySettingsMap.keySet()) {
                Element child = XmlSerializer.serialize((Object)this.mySettingsMap.get(name), (SerializationFilter)filter);
                if (JDOMUtil.isEmpty((Element)child)) continue;
                child.setName("object");
                child.setAttribute("language", name);
                state.addContent(child);
            }
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(Element state) {
        Map<String, ExternalizableDuplocatorState> map = this.mySettingsMap;
        synchronized (map) {
            if (state == null) {
                return;
            }
            for (Element objectElement : state.getChildren("object")) {
                ExternalizableDuplocatorState stateObject;
                String language = objectElement.getAttributeValue("language");
                if (language == null || (stateObject = this.mySettingsMap.get(language)) == null) continue;
                XmlSerializer.deserializeInto((Object)stateObject, (Element)objectElement);
            }
        }
    }
}

