/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.util.BackgroundTaskUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffTaskQueue {
    @Nullable
    private ProgressIndicator myProgressIndicator;

    public void abort() {
        if (this.myProgressIndicator != null) {
            this.myProgressIndicator.cancel();
        }
        this.myProgressIndicator = null;
    }

    public void executeAndTryWait(@NotNull Function<ProgressIndicator, Runnable> backgroundTask, @Nullable Runnable onSlowAction, int waitMillis) {
        this.executeAndTryWait(backgroundTask, onSlowAction, waitMillis, false);
    }

    public void executeAndTryWait(@NotNull Function<ProgressIndicator, Runnable> backgroundTask, @Nullable Runnable onSlowAction, int waitMillis, boolean forceEDT) {
        this.abort();
        this.myProgressIndicator = BackgroundTaskUtil.executeAndTryWait(backgroundTask, onSlowAction, waitMillis, forceEDT);
    }
}

