/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackgroundTaskUtil {
    private static final Logger LOG = Logger.getInstance(BackgroundTaskUtil.class);
    private static final Runnable TOO_SLOW_OPERATION = new EmptyRunnable();

    @NotNull
    public static ProgressIndicator executeAndTryWait(@NotNull Function<ProgressIndicator, Runnable> backgroundTask, @Nullable Runnable onSlowAction, int waitMillis) {
        return BackgroundTaskUtil.executeAndTryWait(backgroundTask, onSlowAction, waitMillis, false);
    }

    @NotNull
    public static ProgressIndicator executeAndTryWait(final @NotNull Function<ProgressIndicator, Runnable> backgroundTask, @Nullable Runnable onSlowAction, int waitMillis, boolean forceEDT) {
        final ModalityState modality = ModalityState.current();
        EmptyProgressIndicator indicator = new EmptyProgressIndicator(){

            @NotNull
            public ModalityState getModalityState() {
                return modality;
            }
        };
        Semaphore semaphore = new Semaphore(0);
        AtomicReference<Runnable> resultRef = new AtomicReference<Runnable>();
        if (forceEDT) {
            try {
                Runnable callback = (Runnable)backgroundTask.fun((Object)indicator);
                BackgroundTaskUtil.finish(callback, (ProgressIndicator)indicator);
            }
            catch (ProcessCanceledException callback) {
            }
            catch (Throwable t) {
                LOG.error(t);
            }
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable((ProgressIndicator)indicator, semaphore, resultRef, modality){
                final /* synthetic */ ProgressIndicator val$indicator;
                final /* synthetic */ Semaphore val$semaphore;
                final /* synthetic */ AtomicReference val$resultRef;
                final /* synthetic */ ModalityState val$modality;
                {
                    this.val$indicator = progressIndicator;
                    this.val$semaphore = semaphore;
                    this.val$resultRef = atomicReference;
                    this.val$modality = modalityState;
                }

                @Override
                public void run() {
                    ProgressManager.getInstance().executeProcessUnderProgress(new Runnable(){

                        @Override
                        public void run() {
                            final Runnable callback = (Runnable)backgroundTask.fun((Object)val$indicator);
                            if (val$indicator.isCanceled()) {
                                val$semaphore.release();
                                return;
                            }
                            if (!val$resultRef.compareAndSet(null, callback)) {
                                ApplicationManager.getApplication().invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        BackgroundTaskUtil.finish(callback, val$indicator);
                                    }
                                }, val$modality);
                            }
                            val$semaphore.release();
                        }
                    }, this.val$indicator);
                }
            });
            try {
                semaphore.tryAcquire(waitMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!resultRef.compareAndSet(null, TOO_SLOW_OPERATION)) {
                BackgroundTaskUtil.finish((Runnable)resultRef.get(), (ProgressIndicator)indicator);
            } else if (onSlowAction != null) {
                onSlowAction.run();
            }
        }
        return indicator;
    }

    private static void finish(@NotNull Runnable result, @NotNull ProgressIndicator indicator) {
        if (indicator.isCanceled()) {
            return;
        }
        result.run();
        indicator.stop();
    }

    @Nullable
    public static <T> T tryComputeFast(final @NotNull Function<ProgressIndicator, T> backgroundTask, int waitMillis) {
        final Ref resultRef = new Ref();
        ProgressIndicator indicator = BackgroundTaskUtil.executeAndTryWait(new Function<ProgressIndicator, Runnable>(){

            public Runnable fun(ProgressIndicator indicator) {
                final Object result = backgroundTask.fun((Object)indicator);
                return new Runnable(){

                    @Override
                    public void run() {
                        resultRef.set(result);
                    }
                };
            }
        }, null, waitMillis, false);
        indicator.cancel();
        return (T)resultRef.get();
    }

    @NotNull
    public static ProgressIndicator executeOnPooledThread(final @NotNull Consumer<ProgressIndicator> task, @NotNull Disposable parent) {
        final ModalityState modalityState = ModalityState.current();
        EmptyProgressIndicator indicator = new EmptyProgressIndicator(){

            @NotNull
            public ModalityState getModalityState() {
                return modalityState;
            }
        };
        indicator.start();
        Disposable disposable = new Disposable((ProgressIndicator)indicator){
            final /* synthetic */ ProgressIndicator val$indicator;
            {
                this.val$indicator = progressIndicator;
            }

            public void dispose() {
                if (this.val$indicator.isRunning()) {
                    this.val$indicator.cancel();
                }
            }
        };
        Disposer.register((Disposable)parent, (Disposable)disposable);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable((ProgressIndicator)indicator, disposable){
            final /* synthetic */ ProgressIndicator val$indicator;
            final /* synthetic */ Disposable val$disposable;
            {
                this.val$indicator = progressIndicator;
                this.val$disposable = disposable;
            }

            @Override
            public void run() {
                ProgressManager.getInstance().executeProcessUnderProgress(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            task.consume((Object)val$indicator);
                        }
                        finally {
                            val$indicator.stop();
                            Disposer.dispose((Disposable)val$disposable);
                        }
                    }
                }, this.val$indicator);
            }
        });
        return indicator;
    }
}

