/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.side;

import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.ProxyUndoRedoAction;
import com.intellij.diff.actions.impl.FocusOppositePaneAction;
import com.intellij.diff.actions.impl.OpenInEditorWithMouseAction;
import com.intellij.diff.actions.impl.SetEditorSettingsAction;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.holders.EditorHolderFactory;
import com.intellij.diff.tools.holders.TextEditorHolder;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.base.InitialScrollPositionSupport;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.TwosideDiffViewer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TwosideTextDiffViewer
extends TwosideDiffViewer<TextEditorHolder> {
    public static final Logger LOG = Logger.getInstance(TwosideTextDiffViewer.class);
    @NotNull
    private final List<? extends EditorEx> myEditableEditors;
    @Nullable
    private List<? extends EditorEx> myEditors;
    @NotNull
    protected final SetEditorSettingsAction myEditorSettingsAction;
    @NotNull
    private final MyVisibleAreaListener myVisibleAreaListener = new MyVisibleAreaListener();
    @Nullable
    private SyncScrollSupport.TwosideSyncScrollSupport mySyncScrollSupport;

    public TwosideTextDiffViewer(@NotNull DiffContext context, @NotNull ContentDiffRequest request) {
        super(context, request, TextEditorHolder.TextEditorHolderFactory.INSTANCE);
        new MyFocusOppositePaneAction(true).setupAction(this.myPanel);
        new MyFocusOppositePaneAction(false).setupAction(this.myPanel);
        this.myEditorSettingsAction = new SetEditorSettingsAction(this.getTextSettings(), this.getEditors());
        this.myEditorSettingsAction.applyDefaults();
        new MyOpenInEditorWithMouseAction().register(this.getEditors());
        this.myEditableEditors = TextDiffViewerUtil.getEditableEditors(this.getEditors());
        TextDiffViewerUtil.checkDifferentDocuments(this.myRequest);
        boolean editable1 = DiffUtil.canMakeWritable(this.getContent1().getDocument());
        boolean editable2 = DiffUtil.canMakeWritable(this.getContent2().getDocument());
        if (editable1 ^ editable2) {
            ProxyUndoRedoAction.register(this.getProject(), editable1 ? this.getEditor1() : this.getEditor2(), this.myPanel);
        }
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.installEditorListeners();
    }

    @Override
    protected void onDispose() {
        this.destroyEditorListeners();
        super.onDispose();
    }

    @Override
    @NotNull
    protected List<TextEditorHolder> createEditorHolders(@NotNull EditorHolderFactory<TextEditorHolder> factory) {
        List<TextEditorHolder> holders = super.createEditorHolders(factory);
        boolean[] forceReadOnly = TextDiffViewerUtil.checkForceReadOnly(this.myContext, this.myRequest);
        for (int i = 0; i < 2; ++i) {
            if (!forceReadOnly[i]) continue;
            holders.get(i).getEditor().setViewer(true);
        }
        ((TextEditorHolder)Side.LEFT.select(holders)).getEditor().setVerticalScrollbarOrientation(0);
        if (Registry.is((String)"diff.divider.repainting.disable.blitting")) {
            for (TextEditorHolder holder : holders) {
                holder.getEditor().getScrollPane().getViewport().setScrollMode(0);
            }
        }
        return holders;
    }

    @Override
    @NotNull
    protected List<JComponent> createTitles() {
        return DiffUtil.createSyncHeightComponents(DiffUtil.createTextTitles(this.myRequest, this.getEditors()));
    }

    @NotNull
    public TextDiffSettingsHolder.TextDiffSettings getTextSettings() {
        return TextDiffViewerUtil.getTextSettings(this.myContext);
    }

    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        return TextDiffViewerUtil.createEditorPopupActions();
    }

    @Override
    protected void onDocumentChange(@NotNull DocumentEvent event) {
        super.onDocumentChange(event);
        this.myContentPanel.repaintDivider();
    }

    protected void installEditorListeners() {
        new TextDiffViewerUtil.EditorActionsPopup(this.createEditorPopupActions()).install(this.getEditors());
        new TextDiffViewerUtil.EditorFontSizeSynchronizer(this.getEditors()).install((Disposable)this);
        this.getEditor(Side.LEFT).getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener);
        this.getEditor(Side.RIGHT).getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener);
        SyncScrollSupport.SyncScrollable scrollable = this.getSyncScrollable();
        if (scrollable != null) {
            this.mySyncScrollSupport = new SyncScrollSupport.TwosideSyncScrollSupport(this.getEditors(), scrollable);
        }
    }

    protected void destroyEditorListeners() {
        this.getEditor(Side.LEFT).getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener);
        this.getEditor(Side.RIGHT).getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener);
        this.mySyncScrollSupport = null;
    }

    protected void disableSyncScrollSupport(boolean disable) {
        if (this.mySyncScrollSupport != null) {
            if (disable) {
                this.mySyncScrollSupport.enterDisableScrollSection();
            } else {
                this.mySyncScrollSupport.exitDisableScrollSection();
            }
        }
    }

    @NotNull
    protected List<? extends DocumentContent> getContents() {
        return this.myRequest.getContents();
    }

    @NotNull
    public List<? extends EditorEx> getEditors() {
        if (this.myEditors == null) {
            this.myEditors = ContainerUtil.map(this.getEditorHolders(), (Function)new Function<TextEditorHolder, EditorEx>(){

                public EditorEx fun(TextEditorHolder holder) {
                    return holder.getEditor();
                }
            });
        }
        return this.myEditors;
    }

    @NotNull
    protected List<? extends EditorEx> getEditableEditors() {
        return this.myEditableEditors;
    }

    @NotNull
    public EditorEx getCurrentEditor() {
        return this.getEditor(this.getCurrentSide());
    }

    @NotNull
    public DocumentContent getCurrentContent() {
        return this.getContent(this.getCurrentSide());
    }

    @NotNull
    public EditorEx getEditor1() {
        return this.getEditor(Side.LEFT);
    }

    @NotNull
    public EditorEx getEditor2() {
        return this.getEditor(Side.RIGHT);
    }

    @NotNull
    public EditorEx getEditor(@NotNull Side side) {
        return (EditorEx)side.select(this.getEditors());
    }

    @NotNull
    public DocumentContent getContent(@NotNull Side side) {
        return (DocumentContent)side.select(this.getContents());
    }

    @NotNull
    public DocumentContent getContent1() {
        return this.getContent(Side.LEFT);
    }

    @NotNull
    public DocumentContent getContent2() {
        return this.getContent(Side.RIGHT);
    }

    @Nullable
    public SyncScrollSupport.TwosideSyncScrollSupport getSyncScrollSupport() {
        return this.mySyncScrollSupport;
    }

    @NotNull
    protected LogicalPosition transferPosition(@NotNull Side baseSide, @NotNull LogicalPosition position) {
        if (this.mySyncScrollSupport == null) {
            return position;
        }
        int line = this.mySyncScrollSupport.getScrollable().transfer(baseSide, position.line);
        return new LogicalPosition(line, position.column);
    }

    protected void scrollToLine(@NotNull Side side, int line) {
        DiffUtil.scrollEditor(this.getEditor(side), line, false);
        this.setCurrentSide(side);
    }

    @Nullable
    protected abstract SyncScrollSupport.SyncScrollable getSyncScrollable();

    @Override
    @Nullable
    protected OpenFileDescriptor getOpenFileDescriptor() {
        Side side = this.getCurrentSide();
        int offset = this.getEditor(side).getCaretModel().getOffset();
        OpenFileDescriptor descriptor = this.getContent(side).getOpenFileDescriptor(offset);
        if (descriptor != null) {
            return descriptor;
        }
        LogicalPosition otherPosition = this.transferPosition(side, this.getEditor(side).getCaretModel().getLogicalPosition());
        int otherOffset = this.getEditor(side.other()).logicalPositionToOffset(otherPosition);
        return this.getContent(side.other()).getOpenFileDescriptor(otherOffset);
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        return TwosideDiffViewer.canShowRequest(context, request, TextEditorHolder.TextEditorHolderFactory.INSTANCE);
    }

    @Override
    @Nullable
    public Object getData(@NonNls String dataId) {
        if (DiffDataKeys.CURRENT_EDITOR.is(dataId)) {
            return this.getCurrentEditor();
        }
        return super.getData(dataId);
    }

    protected abstract class MyInitialScrollPositionHelper
    extends InitialScrollPositionSupport.TwosideInitialScrollHelper {
        protected MyInitialScrollPositionHelper() {
        }

        @Override
        @NotNull
        protected List<? extends Editor> getEditors() {
            return TwosideTextDiffViewer.this.getEditors();
        }

        @Override
        protected void disableSyncScroll(boolean value) {
            TwosideTextDiffViewer.this.disableSyncScrollSupport(value);
        }

        @Override
        protected boolean doScrollToLine() {
            if (this.myScrollToLine == null) {
                return false;
            }
            TwosideTextDiffViewer.this.scrollToLine((Side)this.myScrollToLine.first, (Integer)this.myScrollToLine.second);
            return true;
        }
    }

    private class MyVisibleAreaListener
    implements VisibleAreaListener {
        private MyVisibleAreaListener() {
        }

        public void visibleAreaChanged(VisibleAreaEvent e) {
            if (TwosideTextDiffViewer.this.mySyncScrollSupport != null) {
                TwosideTextDiffViewer.this.mySyncScrollSupport.visibleAreaChanged(e);
            }
            if (Registry.is((String)"diff.divider.repainting.fix")) {
                TwosideTextDiffViewer.this.myContentPanel.repaint();
            } else {
                TwosideTextDiffViewer.this.myContentPanel.repaintDivider();
            }
        }
    }

    protected class MyToggleAutoScrollAction
    extends TextDiffViewerUtil.ToggleAutoScrollAction {
        public MyToggleAutoScrollAction() {
            super(TwosideTextDiffViewer.this.getTextSettings());
        }
    }

    private class MyOpenInEditorWithMouseAction
    extends OpenInEditorWithMouseAction {
        private MyOpenInEditorWithMouseAction() {
        }

        @Override
        protected OpenFileDescriptor getDescriptor(@NotNull Editor editor, int line) {
            Side side = null;
            if (editor == TwosideTextDiffViewer.this.getEditor(Side.LEFT)) {
                side = Side.LEFT;
            }
            if (editor == TwosideTextDiffViewer.this.getEditor(Side.RIGHT)) {
                side = Side.RIGHT;
            }
            if (side == null) {
                return null;
            }
            int offset = editor.logicalPositionToOffset(new LogicalPosition(line, 0));
            return TwosideTextDiffViewer.this.getContent(side).getOpenFileDescriptor(offset);
        }
    }

    private class MyFocusOppositePaneAction
    extends FocusOppositePaneAction {
        public MyFocusOppositePaneAction(boolean scrollToPosition) {
            super(scrollToPosition);
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            Side currentSide = TwosideTextDiffViewer.this.getCurrentSide();
            Side targetSide = currentSide.other();
            EditorEx currentEditor = TwosideTextDiffViewer.this.getEditor(currentSide);
            EditorEx targetEditor = TwosideTextDiffViewer.this.getEditor(targetSide);
            if (this.myScrollToPosition) {
                LogicalPosition position = TwosideTextDiffViewer.this.transferPosition(currentSide, currentEditor.getCaretModel().getLogicalPosition());
                targetEditor.getCaretModel().moveToLogicalPosition(position);
            }
            TwosideTextDiffViewer.this.setCurrentSide(targetSide);
            currentEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            DiffUtil.requestFocus(TwosideTextDiffViewer.this.getProject(), TwosideTextDiffViewer.this.getPreferredFocusedComponent());
        }
    }
}

