/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.diff.DiffContext;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.icons.AllIcons;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.ToggleActionButton;
import com.intellij.util.EditorPopupHandler;
import com.intellij.util.containers.ContainerUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class TextDiffViewerUtil {
    public static final Logger LOG = Logger.getInstance(TextDiffViewerUtil.class);

    @NotNull
    public static List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        result.add(ActionManager.getInstance().getAction("CompareClipboardWithSelection"));
        result.add((AnAction)Separator.getInstance());
        ContainerUtil.addAll(result, (Object[])((ActionGroup)ActionManager.getInstance().getAction("Diff.EditorPopupMenu")).getChildren(null));
        return result;
    }

    @NotNull
    public static FoldingModelSupport.Settings getFoldingModelSettings(@NotNull DiffContext context) {
        TextDiffSettingsHolder.TextDiffSettings settings = TextDiffViewerUtil.getTextSettings(context);
        return new FoldingModelSupport.Settings(settings.getContextRange(), settings.isExpandByDefault());
    }

    @NotNull
    public static TextDiffSettingsHolder.TextDiffSettings getTextSettings(@NotNull DiffContext context) {
        TextDiffSettingsHolder.TextDiffSettings settings = (TextDiffSettingsHolder.TextDiffSettings)context.getUserData(TextDiffSettingsHolder.KEY);
        if (settings == null) {
            settings = TextDiffSettingsHolder.TextDiffSettings.getSettings((String)context.getUserData(DiffUserDataKeys.PLACE));
            context.putUserData(TextDiffSettingsHolder.KEY, (Object)settings);
            if (DiffUtil.isUserDataFlagSet((Key<Boolean>)DiffUserDataKeys.DO_NOT_IGNORE_WHITESPACES, new UserDataHolder[]{context})) {
                settings.setIgnorePolicy(IgnorePolicy.DEFAULT);
            }
        }
        return settings;
    }

    @NotNull
    public static boolean[] checkForceReadOnly(@NotNull DiffContext context, @NotNull ContentDiffRequest request) {
        int contentCount = request.getContents().size();
        boolean[] result = new boolean[contentCount];
        if (DiffUtil.isUserDataFlagSet((Key<Boolean>)DiffUserDataKeys.FORCE_READ_ONLY, new UserDataHolder[]{request, context})) {
            Arrays.fill(result, true);
            return result;
        }
        boolean[] data = (boolean[])request.getUserData(DiffUserDataKeys.FORCE_READ_ONLY_CONTENTS);
        if (data != null && data.length == contentCount) {
            return data;
        }
        return result;
    }

    public static void checkDifferentDocuments(@NotNull ContentDiffRequest request) {
        List contents = request.getContents();
        boolean sameDocuments = false;
        for (int i = 0; i < contents.size(); ++i) {
            for (int j = i + 1; j < contents.size(); ++j) {
                DiffContent content1 = (DiffContent)contents.get(i);
                DiffContent content2 = (DiffContent)contents.get(j);
                if (!(content1 instanceof DocumentContent) || !(content2 instanceof DocumentContent)) continue;
                sameDocuments |= ((DocumentContent)content1).getDocument() == ((DocumentContent)content2).getDocument();
            }
        }
        if (sameDocuments) {
            StringBuilder message = new StringBuilder();
            message.append("DiffRequest with same documents detected\n");
            message.append(request.toString()).append("\n");
            for (DiffContent content : contents) {
                message.append(content.toString()).append("\n");
            }
            LOG.warn(new Throwable(message.toString()));
        }
    }

    @NotNull
    public static List<? extends EditorEx> getEditableEditors(@NotNull List<? extends EditorEx> editors) {
        return ContainerUtil.filter(editors, (Condition)new Condition<EditorEx>(){

            public boolean value(EditorEx editor) {
                return editor != null && !editor.isViewer();
            }
        });
    }

    public static class EditorActionsPopup
    extends EditorPopupHandler {
        @NotNull
        private final List<? extends AnAction> myEditorPopupActions;

        public EditorActionsPopup(@NotNull List<? extends AnAction> editorPopupActions) {
            this.myEditorPopupActions = editorPopupActions;
        }

        public void install(@NotNull List<? extends EditorEx> editors) {
            for (EditorEx editorEx : editors) {
                if (editorEx == null) continue;
                editorEx.addEditorMouseListener((EditorMouseListener)this);
                editorEx.setContextMenuGroupId(null);
            }
        }

        @Override
        public void invokePopup(EditorMouseEvent event) {
            if (this.myEditorPopupActions.isEmpty()) {
                return;
            }
            DefaultActionGroup group = new DefaultActionGroup(this.myEditorPopupActions);
            EditorPopupHandler handler2 = EditorActionUtil.createEditorPopupHandler((ActionGroup)group);
            handler2.invokePopup(event);
        }
    }

    public static class EditorFontSizeSynchronizer
    implements PropertyChangeListener {
        @NotNull
        private final List<? extends EditorEx> myEditors;
        private boolean myDuringUpdate = false;

        public EditorFontSizeSynchronizer(@NotNull List<? extends EditorEx> editors) {
            this.myEditors = editors;
        }

        public void install(@NotNull Disposable disposable) {
            if (ContainerUtil.skipNulls(this.myEditors).size() < 2) {
                return;
            }
            for (EditorEx editorEx : this.myEditors) {
                if (editorEx == null) continue;
                editorEx.addPropertyChangeListener(this, disposable);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.myDuringUpdate) {
                return;
            }
            if (!"fontSize".equals(evt.getPropertyName())) {
                return;
            }
            if (evt.getOldValue().equals(evt.getNewValue())) {
                return;
            }
            int fontSize = (Integer)evt.getNewValue();
            for (EditorEx editorEx : this.myEditors) {
                if (editorEx == null || evt.getSource() == editorEx) continue;
                this.updateEditor(editorEx, fontSize);
            }
        }

        public void updateEditor(@NotNull EditorEx editor, int fontSize) {
            try {
                this.myDuringUpdate = true;
                editor.setFontSize(fontSize);
            }
            finally {
                this.myDuringUpdate = false;
            }
        }
    }

    public static class EditorReadOnlyLockAction
    extends ReadOnlyLockAction {
        private final List<? extends EditorEx> myEditableEditors;

        public EditorReadOnlyLockAction(@NotNull DiffContext context, @NotNull List<? extends EditorEx> editableEditors) {
            super(context);
            this.myEditableEditors = editableEditors;
            this.applyDefaults();
        }

        @Override
        protected void doApply(boolean readOnly) {
            for (EditorEx editorEx : this.myEditableEditors) {
                editorEx.setViewer(readOnly);
            }
        }

        @Override
        protected boolean canEdit() {
            return !this.myEditableEditors.isEmpty();
        }
    }

    public static abstract class ReadOnlyLockAction
    extends ToggleAction
    implements DumbAware {
        @NotNull
        protected final DiffContext myContext;
        @NotNull
        protected final TextDiffSettingsHolder.TextDiffSettings mySettings;

        public ReadOnlyLockAction(@NotNull DiffContext context) {
            super("Disable editing", null, AllIcons.Nodes.Padlock);
            this.myContext = context;
            this.mySettings = TextDiffViewerUtil.getTextSettings(context);
            this.setEnabledInModalContext(true);
        }

        protected void applyDefaults() {
            if (this.isVisible()) {
                this.setSelected(null, this.isSelected(null));
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (!this.isVisible()) {
                e.getPresentation().setEnabledAndVisible(false);
            } else {
                super.update(e);
            }
        }

        public boolean isSelected(AnActionEvent e) {
            return this.mySettings.isReadOnlyLock();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.mySettings.setReadOnlyLock(state);
            this.doApply(state);
        }

        private boolean isVisible() {
            return this.myContext.getUserData(DiffUserDataKeysEx.SHOW_READ_ONLY_LOCK) == Boolean.TRUE && this.canEdit();
        }

        protected abstract void doApply(boolean var1);

        protected abstract boolean canEdit();
    }

    public static abstract class ToggleExpandByDefaultAction
    extends ToggleActionButton
    implements DumbAware {
        @NotNull
        protected final TextDiffSettingsHolder.TextDiffSettings mySettings;

        public ToggleExpandByDefaultAction(@NotNull TextDiffSettingsHolder.TextDiffSettings settings) {
            super("Collapse unchanged fragments", AllIcons.Actions.Collapseall);
            this.mySettings = settings;
            this.setEnabledInModalContext(true);
        }

        public boolean isVisible() {
            return this.mySettings.getContextRange() != -1;
        }

        public boolean isSelected(AnActionEvent e) {
            return !this.mySettings.isExpandByDefault();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            boolean expand;
            boolean bl = expand = !state;
            if (this.mySettings.isExpandByDefault() == expand) {
                return;
            }
            this.mySettings.setExpandByDefault(expand);
            this.expandAll(expand);
        }

        protected abstract void expandAll(boolean var1);
    }

    public static class ToggleAutoScrollAction
    extends ToggleActionButton
    implements DumbAware {
        @NotNull
        protected final TextDiffSettingsHolder.TextDiffSettings mySettings;

        public ToggleAutoScrollAction(@NotNull TextDiffSettingsHolder.TextDiffSettings settings) {
            super("Synchronize Scrolling", AllIcons.Actions.SynchronizeScrolling);
            this.mySettings = settings;
            this.setEnabledInModalContext(true);
        }

        public boolean isSelected(AnActionEvent e) {
            return this.mySettings.isEnableSyncScroll();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.mySettings.setEnableSyncScroll(state);
        }
    }

    public static abstract class IgnorePolicySettingAction
    extends ComboBoxSettingAction<IgnorePolicy> {
        @NotNull
        protected final TextDiffSettingsHolder.TextDiffSettings mySettings;

        public IgnorePolicySettingAction(@NotNull TextDiffSettingsHolder.TextDiffSettings settings) {
            this.mySettings = settings;
        }

        @Override
        protected void applySetting(@NotNull IgnorePolicy setting, @NotNull AnActionEvent e) {
            if (this.getCurrentSetting() == setting) {
                return;
            }
            UsageTrigger.trigger("diff.TextDiffSettings.IgnorePolicy." + setting.name());
            this.mySettings.setIgnorePolicy(setting);
            this.update(e);
            this.onSettingsChanged();
        }

        @Override
        @NotNull
        protected IgnorePolicy getCurrentSetting() {
            return this.mySettings.getIgnorePolicy();
        }

        @Override
        @NotNull
        protected String getText(@NotNull IgnorePolicy setting) {
            return setting.getText();
        }

        @Override
        @NotNull
        protected List<IgnorePolicy> getAvailableSettings() {
            return Arrays.asList(IgnorePolicy.values());
        }

        protected abstract void onSettingsChanged();
    }

    public static abstract class HighlightPolicySettingAction
    extends ComboBoxSettingAction<HighlightPolicy> {
        @NotNull
        protected final TextDiffSettingsHolder.TextDiffSettings mySettings;

        public HighlightPolicySettingAction(@NotNull TextDiffSettingsHolder.TextDiffSettings settings) {
            this.mySettings = settings;
        }

        @Override
        protected void applySetting(@NotNull HighlightPolicy setting, @NotNull AnActionEvent e) {
            if (this.getCurrentSetting() == setting) {
                return;
            }
            UsageTrigger.trigger("diff.TextDiffSettings.HighlightPolicy." + setting.name());
            this.mySettings.setHighlightPolicy(setting);
            this.update(e);
            this.onSettingsChanged();
        }

        @Override
        @NotNull
        protected HighlightPolicy getCurrentSetting() {
            return this.mySettings.getHighlightPolicy();
        }

        @Override
        @NotNull
        protected String getText(@NotNull HighlightPolicy setting) {
            return setting.getText();
        }

        @Override
        @NotNull
        protected List<HighlightPolicy> getAvailableSettings() {
            return Arrays.asList(HighlightPolicy.values());
        }

        protected abstract void onSettingsChanged();
    }

    public static abstract class ComboBoxSettingAction<T>
    extends ComboBoxAction
    implements DumbAware {
        private DefaultActionGroup myChildren;

        public ComboBoxSettingAction() {
            this.setEnabledInModalContext(true);
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setText(this.getText(this.getCurrentSetting()));
        }

        @NotNull
        public DefaultActionGroup getPopupGroup() {
            this.initChildren();
            return this.myChildren;
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button) {
            this.initChildren();
            return this.myChildren;
        }

        private void initChildren() {
            if (this.myChildren == null) {
                this.myChildren = new DefaultActionGroup();
                for (T setting : this.getAvailableSettings()) {
                    this.myChildren.add((AnAction)new MyAction(setting));
                }
            }
        }

        @NotNull
        protected abstract List<T> getAvailableSettings();

        @NotNull
        protected abstract String getText(@NotNull T var1);

        @NotNull
        protected abstract T getCurrentSetting();

        protected abstract void applySetting(@NotNull T var1, @NotNull AnActionEvent var2);

        private class MyAction
        extends AnAction
        implements DumbAware {
            @NotNull
            private final T mySetting;

            public MyAction(T setting) {
                super(ComboBoxSettingAction.this.getText(setting));
                this.setEnabledInModalContext(true);
                this.mySetting = setting;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                ComboBoxSettingAction.this.applySetting(this.mySetting, e);
            }
        }
    }
}

