/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import org.jetbrains.annotations.NotNull;

public enum HighlightPolicy {
    BY_LINE("Highlight lines"),
    BY_WORD("Highlight words"),
    BY_WORD_SPLIT("Highlight split changes"),
    DO_NOT_HIGHLIGHT("Do not highlight");

    @NotNull
    private final String myText;

    private HighlightPolicy(String text) {
        this.myText = text;
    }

    @NotNull
    public String getText() {
        return this.myText;
    }

    public boolean isShouldCompare() {
        return this != DO_NOT_HIGHLIGHT;
    }

    public boolean isFineFragments() {
        return this == BY_WORD || this == BY_WORD_SPLIT;
    }

    public boolean isShouldSquash() {
        return this == BY_WORD || this == BY_LINE;
    }
}

