/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.DiffContext;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.holders.EditorHolder;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.util.UserDataHolder;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class FocusTrackerSupport<S> {
    @NotNull
    public abstract S getCurrentSide();

    public abstract void setCurrentSide(@NotNull S var1);

    public abstract void processContextHints(@NotNull DiffRequest var1, @NotNull DiffContext var2);

    public abstract void updateContextHints(@NotNull DiffRequest var1, @NotNull DiffContext var2);

    public static class Threeside
    extends FocusTrackerSupport<ThreeSide> {
        @NotNull
        private ThreeSide myCurrentSide = ThreeSide.BASE;

        public Threeside(@NotNull List<? extends EditorHolder> holders) {
            this.addListener(holders, ThreeSide.LEFT);
            this.addListener(holders, ThreeSide.BASE);
            this.addListener(holders, ThreeSide.RIGHT);
        }

        @Override
        @NotNull
        public ThreeSide getCurrentSide() {
            return this.myCurrentSide;
        }

        @Override
        public void setCurrentSide(@NotNull ThreeSide side) {
            this.myCurrentSide = side;
        }

        @Override
        public void processContextHints(@NotNull DiffRequest request, @NotNull DiffContext context) {
            ThreeSide side = (ThreeSide)DiffUtil.getUserData((UserDataHolder)request, (UserDataHolder)context, DiffUserDataKeys.PREFERRED_FOCUS_THREESIDE);
            if (side != null) {
                this.setCurrentSide(side);
            }
        }

        @Override
        public void updateContextHints(@NotNull DiffRequest request, @NotNull DiffContext context) {
            context.putUserData(DiffUserDataKeys.PREFERRED_FOCUS_THREESIDE, (Object)this.myCurrentSide);
        }

        private void addListener(@NotNull List<? extends EditorHolder> holders, @NotNull ThreeSide side) {
            ((EditorHolder)side.select(holders)).installFocusListener(new MyFocusListener(side));
        }

        private class MyFocusListener
        extends FocusAdapter {
            @NotNull
            private final ThreeSide mySide;

            private MyFocusListener(ThreeSide side) {
                this.mySide = side;
            }

            @Override
            public void focusGained(FocusEvent e) {
                Threeside.this.myCurrentSide = this.mySide;
            }
        }
    }

    public static class Twoside
    extends FocusTrackerSupport<Side> {
        @NotNull
        private Side myCurrentSide;

        public Twoside(@NotNull List<? extends EditorHolder> holders) {
            assert (holders.size() == 2);
            this.myCurrentSide = Side.RIGHT;
            this.addListener(holders, Side.LEFT);
            this.addListener(holders, Side.RIGHT);
        }

        @Override
        @NotNull
        public Side getCurrentSide() {
            return this.myCurrentSide;
        }

        @Override
        public void setCurrentSide(@NotNull Side side) {
            this.myCurrentSide = side;
        }

        @Override
        public void processContextHints(@NotNull DiffRequest request, @NotNull DiffContext context) {
            Side side = (Side)DiffUtil.getUserData((UserDataHolder)request, (UserDataHolder)context, DiffUserDataKeys.PREFERRED_FOCUS_SIDE);
            if (side != null) {
                this.setCurrentSide(side);
            }
        }

        @Override
        public void updateContextHints(@NotNull DiffRequest request, @NotNull DiffContext context) {
            context.putUserData(DiffUserDataKeys.PREFERRED_FOCUS_SIDE, (Object)this.myCurrentSide);
        }

        private void addListener(@NotNull List<? extends EditorHolder> holders, @NotNull Side side) {
            ((EditorHolder)side.select(holders)).installFocusListener(new MyFocusListener(side));
        }

        private class MyFocusListener
        extends FocusAdapter {
            @NotNull
            private final Side mySide;

            private MyFocusListener(Side side) {
                this.mySide = side;
            }

            @Override
            public void focusGained(FocusEvent e) {
                Twoside.this.myCurrentSide = this.mySide;
            }
        }
    }
}

