/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.ui.EditorNotificationPanel;
import java.awt.Color;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffNotifications {
    @Deprecated
    @NotNull
    public static final JPanel INSERTED_CONTENT = DiffNotifications.createInsertedContent();
    @Deprecated
    @NotNull
    public static final JPanel REMOVED_CONTENT = DiffNotifications.createRemovedContent();
    @Deprecated
    @NotNull
    public static final JPanel EQUAL_CONTENTS = DiffNotifications.createEqualContents();
    @Deprecated
    @NotNull
    public static final JPanel ERROR = DiffNotifications.createError();
    @Deprecated
    @NotNull
    public static final JPanel OPERATION_CANCELED = DiffNotifications.createOperationCanceled();
    @Deprecated
    @NotNull
    public static final JPanel DIFF_TOO_BIG = DiffNotifications.createDiffTooBig();

    @NotNull
    public static JPanel createInsertedContent() {
        return DiffNotifications.createNotification("Content added", TextDiffType.INSERTED.getColor(null));
    }

    @NotNull
    public static JPanel createRemovedContent() {
        return DiffNotifications.createNotification("Content removed", TextDiffType.DELETED.getColor(null));
    }

    @NotNull
    public static JPanel createEqualContents() {
        return DiffNotifications.createNotification(DiffBundle.message((String)"diff.contents.are.identical.message.text", (Object[])new Object[0]));
    }

    @NotNull
    public static JPanel createError() {
        return DiffNotifications.createNotification("Can not calculate diff");
    }

    @NotNull
    public static JPanel createOperationCanceled() {
        return DiffNotifications.createNotification("Can not calculate diff. Operation canceled.");
    }

    @NotNull
    public static JPanel createDiffTooBig() {
        return DiffNotifications.createNotification("Can not calculate diff. File is too big and there are too many changes.");
    }

    @NotNull
    public static JPanel createNotification(@NotNull String text) {
        return DiffNotifications.createNotification(text, null);
    }

    @NotNull
    public static JPanel createNotification(@NotNull String text, @Nullable Color background) {
        return DiffNotifications.createNotification(text, background, true);
    }

    @NotNull
    public static JPanel createNotification(@NotNull String text, @Nullable Color background, boolean showHideAction) {
        final MyEditorNotificationPanel panel = new MyEditorNotificationPanel();
        panel.text(text);
        panel.setBackgroundColor(background);
        if (showHideAction) {
            panel.createActionLabel("Hide", new Runnable(){

                @Override
                public void run() {
                    panel.setVisible(false);
                }
            }).setToolTipText("Hide this notification");
        }
        return panel;
    }

    private static class MyEditorNotificationPanel
    extends EditorNotificationPanel {
        @Nullable
        private Color myBackground;

        private MyEditorNotificationPanel() {
        }

        public void setBackgroundColor(@Nullable Color value) {
            this.myBackground = value;
        }

        @Nullable
        public Color getBackground() {
            return this.myBackground != null ? this.myBackground : super.getBackground();
        }
    }
}

